C
C
      SUBROUTINE WGBFNT$(IFONT, NFONT, 
     +                   SLANT)
C
C ACTION: returns IFONT, NFONT and SLANT
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 26/10/2000
C         23/04/2007 added INTENTS
C
C         IFONT = Hershey font identifier
C         NFONT = PostScript font identifier
C         SLANT = Hershey slant angle
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,          INTENT (OUT) :: IFONT, NFONT 
      DOUBLE PRECISION, INTENT (OUT) :: SLANT
C
C Locals
C      
      INTEGER    N11
      PARAMETER (N11 = 11)
      DOUBLE PRECISION WGBCFG$
      DOUBLE PRECISION ZERO, TWENTY
      PARAMETER (ZERO = 0.0D+00, TWENTY = 20.0D+00)
      EXTERNAL   WGBCFG$
      INTRINSIC  NINT
      NFONT = NINT(WGBCFG$(N11))
      IF (NFONT.LE.2) THEN
C
C Times-Roman
C
         IFONT = 106
         SLANT = ZERO
      ELSEIF (NFONT.LE.4) THEN
C
C Times-Italic
C
         IFONT = 107
         SLANT = ZERO
      ELSE
C
C Helvetica
C
         IFONT = 102
         IF (NFONT.EQ.7  .OR. NFONT.EQ.8 .OR.
     +       NFONT.EQ.11 .OR. NFONT.EQ.12) THEN
            SLANT = TWENTY
         ELSE
            SLANT = ZERO
         ENDIF
      ENDIF
      END
C 
C