C
C
      SUBROUTINE WGBINI$(ISEND)
C
C ACTION: restore defaults in W_PS.CFG
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 23/02/2000
C         23/01/2007 added FULL_PATH and SIM256
C
C
C  NOTE: This overwrites w_ps.cfg if it is not read-only.
C        It is used as follows:-
C
C         ISEND = -1: strict check for excessive values and set SIZE = 1
C                     (called from w_simfit.exe on start-up)
C         ISEND =  0: modest check for excessive values then correct
C                     (called from w_simfit.exe on start-up)
C         ISEND =  1: save and re-set SIZE and THICK to 1
C                     (called from Hershey before display)
C         ISEND =  2: restore SIZE and THICK after call with ISEND = 1
C                     (called from Heshey after display)
C         ISEND =  3: save and re-set SIZE to 1
C                     (called from GKSBOX before display)
C         ISEND =  4: restore SIZE after call with ISEND = 3
C                     (called from GKSBOX after display)
C
      IMPLICIT   NONE 
C
C Argument
C      
      INTEGER, INTENT (IN) :: ISEND 
C
C Locals
C      
      INTEGER    I, ICOUNT, IOS, NOUT
      INTEGER    IDEV, IVAL
      INTEGER    NMAX
      PARAMETER (NMAX = 100)
      DOUBLE PRECISION SIZE_1, SIZE_SAV, THICK, THICK_SAV
      DOUBLE PRECISION ONE, SMAX, SMIN, TMAX, TMIN
      PARAMETER (ONE = 1.0D+00, SMAX = 1.50D+00, SMIN = 0.75D+00,
     +           TMAX = 2.0D+00, TMIN = 0.5D+00)
      CHARACTER  TEMP*1024, TEXT(NMAX)*1024
      CHARACTER  FULL_PATH*1024, SIM256*1024
      CHARACTER  PSCFG*8
      PARAMETER (PSCFG = 'w_ps.cfg')
      LOGICAL    THERE, READ_ONLY
      EXTERNAL   ATTRIB, GETNOU, SIM256
      SAVE       SIZE_SAV, THICK_SAV
      DATA       SIZE_SAV, THICK_SAV / ONE, ONE /
C
C Check that ISEND is in range
C
      IF (ISEND.LT.-1 .OR. ISEND.GT.4) RETURN
C
C Does W_PS.CFG exist and is it read only
C
      FULL_PATH = SIM256(PSCFG)
      CALL ATTRIB (FULL_PATH,
     +             THERE, READ_ONLY)
      IF (THERE .AND. .NOT.READ_ONLY) THEN
C
C Open the file
C
         CALL GETNOU (NOUT)
         OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
         IF (IOS.EQ.0) THEN
C
C Check the first line and restore if extreme values encountered
C
            READ (NOUT,*,END=40,ERR=40,IOSTAT=IOS) IDEV, IVAL, THICK,
     +                                             SIZE_1
            IF (IOS.NE.0) GOTO 40
            IF (ISEND.EQ.- 1) THEN
               SIZE_1 = ONE
               IF (THICK.LT.TMIN) THEN
                  THICK = TMIN
               ELSEIF (THICK.GT.TMAX) THEN
                  THICK = TMAX
               ENDIF
            ELSEIF (ISEND.EQ.0) THEN
               IF (SIZE_1.LT.SMIN) THEN
                  SIZE_1 = SMIN
               ELSEIF (SIZE_1.GT.SMAX) THEN
                  SIZE_1 = SMAX
               ENDIF
               IF (THICK.LT.TMIN) THEN
                  THICK = TMIN
               ELSEIF (THICK.GT.TMAX + ONE) THEN
                  THICK = TMAX + ONE
               ENDIF
            ELSEIF (ISEND.EQ.1) THEN
               SIZE_SAV = SIZE_1
               THICK_SAV = THICK
               SIZE_1 = ONE
               THICK = ONE
            ELSEIF (ISEND.EQ.2) THEN
               SIZE_1 = SIZE_SAV
               THICK = THICK_SAV
            ELSEIF (ISEND.EQ.3) THEN
               SIZE_SAV = SIZE_1
               SIZE_1 = ONE
            ELSEIF (ISEND.EQ.4) THEN
               SIZE_1 = SIZE_SAV
            ENDIF
C
C Read the rest of the file
C
            IOS = 0
            ICOUNT = 0
            DO WHILE (IOS.EQ.0)
               READ (NOUT,100,END=20,ERR=40,IOSTAT=IOS) TEMP
               IF (IOS .NE. 0) GOTO 20
               ICOUNT = ICOUNT + 1
               IF (ICOUNT .GT. NMAX) GOTO 40
               TEXT(ICOUNT) = TEMP
            ENDDO
   20       CONTINUE
            REWIND (UNIT = NOUT, ERR = 40, IOSTAT = IOS)
            IF (IOS.NE.0) GOTO 40
            WRITE (NOUT,200) IDEV, IVAL, THICK, SIZE_1
            DO I = 1, ICOUNT
               WRITE (NOUT,100) TEXT(I)
            ENDDO
         ENDIF
   40    CONTINUE
         CLOSE (UNIT = NOUT)
      ENDIF 
C
C Format statements
C      
  100 FORMAT (A)
  200 FORMAT (2I8,2F8.2)
      END
C 
C