C
C
      SUBROUTINE WGBLPT$(PORT, IDEV, ABORT)
C
C ACTION : Warn user to check if LPT (or COM is) connected
C          This version is specially for PostScript
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 28/10/94
C          12/12/1997 Win32 version
C          14/11/2003 edited for colour and format data
C          15/01/2007 edited for Linux
C
C  PORT: (input/unchanged) port definition
C  IDEV: (input/unchanged) port number (0 to switch off)
C ABORT: (output) error indicator
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: IDEV
      CHARACTER (LEN = *), INTENT (IN)  :: PORT
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    NUMHDR
      PARAMETER (NUMHDR = 20)
      INTEGER    ICOLOR
      PARAMETER (ICOLOR = 9)
      INTEGER    NUMBLD(20)
      CHARACTER  HEADER(20)*72, OPTION*72
      LOGICAL    LINUX3
      LOGICAL    OK, OKCOM(4), OKLPT(4)
      EXTERNAL   ANSWER, LINUX3
      SAVE       OKCOM, OKLPT
      DATA       OKCOM / .FALSE., .FALSE., .FALSE., .FALSE. /
      DATA       OKLPT / .FALSE., .FALSE., .FALSE., .FALSE. /
      DATA       NUMBLD / 20*0 /
C
C Ignore in Linux
C
      ABORT = .FALSE.
      IF (LINUX3('*')) RETURN
      ABORT = .TRUE.
C
C Check PORT/IDEV then OK to see if port has already been used
C
      IF (PORT.NE.'LPT' .AND. PORT.NE.'lpt' .AND.
     +    PORT.NE.'COM' .AND. PORT.NE.'com') RETURN
      IF (IDEV.LT.1 .OR. IDEV.GT.4) RETURN
      IF (PORT.EQ.'LPT' .OR. PORT.EQ.'lpt') THEN
         OK = OKLPT(IDEV)
      ELSE
         OK = OKCOM(IDEV)
      ENDIF
      IF (OK) THEN
         ABORT = .FALSE.
         RETURN
      ENDIF
C
C Port has not yet been used
C
      WRITE (HEADER,100) PORT, IDEV
      WRITE (OPTION,200) PORT, IDEV
      OK = .FALSE.
      NUMBLD(1) = 1
      NUMBLD(2) = 1
      NUMBLD(3) = 1
      CALL ANSWER (ICOLOR, NUMBLD, NUMHDR,
     +             HEADER, OPTION,
     +             OK)
      IF (OK) THEN
         IF (PORT.EQ.'LPT' .OR. PORT.EQ.'lpt') THEN
            OKLPT(IDEV) = .TRUE.
         ELSE
            OKCOM(IDEV) = .TRUE.
         ENDIF
         ABORT = .FALSE.
      ELSE
         ABORT = .TRUE.
      ENDIF
C
C Format statements
C
  100 FORMAT (
     + 'Simfit can now drive PostScript or non-Postscript printers by'
     +/'making a temporary EPS file and copying it to a printer using a'
     +/'specified driver e.g. GSview, redpr, gsprint, print-file, etc.'
     +/
     +/'If your PS-driver is a PS-package like GSview/Ghostscript, you'
     +/'can now proceed to drive any printer.'
     +/'If your PS-driver is a program like redpr.exe you, must have a'
     +/'PS printer connected to ',A,I1,' to accept PostScript code.'
     +/'To configure Simfit for your printer, edit the arguments and'
     +/'path/filename for a driver from the configuration option.'
     +/
     +/'You can adjust X,Y offsets and scaling to get plots of any'
     +/'size, but it is best to save files with the default sizes'
     +/'since you can always re-size these using program Editps.'
     +/
     +/'Note that it is better to save .eps files for documents, making'
     +/'into collages with Editps, archiving, etc. than to print now.'
     +/
     +/'You can also print PostScript files on a PostScript printer'
     +/'using a command line, e.g. in DOS use....copy myfile.eps lpt1.')
  200 FORMAT (
     + 'Copy the PostScript file to ',A,I1,' ?')
      END
C 
C