C
C
      SUBROUTINE WGBTRN$(FNAME)
C
C ACTION : transform FNAME
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 19/11/98
C          20/08/2003 added option to add to archive
C          30/09/2006 added FNAME1 and SUPPLY in call to transformation routines
C          19/05/2017 used SUPPLY = .FALSE. for call to PS2PDF
C
      IMPLICIT   NONE
C
C Argument
C
      CHARACTER (LEN = *), INTENT (IN) :: FNAME
C
C Locals
C
      INTEGER    ICOLOR, ITYPE, IX, IY, LSHADE, NSTART, NUMDEC, NUMOPT,
     +           NTEXT
      PARAMETER (ICOLOR = 9, ITYPE = 6, IX = 4, IY = 4, LSHADE = 1,
     +           NSTART = 8, NUMOPT = 11)
      INTEGER    NUMBLD(30)
      CHARACTER  TEXT(30)*100, WORD60*60
      CHARACTER  FNAME1*1024, TRIM60*60
      LOGICAL    AGAIN
      LOGICAL    ASKIF, BORDER, TITLES
      PARAMETER (ASKIF = .TRUE., BORDER = .FALSE., TITLES = .TRUE.)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   PS2BMP, PS2JPG, PS2PCX, PS2PDF, PS2PNG, PS2TIF, LVIEW1,
     +           TRIM60, PFILE2, PATCH1, PS2SVG, PS2XPS
      DATA       NUMBLD / 30*0 /
      FNAME1 = FNAME
      WORD60 = TRIM60(FNAME1)
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         WRITE (TEXT,100) WORD60
         NUMDEC = NUMOPT
         NTEXT = 18
         CALL LVIEW1 (IX, IY, NUMDEC, NUMOPT, NSTART, NTEXT,
     +                TEXT,
     +                TITLES)
         IF (NUMDEC.EQ.1) THEN
            CALL PS2PDF (FNAME1,
     +                   SUPPLY)
         ELSEIF (NUMDEC.EQ.2) THEN
            CALL PS2PNG (FNAME1,
     +                   SUPPLY)
          ELSEIF (NUMDEC.EQ.3) THEN
            CALL PS2JPG (FNAME1,
     +                   SUPPLY)
         ELSEIF (NUMDEC.EQ.4) THEN
            CALL PS2SVG (FNAME1,
     +                   SUPPLY)    
         ELSEIF (NUMDEC.EQ.5) THEN
            CALL PS2XPS (FNAME1,
     +                   SUPPLY)
         ELSEIF (NUMDEC.EQ.6) THEN
            CALL PS2BMP (FNAME1,
     +                   SUPPLY)
         ELSEIF (NUMDEC.EQ.7) THEN
            CALL PS2PCX (FNAME1,
     +                   SUPPLY)
         ELSEIF (NUMDEC.EQ.8) THEN
            CALL PS2TIF (FNAME1,
     +                   SUPPLY)
         ELSEIF (NUMDEC.EQ.9) THEN
            CALL PFILE2 (ITYPE,
     +                   FNAME,
     +                   ASKIF)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
            WRITE (TEXT,200)
            NTEXT = 21
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
      ENDDO     
C
C Format statements
C      
  100 FORMAT (
     + 'An Encapsulated PostScript File (.eps) called:'
     +/A
     +/'has just been created.'
     +/'Ghostscript can now be used to make other graphics files, else'
     +/'you can archive, edit using Notepad, import into documents, or'
     +/'edit, re-size, print, overlay, or make collages using Editps.'
     +/'Type   `Features'
     +/'pdf    `Recommended for Adobe Acrobat, SumatraPDF, etc.'
     +/'png    `Recommended for WWW and MS Windows (compressed bit-map)'
     +/'jpg    `Recommended for WWW and MS Windows (compressed bit-map)'     
     +/'svg    `Recommended for WWW (xml graphics)'
     +/'xps    `Recommended for MS Windows (xml graphics)'
     +/'bmp    `Poor quality uncompressed bit-map'
     +/'pcx    `Poor quality compressed bit-map (obsolete)'
     +/'tif    `Poor quality compressed bit-map'
     +/'Archive`Add name to PostScript project archive'
     +/'Help   `...'
     +/'Cancel `...')
  200 FORMAT (
     + 'Ways to use this Simfit EPS-standard PostScript file'
     +/
     +/'1)`Input it into program GSview to browse or print.'
     +/'2)`Input it into program Editps to re-size, rotate, assemble'
     +/'  `into collages, print, file, or perform simple editing.'
     +/'3)`Input it into a text editor (e.g., Windows Notepad) to edit'
     +/'  `titles/legends/symbols/colours/sizes/clipping-frames, etc.'
     +/'4)`Input it into Adobe Illustrator (Note: this destroys the'
     +/'  `Simfit formatting exploited by the previous two options).'
     +/'5)`Incorporate it into documents with any word processor that'
     +/'  `can be set up to handle PostScript files with BoundingBoxes.'
     +/'6)`Create a graphics file from it by choosing a format. The'
     +/'  `file (e.g. myfile.eps) is unchanged but Ghostscript makes a'
     +/'  `new file (e.g., myfile.pdf, overwriting if already present).'
     +/'  `If you cannot use .eps or .pdf, create .png or .xps files.'
     +/'7)`The file name can be added to the PostScript archive project'
     +/'  `to faciltate subsequent use by Editps in making collages.'
     +/'Note that you cannot input this PostScript file back into the'
     +/'Simfit plotting program Simplot (it only accepts coordinates).'
     +/'The Simfit reference manual gives details of how to edit Simfit'
     +/'PostScript files and how to use them in MS Word documents.')
      END
C
C

