c            
c
      subroutine xfonts$()
c
c action: illustrate the simfit font substitution schemes
c author: w.g.bardsley, university of manchester, u.k., 12/11/2000
c         12/12/2003 extensive revision
c         16/12/2003 added extra options
c         04/01/2010 enlarged the tutorial 
c
      implicit   none
      integer    isend, jsend, nchar
      integer    i, icolor, nfont, ngks, numopt, numtxt,
     +           nout_ps
      parameter (nfont = 5, ngks = 0, numopt = 12, nout_ps = 10)
      integer    numbld(30)
      double precision angle, size1, slant
      parameter (angle = 0.0d+00, size1 = 1.6d+00, slant = 0.0d+00)
      double precision one, twenty, pnt2, xdiff, xstart
      parameter (one = 1.0d+00, twenty = 20.0d+00, pnt2 = 0.2d+00,
     +           xdiff = 0.05d+00)
      double precision xm(32:126), xt(32:126), ym(32:126), yt(32:126)
      double precision epsi
      parameter (epsi = 1.0d+00/40.0d+00)
      character  font*10, strng*1, symbol*1, text(30)*100, type1*4
      parameter (font = '\Helvetica', type1 = 'free')
      logical    again, frame, hpgl, next, ps, updown
      parameter (frame = .false., hpgl = .false., updown = .true.,
     +           ps = .false.)
      external   listbx, tutor1
      external   ttype1$, defgks$, init$, finish$, xfont1$, accent$
      intrinsic  char, dble
      data       numbld / 30*0 /
c
c initialise then calculate positions xm, xt, ym, yt
c
      xstart = xdiff
      do i = 32, 126
         if (i.le.51) then
            xt(i) = xstart
            xm(i) = xt(i) + xdiff
            yt(i) = one + dble(31 - i)/twenty
            ym(i) = yt(i)
         elseif (i.le.70) then
            if (i.eq.52) xstart = xstart + pnt2
            xt(i) = xstart
            xm(i) = xt(i) + xdiff
            yt(i) = one + dble(50 - i)/twenty
            ym(i) = yt(i)
         elseif (i.le.89) then
            if (i.eq.71) xstart = xstart + pnt2
            xt(i) = xstart
            xm(i) = xt(i) + xdiff
            yt(i) = one + dble(69 - i)/twenty
            ym(i) = yt(i)
         elseif (i.le.108) then
            if (i.eq.90) xstart = xstart + pnt2
            xt(i) = xstart
            xm(i) = xt(i) + xdiff
            yt(i) = one + dble(88 - i)/twenty
            ym(i) = yt(i)
         else
            if (i.eq.109) xstart = xstart + pnt2
            xt(i) = xstart
            xm(i) = xt(i) + xdiff
            yt(i) = one + dble(107 - i)/twenty
            ym(i) = yt(i)
         endif
         yt(i) = yt(i) + epsi
         ym(i) = ym(i) + epsi
      enddo
      again = .true.
      do while (again)
         write (text,100)
         isend = numopt - 1
         icolor = 7
         call listbx (isend, numopt, 
     +                text)
         if (isend.le.5) then
            if (isend.eq.1) then
               jsend = 8
            elseif (isend.eq.2) then
               jsend = 20
            elseif (isend.eq.3) then
               jsend = 3
            elseif (isend.eq.4) then
               jsend = 7
            elseif (isend.eq.5) then
               jsend = 9
            endif
            nchar = 32
            call accent$(jsend, nchar)
         elseif (isend.le.9) then
            call defgks$
            i = 0
            call init$(i)
            do i = 32, 126
               strng = char(i)
               symbol = '0'
               icolor = 0
               call ttype1$(icolor, nfont, ngks, nout_ps,
     +                      angle, size1, slant, xt(i), yt(i),
     +                      font, strng, symbol, type1,
     +                      hpgl, ps)
                if (isend.eq.6) then
                   symbol = '3'
               elseif (isend.eq.7) then
                   symbol = 'K'
               elseif (isend.eq.8) then
                   symbol = '7'
               elseif (isend.eq.9) then
                   symbol = '9'
               endif
               icolor = 12
               call ttype1$(icolor, nfont, ngks, nout_ps,
     +                      angle, size1, slant, xm(i), ym(i),
     +                      font, strng, symbol, type1,
     +                      hpgl, ps)
            enddo
            call finish$()
         elseif (isend.eq.10) then
            again = .true.
            call xfont1$
         elseif (isend.eq.numopt - 1) then
            again = .true.
            icolor = 9
            write (text,200)
            numtxt = 23
            numbld(1) = 1
            numbld(14) = 1
            numbld(20) = 1
            next = .true.
            call tutor1 (icolor, numbld, numtxt,
     +                   text,
     +                   frame, next, updown)
            numbld(1) = 0
            numbld(14) = 0
            numbld(20) = 0
            write (text,300)
            numtxt = 22
            numbld(1) = 1
            numbld(21) = 1
            numbld(22) = 1
            next = .true.
            call tutor1 (icolor, numbld, numtxt,
     +                   text,
     +                   frame, next, updown)
            numbld(1) = 0
            numbld(21) = 0
            numbld(22) = 0
            write (text,400)
            numtxt = 22
            numbld(1) = 1
            numbld(15) = 1
            next = .true.
            call tutor1 (icolor, numbld, numtxt,
     +                   text,
     +                   frame, next, updown)
            numbld(1) = 0
            numbld(15) = 0
            write (text,500)
            numtxt = 22
            numbld(1) = 1
            numbld(9) = 1
            next = .false.
            call tutor1 (icolor, numbld, numtxt,
     +                   text,
     +                   frame, next, updown)
            numbld(1) = 0
            numbld(9) = 0
         else
             again = .false.
         endif
      enddo
c
c format statements
c      
  100 format (
     + 'Character map: Latin    `Click to select'
     +/'Character map: Symbol   `Click to select'
     +/'Character map: Maths    `Click to select'
     +/'Character map: WingDings`Click to select'
     +/'Character map: Webdings `Click to select'
     +/'Keyboard map: Maths     `Information only'
     +/'Keyboard map: Symbol    `Information only'
     +/'Keyboard map: WingDings `Information only'
     +/'Keyboard map: Webdings  `Information only'
     +/'Examples                `Demonstration'
     +/'Help                    `Tutorial '
     +/'Cancel                  ` ')
  200 format (
     + 'Getting Simfit to plot non-standard characters'
     +/
     +/'If you select accented or other non-standard characters from a'   
     +/'keyboard or character map, PostScript output will be identical'   
     +/'to the Windows output except for characters and fonts where'   
     +/'Windows characters differ from the PostScript characters, e.g.'  
     +/'Wingdings in Windows selects ZapfDingbats in Postscript.'   
     +/
     +/'However scientific graphs often require subscripts for indices,'    
     +/'superscripts for powers, hats for estimates, bars for means, or'   
     +/'special maths characters, so Simfit has a simple technique that'   
     +/'will often work, and an advanced technique with greater power.'   
     +/   
     +/'Simple technique'   
     +/'Select the character from the top line of the advanced editing'   
     +/'control, then click on the new character required from the'    
     +/'appropriate character map. This will automatically adjust the'   
     +/'character and also the character control key in the lower row.'   
     +/   
     +/'Advanced technique'   
     +/'Consult the keyboard map for information, then replace the'   
     +/'character in the top row and the corresponding character in'   
     +/'the bottom row. Further details follow.')   
  300 format (
     + 'Plotting special characters and maths symbols'
     +/
     +/'In Simfit graphics every individual letter plotted has'
     +/'the following attributes:'
     +/
     +/'1) a character-number (i.e. the order in the font encoding)'
     +/'2) a size and orientation'
     +/'3) a colour'
     +/'4) a typeface family (e.g. Times, Arial)'
     +/'5) the font encoding required (e.g. IsoLatin1)'
     +/'6) an index-key for overprinting accents, etc.'
     +/
     +/'Size, angle for rotation, colour, and typeface selection are'
     +/'easily done interactively and should cause no problems. However'
     +/'difficulties may be encountered when wanting to use an accented'
     +/'character for which there is no dedicated key on the keyboard,'
     +/'or when trying to create a composite character, such as a bold'
     +/'theta with an overbar, which may not exist in the font set. To'
     +/'find out how to do such things the next information is vital to'
     +/'appreciate how a character appears when it is plotted:'
     +/'Associated with every string of characters is a corresponding'
     +/'set of index-keys to inform Simfit how to plot each character.')
  400 format (
     + 'Accented characters when there is no dedicated keyboard key'
     +/
     +/'Characters < 127 are defined by the ASCII 7-bit standard but'
     +/'this has no accented characters. Characters > 127 are defined'
     +/'by the IsoLatin1 standard, which is similar to Windows coding.'
     +/'For accented characters you select one and change the Simfit'
     +/'index-key from Standard to IsoLatin1 in one of these ways:'
     +/'1)`Select directly from the Simfit numeric keypad map control'
     +/'  `This is only available from the advanced editing option'
     +/'2)`Input the character number using the numeric keypad'
     +/'  `This easy but requires practise'
     +/'3)`Input the corresponding octal code'
     +/'  `This technique is only for PostScript experts'
     +/
     +/'Using numeric keypad codes to input accented characters'
     +/
     +/'For example, you will see from the Simfit Latin keypad map'
     +/'that character 241 is n-tilde. First engage Num Lock, then'
     +/'hold down Alt and then input the code (preceded by 0) using the'
     +/'number pad, i.e. Alt+0241. Simfit will automatically set the'
     +/'corresponding character control index to 8 for IsoLatin1 for'
     +/'any values > 127, but this can then be changed interactively.')
  500 format (
     + 'Simfit character maps and index-keys for special characters'
     +/
     +/'You may wish to plot symbols, or maths operators, or even add'
     +/'accents to characters that are not usually accented, e.g. bars'
     +/'for sample mean, or hats for estimated parameters. To do this'
     +/'you select advanced editing and edit the character or index-key'
     +/'for which you want to add accents or substitute maths, etc.'
     +/
     +/'PostScript octal codes, special macros, and LaTeX/PSFrag'
     +/
     +/'Octal codes can be used for characters > 127, but this is more'
     +/'difficult than the number pad technique. Note that accented'
     +/'characters look better using octal codes than after adding the'
     +/'accents independently but, if you use \260 for degrees, \351'
     +/'for e-acute, \361 for n-tilde, etc. you must select index-key 8'
     +/'for IsoLatin1 encoding, and remember that octal code \abc is a'
     +/'single byte in Postscript, which requires a single index-key.'
     +/'Accents,maths,and Symbols can be used in PostScript or Windows,'
     +/'but index-key 7 sets ZapfDingbats in PostScript, but WingDings'
     +/'in Windows, while index-key 9 invokes user-defined fonts in'
     +/'PostScript but WebDings in Windows. PS-experts can use macros'
     +/'(specials) and LaTeX users have PSFrag to do almost anything.')
      end
c 
c
