C
C
      SUBROUTINE XLABEL$(ICOLOR, KANGLE, KCOLOR, KTIC,
     +                   MTRANS, MXDROP, MXTIC,
     +                   NCFONT, NKCOL, NLOG, NOUT_PS, NWORDS, NXMAG,
     +                   CHEIGHT, EXTRA1, EXTRA2, THICK,
     +                   XA, XB, XMAX, XMIN, XPC, XTIC,
     +                   YB, YBEGIN, YDROP, YEND, Y_SCALE, YSTART,
     +                   WORDX, WORDY,
     +                   BOXIT, HARD_COPY, HPGL, MONO,
     +                   NATLOG, NUMBRX, OFFSET, PCENTX, PHIGHX,
     +                   PLOTX, POWERX, PS, ROTATE, SHOW_XAXIS,
     +                   XGRID, XTOINT)
C
C
C ACTION : X-legend/labels for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 6/6/95
C          08/08/1995 Added call to PSWORD for exponents
C          12/09/1995 Changed PSWORD call to PSNUMB
C          12/09/1996 Allowed for translation of X-axis
C          19/09/1996 Introduced PLOTX, PLTSTR$, WORDX, WORDY
C          30/09/1996 Improved/shortened so PLTSTR consistent
C          15/10/1996 POWERX introduced for powers of ten
C          12/01/1997 Checked that XTOINT and POWERX are consistent
C          14/07/1997 win32 version
C          01/02/2000 Added NATLOG and MTRANS
C          03/02/2000 Saved WORD2 to avoid it becoming undefined
C          18/02/2000 added PCENTX
C          23/02/2000 added WGBCFG$ and YDOWN to adjust labels and PHIGHX
C          03/07/2000 rationalised for double precision plotting
C          23/10/2000 suppressed tick-marks if PLOTX(I + 1 ) = .FALSE.
C          06/11/2000 added NFONT
C          21/07/2001 added SHOW_XAXIS
C          31/07/2001 added XMOVE1, XMOVE2
C          15/08/2001 added MXDROP and YDROP
C          19/06/2003 checked MXTIC and PLOTX before plotting
C          13/10/2004 added call to FSIZES$ to adjust PS label sizes
C          08/05/2007 added INTENTS
C          19/12/2007 trapped overflow for PLOTX when MXTIC > NWORDS - 1
C          04/11/2008 added call to SAVGRD$
C          19/07/2009 added GRFSIG$, LABEL8, TYPE8, and increased TLABEL*7 to TLABEL*8
C          26/08/2009 extensive editing and disabled PHIGHX
C          21/10/2009 added labelling improvement suggested by Samad
C          13/02/2010 added call to FSIZES$ for X-number size 
C          26/12/2013 added PS_SIZE to make sure font-size changes are reversed  
C          20/01/2015 altered lines 543 and 551 to display powers for, e.g. 10^0 = 1 and 10^1 = 10
C          23/06/2016 added call to XFRMAT$ 
C          25/03/2019 increased YDOWN by adding XTIC to move numbers down a bit
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NKCOL, NLOG, NWORDS
      INTEGER,             INTENT (INOUT) :: ICOLOR
      INTEGER,             INTENT (IN)    :: KANGLE, KCOLOR(NKCOL),
     +                                       KTIC, MTRANS, MXDROP,
     +                                       MXTIC, NCFONT, NOUT_PS,
     +                                       NXMAG
      DOUBLE PRECISION,    INTENT (IN)    :: CHEIGHT, EXTRA1, EXTRA2,
     +                                       THICK, XA, XB, XMAX, XMIN,
     +                                       XPC, XTIC, YB, YDROP, YEND,
     +                                       Y_SCALE, YSTART
      CHARACTER (LEN = *), INTENT (IN)    :: WORDX(NWORDS), 
     +                                       WORDY(NWORDS)
      LOGICAL,             INTENT (IN)    :: BOXIT, HARD_COPY, HPGL,
     +                                       MONO, NATLOG(NLOG), NUMBRX,
     +                                       OFFSET, PCENTX, PHIGHX,
     +                                       PLOTX(NWORDS), POWERX, PS,
     +                                       ROTATE, SHOW_XAXIS, XGRID
      LOGICAL,             INTENT (INOUT) :: XTOINT
C
C Locals
C
      INTEGER    I_COLR, I_LINE, I_WIDE, J_COLR
      INTEGER    I, J, LEN200, NFONT, NX, NXMAG1
      INTEGER    ISIGX, NFIGX, NSIGX
      PARAMETER (ISIGX = 3)
      INTEGER    N0, N1, N2, N3, N4, N7, N9, N10, N99, N100
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N7 = 7, N9 = 9,
     +           N10 = 10, N99 = 99, N100 = 100)
      INTEGER    ITYPE, JTYPE
      PARAMETER (ITYPE = 5, JTYPE = 13)
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FOUR, NINETY
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00, NINETY = 90.0D+00)
      DOUBLE PRECISION ANGLE, X, XBEGIN, XTEMP, XVAL, Y, YBEGIN, YBOX1,
     +                 YBOX2, YTEMP1, YTEMP2
      DOUBLE PRECISION BASE, XMOVE1, XMOVE2, XSIZE, X1, X2, X3
      DOUBLE PRECISION WGBCFG$, YDOWN
      DOUBLE PRECISION DI, DMXTIC, WIDTH
      DOUBLE PRECISION PS_SIZE(3)
      DOUBLE PRECISION T_MOVE, X_MOVE, Y_MOVE, Z_MOVE
      CHARACTER  BLANK*1, TIME10*3, TYPE1*4
      PARAMETER (BLANK = ' ', TIME10 = '*10')
      CHARACTER  EXPONT*4, FRMAT*20, LABEL4*4, LABEL5*5, LABEL7*7,
     +           TLABEL*10, WORD1*1, WORD2*2, WORD9*9, WORD10*10
      CHARACTER  SYMBOL*10, SYMBL9*9
      LOGICAL    GTYPE(0:11), OK, TOINT
      LOGICAL    POWER1
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   TRIML1, LEN200
      EXTERNAL   GSLN$, GSLWSC$, DASHED_LINE$, PSNUMB$, WGBCFG$,
     +           SOLID_LINE$, PLTSTR$, WGBFNT$, FSIZES$, SAVGRD$,
     +           GRFSIG$
      EXTERNAL   XFRMAT$
      EXTERNAL   TXYZ_FACTORS
      INTRINSIC  ABS, NINT, LOG10, DBLE, EXP, MOD, MIN
      SAVE       WORD2
      DATA       WORD2 / '10' /
C
C Get the fudge factors to compensate for X_SVG > 1 or Y_SVG > 1
C      
      CALL TXYZ_FACTORS (T_MOVE, X_MOVE, Y_MOVE, Z_MOVE) 
      Y_MOVE = 0.65D+00*Y_MOVE     
C
C Check MXTIC
C      
      IF (MXTIC.LT.0) RETURN
C
C Use PHIGHX to silence FTN95
C        
      OK = PHIGHX  
C
C Check PLOTX
C
      OK = .FALSE.
      DO I = 0, MIN(MXTIC, NWORDS - 1)
         IF (PLOTX(I + 1)) THEN
            OK = .TRUE.
            EXIT
         ENDIF    
      ENDDO
      IF (.NOT.OK) RETURN
C
C Define PS_SIZE 
C        
      DO I = 1, 3
         PS_SIZE(I) = - ONE
      ENDDO     
C
C Define NFONT
C
      CALL WGBFNT$(I, NFONT,
     +             ANGLE)        
C
C Define XSIZE
C
      DMXTIC = DBLE(MXTIC)
      IF (NUMBRX) THEN
         CALL FSIZES$(JTYPE,
     +                XSIZE,
     +                STORE) 
         IF (PS) THEN 
            WRITE (NOUT_PS,200) XSIZE
            PS_SIZE(2) = XSIZE
            WRITE (NOUT_PS,300) XSIZE
            PS_SIZE(3) = XSIZE
        ENDIF   
      ELSE
         CALL FSIZES$(ITYPE,
     +                XSIZE,
     +                STORE)
         IF (MXTIC.GT.20) THEN
C
C Shrink the labels font if the tick marks > 20
C
            XTEMP = (180.0D+00 - DMXTIC)/180.0D+00
            IF (XTEMP.LT.0.2D+00) XTEMP = 0.2D+00
            XSIZE = XSIZE*XTEMP
            IF (XSIZE.LT.0.2D+00) THEN
               XSIZE = 0.2D+00
            ELSEIF (XSIZE.GT.5.0D+00) THEN
               XSIZE = 5.0D+00
            ENDIF
         ENDIF
         IF (PS) THEN 
            WRITE (NOUT_PS,100) XSIZE
            PS_SIZE(1) = XSIZE
         ENDIF  
      ENDIF
      IF (XTOINT .AND. MXTIC.GT.0) THEN
         XMOVE1 = (XMAX - XMIN)/DMXTIC
         DO I = 0, MXTIC
            DI = DBLE(I)
            XVAL = DI*XMOVE1 + XMIN
            NX = NINT(XVAL)
            IF (I.GT.0) THEN
               IF (NX.EQ.J) XTOINT = .FALSE.
            ENDIF
            J = NX
         ENDDO
      ENDIF
      IF (MTRANS.EQ.12) THEN
         OK = .TRUE.
      ELSE
         OK = POWERX
      ENDIF
C
C Copy POWERX into POWER1
C
      POWER1 = POWERX
      IF ((MTRANS.EQ.12 .OR. POWER1) .AND. MXTIC.GT.0) THEN
         XMOVE1 = (XMAX - XMIN)/DMXTIC
         DO I = 0, MXTIC
            DI = DBLE(I)
            XVAL = DI*XMOVE1 + XMIN
            NX = NINT(XVAL)
            IF (ABS(XVAL).GT.0.001D+00) THEN
               IF (ABS((DBLE(NX) - XVAL)/XVAL).GT.0.01D+00) OK = .FALSE.
            ENDIF
            IF (I.GT.0) THEN
               IF (NX.EQ.J) OK = .FALSE.
            ENDIF
            J = NX
         ENDDO
      ENDIF
C
C Check for overflow in fraction notation for dilution curve
C
      IF (MTRANS.EQ.12) THEN
         IF (NX.GT.6 .OR. XMIN.LT.ZERO) POWER1 = .TRUE.
      ENDIF
C
C Initialise TYPES
C
      DO I = 0, 11
         GTYPE(I) = .FALSE.
      ENDDO
C
C Choose correct format depending on NXMAG
C
      TOINT = .FALSE.
      IF (XTOINT) THEN
         IF (XMIN.GE.-9999999.0D+00 .AND.
     +       XMAX.LE. 9999999.0D+00) TOINT = .TRUE.
      ENDIF
  
      CALL GRFSIG$ (ISIGX, MTRANS, NFIGX, NSIGX,
     +              'X') 
      
      IF (NSIGX.EQ.3) THEN
C
C High precision
C           
         IF (NXMAG .LT. - N99) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F8.4)'
            GTYPE(0) = .TRUE.
         ELSEIF (NXMAG .LT. - N9) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F8.4)'
            GTYPE(1) = .TRUE.
         ELSEIF (NXMAG .LT. - N2) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F8.4)'
            GTYPE(2) = .TRUE.
         ELSEIF (NXMAG .EQ. - N2) THEN
            FRMAT = '(F10.6)'
            GTYPE(3) = .TRUE.
         ELSEIF (NXMAG .EQ. - N1) THEN
            FRMAT = '(F10.5)'
            GTYPE(4) = .TRUE.
         ELSEIF (NXMAG .EQ. N0) THEN
            FRMAT = '(F10.4)'
            GTYPE(5) = .TRUE.
         ELSEIF (NXMAG .EQ. N1) THEN
            FRMAT = '(F10.3)'
            GTYPE(6) = .TRUE.
         ELSEIF (NXMAG .EQ. N2) THEN
            FRMAT = '(F10.2)'
            GTYPE(6) = .TRUE.
         ELSEIF (NXMAG .EQ. N3) THEN
            FRMAT = '(F10.1)'
            GTYPE(6) = .TRUE.
         ELSEIF (NXMAG .LT. N10)  THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F8.4)'
            GTYPE(9) = .TRUE.
         ELSEIF (NXMAG.LT.N100) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F8.4)'
            GTYPE(10) = .TRUE.
         ELSE
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F8.4)'
             GTYPE(11) = .TRUE.
         ENDIF
      ELSEIF (NSIGX.EQ.2) THEN    
C
C Automatic precision
C
         NFIGX = MAX(N1,NFIGX)

         NXMAG1 = NXMAG
         
         IF (NXMAG1.EQ.-N2 .OR.
     +      (NXMAG1.EQ.-N1 .AND. NFIGX.EQ.N1) .OR.
     +      (NXMAG1.GE.N0  .AND. NXMAG1.LE.N3)) THEN
            NFIGX =  NFIGX - NXMAG1
            NXMAG1 = N0
         ENDIF                        

         IF (NFIGX.LT.N1) THEN
            NFIGX = N1
         ELSEIF (NFIGX.GT.N7) THEN
            NFIGX = N7
         ENDIF   
                  
         WRITE (WORD1,'(I1)') NFIGX

         IF (NXMAG1.GE.-N2 .AND. NXMAG1.LE.N3) THEN
            FRMAT = '(F10.'//WORD1//')'
         ELSE   
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F10.'//WORD1//')'
         ENDIF
            
         IF (NXMAG1 .LT. - N99) THEN
            GTYPE(0) = .TRUE.
         ELSEIF (NXMAG1 .LT. - N9) THEN
            GTYPE(1) = .TRUE.
         ELSEIF (NXMAG1 .LT. - N2) THEN
            GTYPE(2) = .TRUE.
         ELSEIF (NXMAG1 .EQ. - N2) THEN
            GTYPE(3) = .TRUE.
         ELSEIF (NXMAG1 .EQ. - N1) THEN
            GTYPE(4) = .TRUE.
         ELSEIF (NXMAG1 .EQ. N0) THEN
            GTYPE(5) = .TRUE.
         ELSEIF (NXMAG1 .EQ. N1) THEN
            GTYPE(6) = .TRUE.
         ELSEIF (NXMAG1 .EQ. N2) THEN
            GTYPE(7) = .TRUE.
         ELSEIF (NXMAG1 .EQ. N3) THEN
            GTYPE(8) = .TRUE.
         ELSEIF (NXMAG1 .LT. N10)  THEN
            GTYPE(9) = .TRUE.
         ELSEIF (NXMAG1.LT.N100) THEN
            GTYPE(10) = .TRUE.
         ELSE
            GTYPE(11) = .TRUE.
         ENDIF
      ELSE
C
C Low precision
C        
         IF (NXMAG .LT. - N99) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F6.1)'
            GTYPE(0) = .TRUE.
         ELSEIF (NXMAG .LT. - N9) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F6.1)'
            GTYPE(1) = .TRUE.
         ELSEIF (NXMAG .LT. - N2) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F6.1)'
            GTYPE(2) = .TRUE.
         ELSEIF (NXMAG .EQ. - N2) THEN
            FRMAT = '(F10.3)'
            GTYPE(3) = .TRUE.
         ELSEIF (NXMAG .EQ. - N1) THEN
            FRMAT = '(F10.2)'
            GTYPE(4) = .TRUE.
         ELSEIF (NXMAG .EQ. N0) THEN
            FRMAT = '(F10.1)'
            GTYPE(5) = .TRUE.
         ELSEIF (NXMAG .EQ. N1) THEN
            FRMAT = '(F10.1)'
            GTYPE(6) = .TRUE.
         ELSEIF (NXMAG .EQ. N2) THEN
            GTYPE(7) = .TRUE.
         ELSEIF (NXMAG .EQ. N3) THEN
            GTYPE(8) = .TRUE.
         ELSEIF (NXMAG .LT. N10)  THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F6.1)'
            GTYPE(9) = .TRUE.
         ELSEIF (NXMAG.LT.N100) THEN
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F6.1)'
            GTYPE(10) = .TRUE.
         ELSE
            WRITE (FRMAT, '(A,I4,A)') '(',-NXMAG,'P,F6.1)'
            GTYPE(11) = .TRUE.
         ENDIF
      ENDIF
C
C Set up coordinates for labels and tick marks ........................
C
      IF (OFFSET) THEN
         YBOX1 = YEND
      ELSE
         YBOX1 = YB
      ENDIF
C
C Calculate YDOWN to adjust label position depending on font size
C
      YDOWN = WGBCFG$(N4)
      IF (YDOWN.GT.ONE) THEN
         YDOWN = TWO*(YDOWN - ONE)*XTIC
      ELSE
         YDOWN = ZERO
      ENDIF
      YDOWN = YDOWN + XTIC!fine tuning attempt on 25/03/2019
C
C Save YBEGIN as YTEMP1 (YBEGIN = YSTART or transform o/w)
C
      YTEMP1 = YBEGIN
      IF (ROTATE) THEN
         YBEGIN = YTEMP1 - CHEIGHT/FOUR
         IF (KANGLE.EQ.2) THEN
            ANGLE = - 45.0D+00
            TYPE1 = 'ro45'
         ELSEIF (KANGLE.EQ.3) THEN
            ANGLE = - 60.0D+00
            TYPE1 = 'ro60'
         ELSEIF (KANGLE.EQ.4) THEN
            ANGLE = - 75.0D+00
            TYPE1 = 'ro75'
         ELSEIF (KANGLE.EQ.5) THEN
            ANGLE = - NINETY
            TYPE1 = 'td'
         ELSEIF (KANGLE.EQ.6) THEN
            ANGLE = - NINETY
            TYPE1 = 'tu'
         ELSEIF (KANGLE.EQ.7) THEN
            ANGLE = 75.0D+00
            TYPE1 = 're75'
         ELSEIF (KANGLE.EQ.8) THEN
            ANGLE = 60.0d+00
            TYPE1 = 're60'
         ELSEIF (KANGLE.EQ.9) THEN
            ANGLE = 45.0d+00
            TYPE1 = 're45'
         ENDIF
      ELSE
         ANGLE = ZERO
         YBEGIN = YTEMP1 - CHEIGHT - CHEIGHT/FOUR
         TYPE1 = 'tc'
      ENDIF
      IF (KTIC.EQ.1) THEN
         YBEGIN = YBEGIN - XTIC
         YTEMP2 = YTEMP1 - XTIC
         YBOX2 = YBOX1 + XTIC
      ELSEIF (KTIC.EQ.2) THEN
         YTEMP2 = YTEMP1
         YBOX2 = YBOX1
      ELSE
         YTEMP2 = YTEMP1 + XTIC
         YBOX2 = YBOX1 - XTIC
      ENDIF
C
C Draw tick marks and labels on X-axis ................................
C
      IF (MTRANS.GE.8) THEN
         IF (NATLOG(1)) THEN
            BASE = EXP(1.0D+00)
            WORD2 = ' e'
         ELSEIF (NATLOG(2)) THEN
            BASE = 2.0D+00
            WORD2 = ' 2'
         ELSEIF (NATLOG(3)) THEN
            BASE = 3.0D+00
            WORD2 = ' 3'
         ELSEIF (NATLOG(4)) THEN
            BASE = 4.0D+00
            WORD2 = ' 4'
         ELSEIF (NATLOG(5)) THEN
            BASE = 5.0D+00
            WORD2 = ' 5'
         ELSEIF (NATLOG(6)) THEN
            BASE = 6.0D+00
            WORD2 = ' 6'
         ELSEIF (NATLOG(7)) THEN
            BASE = 7.0D+00
            WORD2 = ' 7'
         ELSEIF (NATLOG(8)) THEN
            BASE = 8.0D+00
            WORD2 = ' 8'
         ELSEIF (NATLOG(9)) THEN
            BASE = 9.0D+00
            WORD2 = ' 9'
         ELSEIF (NATLOG(10)) THEN
            BASE = 10.0D+00
            WORD2 = '10'
         ENDIF
      ENDIF
      IF (MTRANS.EQ.12 .AND. .NOT. POWER1) WORD2 = '1/'
      IF (MXTIC.GT.0) THEN
         XMOVE1 = (XMAX - XMIN)/DMXTIC
         XMOVE2 = (XB - XA)/DMXTIC
      ENDIF
      DO I = 0, MIN(MXTIC, NWORDS - 1)
         DI = DBLE(I) 
         IF (MXTIC.EQ.0) THEN
            XTEMP = (XA + XB)/TWO
            XVAL = (XMAX + XMIN)/TWO
         ELSE
            XTEMP = DI*XMOVE2 + XA
            XVAL = DI*XMOVE1 + XMIN
         ENDIF
         IF (.NOT.MONO) ICOLOR = KCOLOR(2)
         IF (SHOW_XAXIS .AND. PLOTX(I + 1)) THEN
            CALL SOLID_LINE$(XTEMP, YTEMP1, XTEMP, YTEMP2, ICOLOR)
            IF (BOXIT) CALL SOLID_LINE$(XTEMP, YBOX1, XTEMP, YBOX2,
     +                                  ICOLOR)
         ENDIF
         
         IF (XGRID) THEN
C
C Draw grid lines
C           
            CALL SAVGRD$(I_COLR, I_LINE, I_WIDE,
     +                   STORE)           
            CALL GSLN$(I_LINE)
            IF (I_COLR.LT.0) THEN
               J_COLR = ICOLOR
            ELSE
               J_COLR = I_COLR
            ENDIF      
            IF (I_WIDE.EQ.1) THEN
               WIDTH = THICK/FOUR
            ELSEIF (I_WIDE.EQ.2) THEN
               WIDTH = THICK/TWO
            ELSEIF (I_WIDE.EQ.3) THEN
               WIDTH = THICK 
            ELSEIF (I_WIDE.EQ.4) THEN
               WIDTH = THREE*THICK/TWO     
            ELSE   
               WIDTH = TWO*THICK
            ENDIF   
            CALL GSLWSC$(WIDTH)
            IF (I_LINE.EQ.1) THEN  
               CALL SOLID_LINE$(XTEMP, YSTART, XTEMP, YBOX1, J_COLR)
            ELSE   
               CALL DASHED_LINE$(XTEMP, YSTART, XTEMP, YBOX1, J_COLR)
            ENDIF   
            CALL GSLWSC$(THICK)
         ENDIF
         
         IF (TOINT .OR. GTYPE(7) .OR. GTYPE(8)) THEN
            NX = NINT(XVAL)
            WRITE (TLABEL,'(I10)') NX
         ELSE
            WRITE (TLABEL,FRMAT) XVAL
            IF (NSIGX.EQ.2) CALL XFRMAT$ (NSIGX,
     +                                    XVAL,
     +                                    TLABEL, FRMAT)            
         ENDIF
         CALL TRIML1 (TLABEL)
         
         XBEGIN = XTEMP
         IF (.NOT.MONO) ICOLOR = KCOLOR(3)
C
C Draw the labels if PLOTX(I + 1) = .TRUE.
C
         IF (PLOTX(I + 1)) THEN
            IF (NUMBRX) THEN
C
C Draw numbers as labels
C
               X = XBEGIN
               Y = YBEGIN - YDOWN 
               IF (POWER1) THEN
                  IF (OK) THEN
                     NX = NINT(XVAL)
                     IF (NX.EQ.0) THEN
C                        TLABEL = '1'
C                        SYMBOL = '0'
                         TLABEL = WORD2//'0'
                         SYMBOL = '002'   
                     ELSEIF (NX.EQ.1) THEN
                        IF (MTRANS.EQ.12) THEN
                           TLABEL = WORD2//'-1'
                           SYMBOL = '0022'
                        ELSE
C                           TLABEL = WORD2
C                           SYMBOL = '00'
                            TLABEL = WORD2//'1'
                            SYMBOL = '002' 
                        ENDIF
                     ELSE
                        IF (MTRANS.EQ.12) THEN
                           WRITE (LABEL5,'(I5)') - NX
                        ELSE
                           WRITE (LABEL5,'(I5)') NX
                        ENDIF
                        CALL TRIML1 (LABEL5)
                        TLABEL = WORD2//LABEL5
                        SYMBOL = '0022222'
                     ENDIF
                  ELSE
                     IF (MTRANS.EQ.12) THEN
                        WRITE (LABEL7,'(F7.2)') - XVAL
                     ELSE
                        WRITE (LABEL7,'(F7.2)') XVAL
                     ENDIF
                     CALL TRIML1(LABEL7)
                     TLABEL = WORD2//LABEL7(1:5)
                     SYMBOL = '0022222'
                  ENDIF
               ELSEIF (MTRANS.EQ.12) THEN
                  IF (OK) THEN
                     WRITE (LABEL7,'(I7)') NINT(BASE**XVAL)
                  ELSE
                     WRITE (LABEL7,'(F7.2)') BASE**XVAL
                  ENDIF
                  CALL TRIML1 (LABEL7)
                  WORD9 = WORD2//LABEL7
                  SYMBL9 = '000000000'
               ELSE
                  SYMBOL = '0000000000'
               ENDIF
               IF (MTRANS.EQ.12 .AND. .NOT.POWER1) THEN
                  Y = Y + Y_MOVE
                  CALL PLTSTR$(ICOLOR, NCFONT, NFONT, N0, NOUT_PS,
     +                         ANGLE, XSIZE*XPC, ZERO, X, Y, Y_SCALE,
     +                         BLANK, WORD9, SYMBL9, TYPE1,
     +                         HARD_COPY, HPGL, PS)
               ELSE
                  WORD10 = TLABEL
                  IF (MTRANS.NE.12 .AND. .NOT.POWER1 .AND. PCENTX) THEN
                     J = LEN200(WORD10)
                     IF (J.LT.10) WORD10(J + 1:J + 1) = '%'
                     SYMBOL = '00000000'
                  ENDIF
                  Y = Y + Y_MOVE
                  CALL PLTSTR$(ICOLOR, NCFONT, NFONT, N0, NOUT_PS,
     +                         ANGLE, XSIZE*XPC, ZERO, X, Y, Y_SCALE,
     +                         BLANK, WORD10, SYMBOL, TYPE1,
     +                         HARD_COPY, HPGL, PS)
               ENDIF
            ELSE
C
C Draw words as labels
C
               X = XBEGIN
               Y = YBEGIN - YDOWN
               IF (MXTIC.GT.MXDROP) THEN
                  IF (MOD(I,2).EQ.1) Y = Y - YDROP
               ENDIF
               Y = Y + Y_MOVE
               CALL PLTSTR$(ICOLOR, NCFONT, NFONT, N0, NOUT_PS,
     +                      ANGLE, XSIZE*XPC, ZERO, X, Y, Y_SCALE,
     +                      BLANK, WORDX(I + 1), WORDY(I + 1), TYPE1,
     +                      HARD_COPY, HPGL, PS)
            ENDIF
         ENDIF
      ENDDO

C
C Draw extra tick marks if POWER1 .....................................
C
      IF (MTRANS.EQ.12) POWER1 = .TRUE.
      IF (SHOW_XAXIS .AND. NATLOG(12) .AND. OK .AND. POWER1 .AND.
     +    MXTIC.GT.0 .AND. KTIC.NE.2) THEN
         IF (KTIC.EQ.1) THEN
            YTEMP2 = YTEMP2 + XTIC/TWO
            YBOX2 = YBOX2 - XTIC/TWO
         ELSE
            YTEMP2 = YTEMP2 - XTIC/TWO
            YBOX2 = YBOX2 + XTIC/TWO
         ENDIF
         IF (.NOT.MONO) ICOLOR = KCOLOR(2)
         X1 = XA
         DO I = 1, MXTIC
            DI = DBLE(I)
            X2 = DI*(XB - XA)/DMXTIC + XA
            X3 = (X2 - X1)
            DO J = 2, 9
               XTEMP = X1 + LOG10(DBLE(J))*X3
               CALL SOLID_LINE$(XTEMP, YTEMP1, XTEMP, YTEMP2, ICOLOR)
               IF (BOXIT) CALL SOLID_LINE$(XTEMP, YBOX1, XTEMP, YBOX2,
     +                                     ICOLOR)
            ENDDO
            X1 = X2
         ENDDO
      ENDIF
C
C Draw exponential if required.........................................
C
      IF (TOINT .OR. .NOT.NUMBRX) THEN
C
C Restore PS sizes if they have been adjusted for X-axis labels
C
         IF (PS) THEN
            IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)  
            IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)  
            IF (PS_SIZE(3).GT.ZERO) WRITE (NOUT_PS,300) ONE/PS_SIZE(3)  
         ENDIF            
         RETURN
      ENDIF   
      IF (GTYPE(0)  .OR. GTYPE(1) .OR. GTYPE(2) .OR. GTYPE(9) .OR.
     +    GTYPE(10) .OR. GTYPE(11)) THEN
         WRITE (EXPONT, FMT = '(I4)') NXMAG
      ELSE
C
C Restore PS sizes if they have been adjusted for X-axis labels
C
         IF (PS) THEN
            IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)  
            IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)  
            IF (PS_SIZE(3).GT.ZERO) WRITE (NOUT_PS,300) ONE/PS_SIZE(3)  
         ENDIF        
         RETURN
      ENDIF
      IF (.NOT.MONO) ICOLOR = KCOLOR(3)
      LABEL4 = EXPONT
      CALL TRIML1 (LABEL4)
      XBEGIN = XB - 0.042D+00
      IF (ROTATE) XBEGIN = XBEGIN + 0.06D+00
      YBEGIN = YBEGIN - EXTRA1 - EXTRA2
C
C Adjust for font size
C
      YBEGIN = YBEGIN - YDOWN
      IF (PS) THEN
         CALL PSNUMB$(ICOLOR,
     +                XBEGIN, YBEGIN, 
     +                'E'//LABEL4, 'tl')
      ELSE
         CALL PLTSTR$(ICOLOR, NCFONT, NFONT, N0, NOUT_PS,
     +                ZERO, XSIZE*XPC, ZERO, XBEGIN, YBEGIN, Y_SCALE,
     +                BLANK, TIME10//LABEL4, '3002222', 'tl',
     +                HARD_COPY, HPGL, PS)
      ENDIF  
C
C Restore PS sizes if they have been adjusted for X-axis labels
C
      IF (PS) THEN
         IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)  
         IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)  
         IF (PS_SIZE(3).GT.ZERO) WRITE (NOUT_PS,300) ONE/PS_SIZE(3)  
      ENDIF
C
C These format statements must NOT be edited
C      
  100 FORMAT ('/td-size td-size',1X,f7.3,1X,'mul def')
  200 FORMAT ('/tc-size tc-size',1X,f7.3,1X,'mul def')
  300 FORMAT ('/tl-size tl-size',1X,f7.3,1X,'mul def')
      END

C
C
c--------------------------------------------------------------------------------------
c
c
      subroutine xfrmat$(nsigx,
     +                   x,
     +                   tlabel, frmat)
c
c action: check significant figures for simplot if automatic precision i.e. nsigx = 2
c author: w.g.bardsley, university of manchester, u.k., 22/06/2016
c
c arguments as used in subroutine xlabel$, ylabel$, zlabel$, etc. as follows:
c
c  nsigx: automatic precision is current only if nsigx = 2, o/w no action
c      x: actual value of x 
c tlabel: current label on input but maybe edited on output
c         in xlabel$ tlabel has len = 10
c  frmat: format used to create tlabel such as '(F10.1)'
c         in xlabel$ frmat has len = 20
c       
      implicit none     
c
c arguments
c      
      integer,             intent (in)    :: nsigx 
      double precision,    intent (in)    :: x
      character (len = *), intent (in)    :: frmat
      character (len = *), intent (inout) :: tlabel
c
c locals
c      
      integer    i, ios, j, k
      double precision absx, ratio, y
      double precision epsi, frac, xmax
      parameter (epsi = 1.0d-04, frac = 0.001d+00, xmax = 1.0d+04)
      character (len = 80) frmat_copy
      character (len = 10) word10
      character (len = 7 ) word7
      character (len = 1 ) blank
      parameter (blank = ' ')
      intrinsic  abs, adjustl
c
c check nsigx, x and frmat
c      
      if (nsigx.ne.2) return
      absx = abs(x)
      if (absx.gt.xmax .or. absx.lt.epsi) return    
      k = len(tlabel)
      if (k.ne.10) return  
      k = len(frmat)
      if (k.lt.7) return
      frmat_copy = blank  
      frmat_copy(1:k) = frmat(1:k)
      frmat_copy = adjustl(frmat_copy)
      word7 = frmat_copy(1:7)
      if (word7(1:5).ne.'(f10.' .and. word7(1:5).ne.'(F10.') return
      if (word7(7:7).ne.')') return
      read (tlabel,*,iostat=ios) y 
      if (ios.ne.0) return
c
c define and check the starting ratio
c        
      ratio = abs(x - y)/absx
      if (ratio.le.frac) return
c
c increase the precision
c
      read (word7(6:6),*,iostat=ios) j
      if (ios.ne.0) return
      if (j.gt.6) return       
      j = j + 1  
      do i = j, 7 
        write (word7,'(a,i1,a)') '(F10.', i, ')'
        write (word10,word7) x
        read (word10,*,iostat=ios) y
        ratio = abs(x - y)/absx
        if (ratio.le.frac) then
           word10 = adjustl(word10)
           tlabel = word10
          return
        endif
      enddo
c
c make sure tlabel is maximum significance even if ratio remains > frac 
c      
      word10 = adjustl(word10)
      tlabel = word10
      end
c
c



 