C
C
      SUBROUTINE XRANGE$(N,
     +                   XMAX, XMIN)
C
C
C ACTION : Set up ranges and tick marks at integer divisions if possible
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/11/96
C          14/07/1997 win32 version
C          20/08/2001 edited the case NTYPE = 2 
C          08/05/2007 added INTENTS
C          18/07/2009 Added final call to GSCALE$ if extreme values or correction for 
C                     integers fails and improved the checking for integer labels
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (INOUT) :: N 
      DOUBLE PRECISION, INTENT (INOUT) :: XMAX, XMIN
C
C Locals
C      
      INTEGER    I, IDIFF, IMAX, IMIN, NTYPE
      DOUBLE PRECISION TEMP
      DOUBLE PRECISION FACTOR, XMAX1, XMIN1, X1, X2
      DOUBLE PRECISION BOT, RATIO, RMAX, RMIN, TOP
      PARAMETER (RMIN = 0.999D+00, RMAX = 1.25D+00)
      DOUBLE PRECISION ZERO, ONE, EPSI
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, EPSI = 1.0D-06)
      LOGICAL    EXACT1, EXACT2, TRY1, TRY2
      EXTERNAL   GSCALE$
      INTRINSIC  MAX, MIN, NINT, DBLE
C
C Swap if wrong way round
C
      IF (XMIN.GT.XMAX) THEN
         TEMP = XMIN
         XMIN = XMAX
         XMAX = TEMP
      ENDIF
C
C Store original range
C      
      BOT = XMAX - XMIN
      IF (XMIN.LT.ZERO .AND. XMAX.LE.ZERO) THEN
C
C Both <= 0 ... reflect
C
         NTYPE = 1
         XMAX1 = - XMIN
         XMIN1 = - XMAX
      ELSEIF (XMIN.LT.ZERO .AND. XMAX.GT.ZERO) THEN
C
C Opposite signs ... call GSCALE$ as integer labels are unlikely 
C
         NTYPE = 2
      ELSE
C
C Both > 0
C
         NTYPE = 3
         XMAX1 = XMAX
         XMIN1 = XMIN
      ENDIF
C
C Call GSCALE$ then exit if integer labels are unlikely
C
      IF (NTYPE.EQ.2 .OR. XMAX1.LT.1.0D-05 .OR. XMAX1.GT.1.0D+05) THEN
         CALL GSCALE$(N,
     +                XMAX, XMIN)
         RETURN
      ENDIF
C
C Find the FACTOR to map the range into (0,100)
C
      IF (XMAX1.LE.1.0D-05) THEN
         FACTOR = 1.0D+07
      ELSEIF (XMAX1.LE.1.0D-04) THEN
         FACTOR = 1.0D+06
      ELSEIF (XMAX1.LE.1.0D-03) THEN
         FACTOR = 1.0D+05
      ELSEIF (XMAX1.LE.1.0D-02) THEN
         FACTOR = 1.0D+04
      ELSEIF (XMAX1.LE.1.0D-01) THEN
         FACTOR = 1.0D+03
      ELSEIF (XMAX1.LE.ONE) THEN
         FACTOR = 1.0D+02
      ELSEIF (XMAX1.LE.1.0D+01) THEN
         FACTOR = 1.0D+01
      ELSEIF (XMAX1.LE.1.0D+02) THEN
         FACTOR = ONE
      ELSEIF (XMAX1.LE.1.0D+03) THEN
         FACTOR = 1.0D-01
      ELSEIF (XMAX1.LE.1.0D+04) THEN
         FACTOR = 1.0D-02
      ELSEIF (XMAX1.LE.1.0D+05) THEN
         FACTOR = 1.0D-03
      ENDIF
C
C Scale then re-define XMAX1, XMIN1 so that the data limits are at integers in (0,100)
C
      XMAX1 = XMAX1*FACTOR
      XMIN1 = XMIN1*FACTOR
      X1 = - ONE
      X2 = ZERO
      TRY1 = .TRUE.
      TRY2 = .TRUE.
      DO I = 1, 100
         X1 = X1 + ONE
         X2 = X2 + ONE
         IF (TRY1) THEN
            IF (XMIN1.GE.X1 .AND. XMIN1.LT.(X2 - EPSI)) THEN
               XMIN1 = X1
               TRY1 = .FALSE.
               IF (.NOT.TRY2) EXIT
            ENDIF
         ENDIF
         IF (TRY2) THEN
            IF (XMAX1.GT.(X1 + EPSI) .AND. XMAX1.LE.X2) THEN
               XMAX1 = X2
               TRY2 = .FALSE.
               IF (.NOT.TRY1) EXIT
            ENDIF
         ENDIF
      ENDDO
C
C Define IMAX, IMIN and transfer to GSCALE$ if they agree to two places
C
      IMAX = MIN(100,NINT(XMAX1))
      IMIN = MAX(0,NINT(XMIN1))
      IDIFF = IMAX - IMIN
      IF (IDIFF.LE.1) THEN
         CALL GSCALE$(N, 
     +                XMAX, XMIN)         
         RETURN
      ENDIF   
C
C Check if both limits are at exact intervals of multiples of 10
C
      EXACT1 = .FALSE.
      EXACT2 = .FALSE.
      DO I = 0, 100, 10
         IF (IMIN.EQ.I) EXACT1 = .TRUE.
         IF (IMAX.EQ.I) THEN
            EXACT2 = .TRUE.
            EXIT
         ENDIF   
      ENDDO
      IF (.NOT.EXACT1 .OR. .NOT.EXACT2) THEN
C
C Find the range
C
         IF (IDIFF.LE.15) THEN
C
C If a small interval then use IDIFF as N or correct for prime numbers, etc.
C           
            IF (IDIFF.EQ.15) THEN
               N = 5
            ELSEIF (IDIFF.EQ.14 .OR. IDIFF.EQ.13) THEN
               N = 1
            ELSEIF (IDIFF.EQ.12) THEN
               N = 4   
            ELSEIF (IDIFF.EQ.11) THEN
               N = 1   
            ELSEIF (IDIFF.EQ.10) THEN
               N = 5   
            ELSEIF (IDIFF.EQ.9) THEN
               N = 3
            ELSEIF (IDIFF.EQ.8) THEN
               N = 4
            ELSEIF (IDIFF.EQ.7) THEN
               N = 1   
            ELSEIF (IDIFF.EQ.6) THEN
               N = 3   
            ELSE            
               N = IDIFF
            ENDIF   
            EXACT1 = .FALSE.
            EXACT2 = .FALSE.
         ELSE
C
C Otherwise expand to nearest multiples of 10
C           
            
            IMIN = 10*MAX(0,IMIN/10)
            IMAX = 10*MIN(100,(IMAX + 9)/10)
            EXACT1 = .TRUE.
            EXACT2 = .TRUE.
         ENDIF
      ENDIF
      IF (EXACT1 .AND. EXACT2) THEN
C
C Try to define sensible integer tick marks
C        
         N = MAX(1,(IMAX - IMIN)/10)
         IF (IMIN.EQ.40) THEN
            IF (IMAX.GE.90) THEN
               IMAX = 100
               N = 3
            ENDIF
         ELSEIF (IMIN.EQ.30) THEN
            IF (IMAX.GE.90) THEN
               IMIN = 20
               IMAX = 100
               N = 4
            ELSEIF (IMAX.EQ.80) THEN
               IMIN = 20
               N = 3
            ENDIF
         ELSEIF (IMIN.EQ.20) THEN
            IF (IMAX.GE.90) THEN
               IMAX = 100
               N = 4
            ELSEIF (IMAX.GE.70) THEN
               IMAX = 80
               N = 4
           ENDIF
         ELSEIF (IMIN.EQ.10) THEN
            IF (IMAX.GE.90) THEN
               IMIN = 0
               IMAX = 100
               N = 5
            ELSEIF (IMAX.GE.70) THEN
               IMIN = 0
               IMAX = 80
               N = 4
            ENDIF
         ELSEIF (IMIN.EQ.0) THEN
            IF (IMAX.GE.90) THEN
               IMAX = 100
               N = 5
            ELSEIF (IMAX.EQ.60) THEN
               N = 3
            ELSEIF (IMAX.GE.70) THEN
               IMAX = 80
               N = 4
            ENDIF
         ENDIF
      ENDIF
C
C Restore, check that limits are reasonable and make sure N > 0
C
      XMAX1 = DBLE(IMAX)/FACTOR
      XMIN1 = DBLE(IMIN)/FACTOR
      TOP = XMAX1 - XMIN1
      RATIO = TOP/BOT
      IF (XMIN1.GT.XMIN .OR. XMAX1.LT.XMAX .OR.
     +    RATIO.LT.RMIN .OR. RATIO.GT.RMAX) THEN
         N = 4
         CALL GSCALE$(N,
     +                XMAX, XMIN)
      ELSE   
         IF (NTYPE.EQ.1) THEN
            XMAX = - XMIN1
            XMIN = - XMAX1
         ELSE
            XMAX = XMAX1
            XMIN = XMIN1
         ENDIF
      ENDIF   
      IF (N.LT.1) N = 1
      END
C
C
