C
C
      SUBROUTINE XYZLEG$(KMODE, NBIG, NSAV, NTEXT,
     +                   ARRAY, TEXT, TEXT1, TITLE, XYZ,
     +                   ARROW, CONTAB, CONVAL, LABEL, NUMBER,
     +                   TOINT, TSHOW)
C
C
C ACTION : Edit details for X, Y or Z legends in 3D histogram
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 14/9/95
C          30/12/2000 added SELSTR
C          23/07/2001 NSAV not now used and NTEXT does not now depend on
C                     LABEL or NUMBER as there will now be NTEXT numbers
C                     or text labels
C          28/02/2002 added GETLBL
C          17/07/2005 added N1 and FFILES in call to GETLBL 
C          13/05/2007 added INTENTS
C          19/10/2014 added additional advice and increased number of checks for interactions
C                     New variable ADVISE introduced to toggle calls to PUTADV$ which would
C                     usually mean using ADVISE = .TRUE. only when developing the code 
C
C          NSAV = Max. no. labels (not now used)
C          NTEXT = No. text labels
C          ARRAY = array for title
C          TEXT = text labels
C          TEXT1 = text symbol arrays
C          TITLE = appropriate title
C          XYZ = X, Y or Z
C          ARROW = yes/no
C          CONTAB = yes/no
C          LABEL = yes/no
C          NUMBER = yes/no
C          TOINT = yes/no
C          TSHOW = yes/no ... title
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: KMODE, NBIG 
      INTEGER,             INTENT (INOUT) :: NSAV, NTEXT 
      CHARACTER (LEN = *), INTENT (INOUT) :: ARRAY, TEXT(NBIG),
     +                                       TEXT1(NBIG), TITLE, XYZ 
      LOGICAL,             INTENT (INOUT) :: ARROW, CONTAB, CONVAL,
     +                                       LABEL, NUMBER, TOINT, TSHOW
C
C Locals
C      
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    IX, IY, NUMDEC, NUMHLP, NUMOPT
      PARAMETER (IX = 4, IY = 4, NUMHLP = 9)
      INTEGER    IBOT, IMID, ITOP
      CHARACTER (LEN = 6  ) SYMBOL(6)
      CHARACTER (LEN = 100) HELP(NUMHLP), LINE, OPTS(30), QUERY
      LOGICAL    ADVISE, FFILES, REPEET, TITLES
      PARAMETER (FFILES = .TRUE., TITLES = .FALSE.)
      EXTERNAL   LVIEW2, SELSTR, GETLBL
      EXTERNAL   NEWSTR$, GETJM1$, PUTADV$
C
C Set ADVISE then initialise
C      
      ADVISE = .FALSE.
      IF (NSAV.LT.NBIG) NSAV = NBIG!to silence ftn95
      IF (KMODE.EQ.2) THEN
         NUMOPT = 8
         LABEL = .FALSE.
         NUMBER = .TRUE.
      ELSE
         NUMOPT = 10
      ENDIF
C
C Main loop
C      
      REPEET = .TRUE.
      DO WHILE (REPEET)
         NUMDEC = NUMOPT
         IF (NTEXT.GT.N2) THEN
            ARROW = .FALSE.
            TSHOW = .FALSE.
         ENDIF   
         IF (NUMBER) THEN
            LABEL = .FALSE.
         ELSEIF (LABEL) THEN
            ARROW = .FALSE.
            NUMBER = .FALSE.
            TOINT = .FALSE.
            TSHOW = .FALSE.
         ENDIF
         IF (TSHOW) THEN
            SYMBOL(1) = '[Yes]'
         ELSE
            SYMBOL(1) = '[No]'
         ENDIF
         IF (NUMBER) THEN
            SYMBOL(2) = '[Yes]'
         ELSE
            SYMBOL(2) = '[No]'
         ENDIF
         IF (TOINT) THEN
            SYMBOL(3) = '[Yes]'
         ELSE
            SYMBOL(3) = '[No]'
         ENDIF
         IF (ARROW) THEN
            SYMBOL(4) = '[Yes]'
         ELSE
            SYMBOL(4) = '[No]'
         ENDIF
         IF (LABEL) THEN
            SYMBOL(5) = '[Yes]'
         ELSE
            IF (KMODE.EQ.2 .AND. CONTAB) THEN
               SYMBOL(5) = '[Yes]'
            ELSE
               SYMBOL(5) = '[No]'
            ENDIF
         ENDIF
         IF (KMODE.EQ.2) THEN
C
C Menu for contours
C           
            IF (CONVAL) THEN
               SYMBOL(6) = '[Yes]'
            ELSE
               SYMBOL(6) = '[No]'
            ENDIF
            WRITE (OPTS,100) XYZ, XYZ, SYMBOL(1), XYZ, SYMBOL(2), XYZ,
     +                       SYMBOL(3), XYZ, SYMBOL(4), SYMBOL(5),
     +                       SYMBOL(6)
         ELSE
C
C Menu for surfaces
C           
            WRITE (OPTS,200) XYZ, XYZ, SYMBOL(1), XYZ, SYMBOL(2), XYZ,
     +                       SYMBOL(3), XYZ, SYMBOL(4), XYZ, SYMBOL(5),
     +                       XYZ, XYZ, XYZ, NTEXT
         ENDIF
         CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT,
     +                OPTS, TITLES)
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Edit the legend
C           
            CALL NEWSTR$(N0,
     +                   TITLE, ARRAY)
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Toggle legend display
C         
            IF (NUMBER .AND. NTEXT.LE.N2) THEN
               TSHOW = .NOT.TSHOW
               IF (ADVISE) THEN
                  IF (TSHOW) THEN
                     CALL PUTADV$('Legend will be displayed')
                  ELSE
                     CALL PUTADV$('Legend will be suppressed') 
                  ENDIF
               ENDIF
            ELSE
               TSHOW = .FALSE.
               CALL PUTADV$('Not allowed with labels or tick marks > 2')        
            ENDIF  
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Toggle NUMBER
C         
            NUMBER = .NOT.NUMBER
            IF (NUMBER) THEN
               LABEL = .FALSE.
               IF (ADVISE) CALL PUTADV$('Numbers displayed not labels')
            ELSE
               TOINT = .FALSE.
               IF (ADVISE) THEN
                  IF (LABEL) THEN
                     CALL PUTADV$('Labels displayed not numbers')
                  ELSE
                     CALL PUTADV$('Numbers and labels both suppressed')
                  ENDIF
               ENDIF         
            ENDIF     
         ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Toggle TOINT
C         
            IF (NUMBER) THEN
               TOINT = .NOT.TOINT
               IF (ADVISE) THEN
                  IF (TOINT) THEN
                     CALL PUTADV$('Integers displayed if possible')
                  ELSE
                     CALL PUTADV$('Numbers displayed not integers')
                  ENDIF
               ENDIF   
            ELSEIF (LABEL) THEN
               TOINT = .FALSE.
               CALL PUTADV$('Not allowed: labels have been selected') 
            ELSE
               TOINT = .FALSE.
               CALL PUTADV$('Not allowed: numbers/labels supressed')      
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Toggle ARROW
C         
            IF (NTEXT.LE.2 .AND. .NOT.LABEL) THEN
               ARROW = .NOT.ARROW
               IF (ADVISE) THEN
                  IF (ARROW) THEN
                     CALL PUTADV$('Directional arrow will be displayed')
                  ELSE
                     CALL PUTADV$('Directional arrow now suppressed')
                  ENDIF
               ENDIF
            ELSE
               ARROW = .FALSE.
               CALL PUTADV$('Not allowed with labels or tick marks > 2')  
            ENDIF            
         ELSEIF (NUMDEC.EQ.6) THEN
C
C NUMDEC = 6: Toggle CONTAB or LABEL
C         
            IF (KMODE.EQ.2) THEN
               CONTAB = .NOT.CONTAB
               IF (ADVISE) THEN
                  IF (CONTAB) THEN
                     CALL PUTADV$('Contour values will be displayed')
                  ELSE 
                     CALL PUTADV$('Contour values will be suppressed') 
                  ENDIF 
               ENDIF   
            ELSE
               LABEL = .NOT.LABEL
               IF (LABEL) THEN
                  NUMBER = .FALSE.
                  IF (ADVISE) CALL PUTADV$('Labels will be displayed')
               ELSEIF (NUMBER .AND. ADVISE) THEN
                  CALL PUTADV$('Numbers will be displayed not labels')
               ELSEIF (ADVISE) THEN 
                  CALL PUTADV$('Numbers and labels both suppressed')   
               ENDIF        
            ENDIF
         ELSEIF (NUMDEC.EQ.7) THEN
C
C NUMDEC = 7: Edit labels ... simple
C         
            IF (KMODE.EQ.2) THEN
               CONVAL = .NOT.CONVAL
            ELSE
               IF (NTEXT.GE.N1) THEN
                  CALL GETLBL (N1, NTEXT,
     +                         TEXT,
     +                         FFILES)
               ELSE
                  CALL PUTADV$('There are no current text labels')
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.8) THEN
C
C NUMDEC = 8: Toggle labels ... advanced
C         
            IF (KMODE.EQ.2) THEN
               REPEET = .FALSE.
            ELSE
               IBOT = N1
               ITOP = NTEXT
               IF (ITOP.GE.N1) THEN
                  WRITE (HELP,300)
                  CALL SELSTR (IMID, NUMHLP, ITOP, 
     +                         HELP, TEXT)
                  IF (IMID.GE.N1) CALL NEWSTR$(N0, TEXT(IMID),
     +                                         TEXT1(IMID))
               ELSE
                  CALL PUTADV$('There are no current text labels')
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.9) THEN
C
C NUMDEC = 9: End for contours or change NTEXT for surfaces
C         
            IF (KMODE.EQ.2) THEN
               REPEET = .FALSE.
            ELSE
               IF (TSHOW .OR. ARROW .AND. NTEXT.LE.N2) THEN 
                  WRITE (LINE,500) XYZ
                  CALL PUTADV$(LINE)
               ENDIF
               IF (NTEXT.LT.N2) NTEXT = N2
               IBOT = N2
               IMID = NTEXT
               ITOP = NBIG
               WRITE (QUERY,400) XYZ
               CALL GETJM1$(IBOT, IMID, ITOP,
     +                      QUERY)
               NTEXT = IMID
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: End
C         
            REPEET = .FALSE.
         ENDIF
      ENDDO 
C
C Format statements
C      
  100 FORMAT (
     + 'Change the current ',A,' legend'
     +/'Display the current ',A,' legend`',A
     +/'Display numbers on ',A,' axis   `',A
     +/'Display integers on ',A,' axis  `',A
     +/'Display an arrow on ',A,' axis  `',A
     +/'Display a key/contours table    `',A
     +/'Display values with contours    `',A
     +/'Apply')
  200 FORMAT (
     + 'Change the current ',A,' legend'
     +/'Display the current ',A,' legend`',A
     +/'Display numbers on ',A,' axis   `',A
     +/'Display integers on ',A,' axis  `',A
     +/'Display an arrow on ',A,' axis  `',A
     +/'Plot text labels on ',A,' axis  `',A
     +/'Edit all current ',A,' labels   `[Simple]'
     +/'Edit one current ',A,' label    `[Advanced]'
     +/'Change number of ',A,' labels   `',I2
     +/'Apply')
  300 FORMAT (
     + 'Editing the plot labels'
     +/
     +/'The labels can be numbers, text or neither. If you choose'
     +/'to display labels rather than numbers, you can edit the labels'
     +/'to your requirements, and choose the number to be displayed.'
     +/'However, note that as you increase the number of labels, the'
     +/'font size will have to be reduced accordingly. In general,'
     +/'you should aim to use a relatively small number of labels,'
     +/'say not greater than six, in order to retain legibility.')
  400 FORMAT ('Number of ',A,' labels required')
  500 FORMAT ('Number labels/ticks > 2 suppresses ',A,' title/arrow')
      END
C  
C