C
C
      SUBROUTINE XYZLIB$(NFILES, NFMAX, NIN, NMAX,
     +                   X, XMAX, XMIN, Y, YMAX, YMIN, Z, ZMAX, ZMIN,
     +                   FNAME, FSAV, TITLE, TSAV,
     +                   ABORT)
C
C ACTION: Use a library file to read in a set of X, Y, Z files
C         Returns vector files FSAV(NFILES)
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         ABORT = .TRUE. if library file not usable
C         09/08/1996 Derived from VECFIL/PFILES$/LIBFIL$
C         14/07/1997 win32 version
C         29/11/2001 added VU2CHK and FNLIB
C         08/02/2005 added CHECKF 
C         08/05/2007 added INTENTS
C         17/07/2007 introduced DEMDIR
C         02/08/2008 added call to ISITSF
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NFMAX, NIN, NMAX 
      INTEGER,             INTENT (OUT)   :: NFILES
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX), XMAX, XMIN,
     +                                       Y(NMAX), YMAX, YMIN,
     +                                       Z(NMAX), ZMAX, ZMIN 
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, FSAV(NFMAX),
     +                                       TITLE, TSAV(NFMAX)
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    I, IOS, J, K, IADD1, NCOL, NPTS, NROW
      INTEGER    LENDEM, LENFIL, LEN200
      INTEGER    K0, K1, K3
      PARAMETER (K0 = 0, K1 = 1, K3 = 3)
      DOUBLE PRECISION A, B, C
      CHARACTER  DIRDEM*1024, FNLIB*1024, LINE*80, TEMP*1024
      CHARACTER  BLANK*1, BSLASH*1
      PARAMETER (BLANK = ' ', BSLASH = '\')
      LOGICAL    YES
      EXTERNAL   W95_TXT2FN
      EXTERNAL   CHECKF, OFILES$, PUTADV$, PUTFAT$, MAXMIN$, VU2CHK,
     +           LEN200, DEMDIR, TRIML1, ISITSF
      INTRINSIC  INDEX
C
C First initialise ABORT, NFILES
C
      ABORT = .TRUE.
      NFILES = K0
      NCOL = K1                      !to silence NAGfor  
      IF (NCOL.GT.K0) ABORT = .TRUE. !to silence NAGfor
C
C Read in from a supposed library file
C
      CLOSE (UNIT = NIN)
      CALL OFILES$(K3, NIN,
     +             FNAME,
     +             ABORT)
      CLOSE (UNIT = NIN)
      FNLIB = FNAME
      IF (FNAME.EQ.BLANK) ABORT = .TRUE.
      IF (ABORT) RETURN
      ABORT = .TRUE.
      OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
      IF (IOS.NE.K0) GOTO 60
      READ (NIN,100,END=60,ERR=60,IOSTAT=IOS) TITLE
      IF (IOS.NE.K0) GOTO 60
      CLOSE (UNIT = NIN)
      CALL CHECKF (FNAME, TITLE,
     +             ABORT)
      IF (ABORT) THEN
         RETURN
      ELSE
         OPEN (UNIT = NIN, FILE = FNAME)
         READ (NIN,100,END=60,ERR=60,IOSTAT=IOS) TITLE
         IF (IOS.NE.K0) GOTO 60
         ABORT = .TRUE.
      ENDIF
      IADD1 = K0
      DO I = K1, NFMAX
         READ (NIN,100,END=20,ERR=20,IOSTAT=IOS) FNAME
         IF (IOS.EQ.K0 .AND. FNAME.EQ.BLANK) THEN
            IOS = K1
            GOTO 20
         ENDIF     
         CALL W95_TXT2FN (FNAME,
     +                    ABORT)
         IF (ABORT) THEN
            CALL PUTFAT$('A filename is not consistent')
            WRITE (LINE,200) I + K1
            CALL PUTADV$(LINE)
            GOTO 60
         ENDIF
         IF (IOS.NE.K0) GOTO 20
         IADD1 = IADD1 + K1
         FSAV(IADD1) = FNAME
      ENDDO
   20 CONTINUE
      CLOSE (UNIT = NIN)
      IF (IADD1.EQ.K0) THEN
         CALL PUTFAT$('There are no (x,y,z) files in the library file')
         CALL VU2CHK (FNLIB)
         ABORT = .TRUE.
         RETURN
      ENDIF
C
C IADD1 character variables have now been read off the file
C
      CALL DEMDIR (LENDEM,
     +             DIRDEM)     
      DO I = K1, IADD1
         INQUIRE (FILE = FSAV(I), EXIST = YES, IOSTAT = IOS)
         IF (IOS.NE.K0) GOTO 40
         IF (.NOT.YES) THEN
            IF (LENDEM.GT.0 .AND. INDEX(FSAV(I),BSLASH).LE.0) THEN
               TEMP = FSAV(I)
               CALL TRIML1 (TEMP)
               LENFIL = LEN200(TEMP)
               FSAV(I) = DIRDEM(1:LENDEM)//TEMP(1:LENFIL)
               INQUIRE (FILE = FSAV(I), EXIST = YES, IOSTAT = IOS)
               IF (IOS.NE.K0) GOTO 40
            ENDIF     
         ENDIF  
         IF (YES) THEN
C
C Check it is a Simfit data file
C           
            CALL ISITSF (J, K,
     +                   FSAV(I))
            IF (J.LE.K0 .OR. K.LE.K0) YES = .FALSE.            
         ENDIF    
         IF (YES) THEN
           CLOSE (UNIT = NIN)
           OPEN (UNIT = NIN, FILE = FSAV(I))
           READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) TITLE
           IF (IOS.NE.K0) GOTO 40
           READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) J, K
           IF (IOS.NE.K0) GOTO 40
           IF (J.GT.K0 .AND. K.EQ.K3) THEN
              IF (J.GT.NMAX) THEN
                 IOS = K1
                 CALL PUTFAT$(
     +'Maximum array dimension exceeded in library file')
              ELSE
                 NFILES = NFILES + K1
                 FSAV(NFILES) = FSAV(I)
              ENDIF
           ELSE
              IOS = K1
              CALL PUTFAT$(
     +'Illegal file referenced in library file')
           ENDIF
         ELSE
            IOS = K1
            CALL PUTFAT$(
     +'File referenced in library file not found')
         ENDIF
   40    CONTINUE
         IF (IOS.NE.K0) THEN
            WRITE (LINE,200) I + K1
            CALL PUTADV$(LINE)
            ABORT = .TRUE.
            CLOSE (UNIT = NIN)
            GOTO 60
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
C
C Read data off all files
C
      IF (NFILES.GT.K0) THEN
         IADD1 = K0
         DO I = K1, NFILES
            IADD1 = IADD1 + K1
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FSAV(I))
            READ (NIN,100,END=60,ERR=60,IOSTAT=IOS) TSAV(I)
            IF (IOS.NE.K0) GOTO 60
            READ (NIN,*,END=60,ERR=60,IOSTAT=IOS) NROW, NCOL
            IF (IOS.NE.K0) GOTO 60
C
C Read X, Y, Z
C
            NPTS = K0
            DO J = K1, NROW
               READ (NIN,*,END=60,ERR=60,IOSTAT=IOS) A, B, C
               IF (IOS.NE.K0) GOTO 60
               NPTS = NPTS + K1
               X(NPTS) = A
               Y(NPTS) = B
               Z(NPTS) = C
            ENDDO
C
C Find the minimum and maximum of the current X and Y Values ..........
C
            IF (IADD1.EQ.K1) THEN
               CALL MAXMIN$(K0, NPTS,
     +                      X, XMAX, XMIN)
               CALL MAXMIN$(K0, NPTS,
     +                      Y, YMAX, YMIN)
               CALL MAXMIN$(K0, NPTS,
     +                      Z, ZMAX, ZMIN)
            ELSE
               CALL MAXMIN$(K1, NPTS,
     +                      X, XMAX, XMIN)
               CALL MAXMIN$(K1, NPTS,
     +                      Y, YMAX, YMIN)
               CALL MAXMIN$(K1, NPTS,
     +                      Z, ZMAX, ZMIN)
            ENDIF
         ENDDO
         ABORT = .FALSE.
         RETURN
      ENDIF
C
C Crash
C
   60 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL PUTFAT$(
     +'File is not a consistent x,y,z type library file')
      CALL VU2CHK (FNLIB) 
C
C Format statements
C      
  100 FORMAT (A)
  200 FORMAT ('Check your library file at line',I3)
      END
C
C
