C
C
      SUBROUTINE XYZTXT$(ICOLOR, IFONT, KMODE, NGKS, NTEXT, NOUT_PS,
     +                   SIZE, XADDPS, XSTART, XSTOP, Y_SCALE,
     +                   YSTART, YSTOP, 
     +                   SYMBOL, TEXT, TYPE1,
     +                   HARD_COPY, HPGL, PS)
C
C ACTION : Draw text on 3D histogram
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 15/9/95 
C          13/05/2007 added INTENTS
C
C          Text data must be set in the calling program, e.g. H3DCCC
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: ICOLOR, IFONT, KMODE, NGKS,
     +                                    NTEXT, NOUT_PS
      DOUBLE PRECISION,    INTENT (IN) :: SIZE, XADDPS, XSTART, XSTOP, 
     +                                    Y_SCALE, YSTART, YSTOP
      CHARACTER (LEN = *), INTENT (IN) :: SYMBOL(NTEXT), TEXT(NTEXT),
     +                                    TYPE1
      LOGICAL,             INTENT (IN) :: HARD_COPY, HPGL, PS
C
C Locals
C      
      INTEGER    I, NFONT
      
      DOUBLE PRECISION SLANT, XDELTA, XTEMP, YDELTA, YTEMP
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER  FONT*10
      PARAMETER (FONT = '/Helvetica')
      EXTERNAL   PLTSTR$, WGBFNT$
      INTRINSIC  DBLE
      CALL WGBFNT$(I, NFONT, SLANT)
      IF (KMODE.EQ.4) THEN
         XDELTA = (XSTOP - XSTART)/DBLE(NTEXT)
         XTEMP = XSTART - XDELTA/TWO
         YDELTA = (YSTOP - YSTART)/DBLE(NTEXT)
         YTEMP = YSTART - YDELTA/TWO
         DO I = 1, NTEXT
            XTEMP = XTEMP + XDELTA
            YTEMP = YTEMP + YDELTA
            CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +                   ZERO, SIZE, ZERO, XTEMP + XADDPS, YTEMP,
     +                   Y_SCALE,
     +                   FONT, TEXT(I), SYMBOL(I), TYPE1,
     +                   HARD_COPY, HPGL, PS)
         ENDDO
      ELSE
         XDELTA = (XSTOP - XSTART)/(DBLE(NTEXT) - ONE)
         XTEMP = XSTART
         YDELTA = (YSTOP - YSTART)/(DBLE(NTEXT) - ONE)
         YTEMP = YSTART
         DO I = 2, NTEXT - 1
            XTEMP = XTEMP + XDELTA
            YTEMP = YTEMP + YDELTA
            CALL PLTSTR$(ICOLOR, IFONT, NFONT, NGKS, NOUT_PS,
     +                   ZERO, SIZE, ZERO, XTEMP + XADDPS, YTEMP,
     +                   Y_SCALE,
     +                   FONT, TEXT(I), SYMBOL(I), TYPE1,
     +                   HARD_COPY, HPGL, PS)
         ENDDO
      ENDIF
      END
C 
C