C
C
      SUBROUTINE YLABEL$(ICOLOR, KCOLOR, KTIC, MYTIC, NCFONT, NKCOL,
     +                   NLOG, NOUT_PS, NWORDS, NYFIG, NYMAG,
     +                   CHEIGHT,
     +                   EXTRA3, EXTRA4, PSADDY, THICK,
     +                   XB, XBEGIN, XEND, XPC, XSTART,
     +                   YA, YB, YMAX, YMIN, Y_SCALE, YTIC,
     +                   BOXIT, BRAY_CURTIS, HARD_COPY, HPGL, MONO,
     +                   NATLOG, OFFSET, PCENTY, PHIGHY,
     +                   PLOTY, POWERY, PS, SHOW_YAXIS, TWO_PLOTS,
     +                   YGRID, YTOINT)
C
C
C ACTION : Y-legend/label for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 6/6/95
C          08/08/1995 Added call to PSWORD for exponent
C          12/09/1995 Changed PSWORD to PSNUMB
C          18/09/1996 Added NWORDS and PLOTY
C          19/09/1996 PLTSTR$
C          15/10/1996 Introduced POWERY for powers of ten
C          16/10/1996 Introduced NYFIG for significant digits
C          14/11/1996 Added TWO_PLOTS
C          14/07/1997 win32 version
C          01/02/2000 Added NATLOG
C          18/02/2000 added PCENTY
C          23/02/2000 added PHIGHY
C          03/07/2000 rationalised for double precision plotting
C          23/10/2000 suppressed tick mark if PLOTY(I + 1) = .FALSE.
C          06/11/2000 added NFONT
C          21/07/2001 added SHOW_YAXIS
C          10/08/2001 added BRAY_CURTIS
C          19/06/2003 checked MYTIC and PLOTY before plotting
C          08/05/2007 added INTENTS
C          04/11/2008 added calls to SAVGRD$
C          21/07/2009 added GRFSIG$ 
C          26/08/2009 extensive editing and disabled PHIGHY
C          21/10/2009 added labelling improvements suggested by Samad  
C          01/12/2010 allowed a ygrid in two plot mode 
C          13/02/2011 added call to FSIZES$ to adjust font size
C          26/12/2013 added PS_SIZE to make sure font-size changes are reversed  
C          20/01/2015 altered lines 358 and 363 to display powers for, e.g. 10^0 = 1 and 10^1 = 10  
C          23/06/2016 added call to XFRMAT$       
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER,          INTENT (IN)    :: NKCOL, NLOG, NWORDS, NOUT_PS
      INTEGER,          INTENT (IN)    :: KCOLOR(NKCOL), KTIC, MYTIC, 
     +                                    NCFONT, NYMAG
      INTEGER,          INTENT (OUT)   :: NYFIG 
      INTEGER,          INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION, INTENT (IN)    :: CHEIGHT, EXTRA3, EXTRA4,
     +                                    PSADDY, THICK, XB, 
     +                                    XEND, XPC, XSTART, YA, YB,
     +                                    YMAX, YMIN, Y_SCALE, YTIC 
      DOUBLE PRECISION, INTENT (INOUT) :: XBEGIN
      LOGICAL,          INTENT (IN)    :: BOXIT, BRAY_CURTIS, HARD_COPY,
     +                                    HPGL, MONO, NATLOG(NLOG),
     +                                    OFFSET, PCENTY, PHIGHY, 
     +                                    PLOTY(NWORDS), POWERY, PS,
     +                                    SHOW_YAXIS, TWO_PLOTS, YGRID
      LOGICAL,          INTENT (INOUT) :: YTOINT
C
C Locals
C
      INTEGER    I_COLR, I_LINE, I_WIDE, J_COLR
      INTEGER    I, J, LEN200, MTRANS, NFONT, NY, NYMAG1
      INTEGER    ISIGY, ITYPE, NFIGY, NSIGY
      PARAMETER (ISIGY = 3, ITYPE = 14)
      INTEGER    N0, N1, N2, N3, N7
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N7 = 7)
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FOUR, TEN, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00, TEN = 10.0D+00,
     +           F100 = 100.0D+00)
      DOUBLE PRECISION XBOX1, XBOX2, XTEMP1, XTEMP2, YBEGIN,
     +                 YTEMP, YVAL, X, Y
      DOUBLE PRECISION ANGLE, Y1, Y2, Y3, YSIZE
      DOUBLE PRECISION DI, DMYTIC, WIDTH
      DOUBLE PRECISION PS_SIZE(2)
      CHARACTER  TIME10*3
      PARAMETER (TIME10 = '*10')
      CHARACTER  EXPONT*4, FRMAT*20, LABEL4*4, LABEL5*5, 
     +           LABEL7*7, TLABEL*10
      CHARACTER  BLANK*1, SYMBOL*10, WORD1*1, WORD2*2
      PARAMETER (BLANK = ' ')
      LOGICAL    OK, GTYPE1
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   TRIML1, LEN200
      EXTERNAL   GSLN$, GSLWSC$, DASHED_LINE$, PSNUMB$, WGBFNT$,
     +           SOLID_LINE$, PLTSTR$, SAVGRD$, GRFSIG$, SAVETR$,
     +           FSIZES$
      EXTERNAL   XFRMAT$
      INTRINSIC  ABS, NINT, MIN, DBLE, LOG10, MAX
      SAVE       WORD2
      DATA       WORD2 / '10' /
C
C Define NFONT
C
      CALL WGBFNT$(I, NFONT, 
     +             ANGLE)
C
C Use PHIGHY to silence FTN95
C     
      OK = PHIGHY
C
C Check then initialise formats
C
      NYFIG = 0
      IF (MYTIC.LT.0) RETURN
C
C Define PS_SIZE and YSIZE 
C     
      DO I = 1, 2
         PS_SIZE(I) = - ONE
      ENDDO   
      CALL FSIZES$ (ITYPE,
     +              YSIZE,
     +              STORE)
      IF (PS) THEN
         WRITE (NOUT_PS,100) YSIZE
         PS_SIZE(1) = YSIZE
         WRITE (NOUT_PS,200) YSIZE
         PS_SIZE(2) = YSIZE
      ENDIF           
      OK = .FALSE.
      DO I = 0, MYTIC
         IF (PLOTY(I + 1)) OK = .TRUE.
      ENDDO
      IF (.NOT.OK) then
C
C Restore font sizes 
C      
         IF (PS) THEN
            IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)
            IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)
         ENDIF           
        RETURN
      ENDIF  
      DMYTIC = DBLE(MYTIC)  
      IF (YTOINT .AND. MYTIC.GT.0) THEN
         DO I = 0, MYTIC
            DI = DBLE(I)
            YVAL = DI*(YMAX - YMIN)/DMYTIC + YMIN
            NY = NINT(YVAL)
            IF (I.GT.0) THEN
               IF (NY.EQ.J) YTOINT = .FALSE.
            ENDIF
            J = NY
         ENDDO
      ENDIF
      OK = POWERY
      IF (POWERY .AND. MYTIC.GT.0) THEN
         DO I = 0, MYTIC
            DI = DBLE(I)
            YVAL = DI*(YMAX - YMIN)/DMYTIC + YMIN
            NY = NINT(YVAL)
            IF (ABS(YVAL).GT.0.001D+00) THEN
               IF (ABS((DBLE(NY) - YVAL)/YVAL).GT.0.01D+00) OK = .FALSE.
            ENDIF
            IF (I.GT.0) THEN
               IF (NY.EQ.J) OK = .FALSE.
            ENDIF
            J = NY
         ENDDO
      ENDIF
      GTYPE1 = .FALSE.
      IF (YTOINT) THEN
         IF (YMIN.GE.-9999999.0D+00 .AND. 
     +       YMAX.LE. 9999999.0D+00) THEN
            GTYPE1 = .TRUE.
         ENDIF
      ENDIF
      IF (.NOT.GTYPE1) THEN
         CALL SAVETR$ (MTRANS,
     +                 STORE)            
         CALL GRFSIG$(ISIGY, MTRANS, NFIGY, NSIGY,
     +               'Y')  
         IF (NSIGY.EQ.3) THEN
C
C High precision
C              
            IF (NYMAG .LT. - N2) THEN
               WRITE (FRMAT, '(A,I4,A)') '(',-NYMAG,'P,F8.4)'
            ELSEIF (NYMAG .EQ. - N2) THEN
               FRMAT = '(F10.6)'
            ELSEIF (NYMAG .EQ. - N1) THEN
              FRMAT = '(F10.5)'
            ELSEIF (NYMAG.EQ. N0) THEN
               FRMAT = '(F10.4)'
            ELSEIF (NYMAG .EQ. N1) THEN
               FRMAT = '(F10.3)'
            ELSEIF (NYMAG .EQ. N2) THEN
               FRMAT = '(F10.2)'
            ELSEIF (NYMAG .EQ. N3) THEN
               FRMAT = '(F10.1)'   
            ELSE
               WRITE (FRMAT, '(A,I4,A)') '(',-NYMAG,'P,F8.4)'
            ENDIF
         ELSEIF (NSIGY.EQ.2) THEN  
C
C Automatic precision
C
            NFIGY = MAX(N1,NFIGY)

            NYMAG1 = NYMAG
         
            IF (NYMAG1.EQ.-N2 .OR.
     +         (NYMAG1.EQ.-N1 .AND. NFIGY.EQ.N1) .OR.
     +         (NYMAG1.GE.N0  .AND. NYMAG1.LE.N3)) THEN
               NFIGY =  NFIGY - NYMAG1
               NYMAG1 = N0
            ENDIF                        

            IF (NFIGY.LT.N1) THEN
               NFIGY = N1
            ELSEIF (NFIGY.GT.N7) THEN   
               NFIGY = N7
            ENDIF   

            WRITE (WORD1,'(I1)') NFIGY

            IF (NYMAG1.GE.-N2 .AND. NYMAG1.LE.N3) THEN
               FRMAT = '(F10.'//WORD1//')'
            ELSE   
               WRITE (FRMAT, '(A,I4,A)') '(',-NYMAG,'P,F10.'//WORD1//')'
            ENDIF   
            
            IF (NYMAG1 .EQ. N2 .OR. NYMAG1 .EQ. N3) THEN
               IF (NFIGY.LT.N2) GTYPE1 = .TRUE.
            ENDIF
         ELSE
C
C low precision
C           
            IF (NYMAG .LT. - N2) THEN
               WRITE (FRMAT, '(A,I4,A)') '(',-NYMAG,'P,F6.1)'
            ELSEIF (NYMAG .EQ. - N2) THEN
               FRMAT = '(F10.3)'
            ELSEIF (NYMAG .EQ. - N1) THEN
              FRMAT = '(F10.2)'
            ELSEIF (NYMAG.EQ. N0) THEN
               FRMAT = '(F10.1)'
            ELSEIF (NYMAG .EQ. N1) THEN
               FRMAT = '(F10.1)'
            ELSEIF (NYMAG .EQ. N2 .OR. NYMAG .EQ. N3) THEN
               GTYPE1 = .TRUE.
            ELSE
               WRITE (FRMAT, '(A,I4,A)') '(',-NYMAG,'P,F6.1)'
            ENDIF
         ENDIF
      ENDIF
C
C Calculate parameters for tick marks on Y-axis ........................
C
      IF (OFFSET) THEN
         XBOX1 = XEND
      ELSE
         XBOX1 = XB
      ENDIF
C
C Save XBEGIN as XTEMP1 in case translation required
C
      XTEMP1 = XBEGIN
      XBEGIN = XBEGIN - CHEIGHT/TEN
      IF (KTIC.EQ.1) THEN
         XBEGIN = XBEGIN - YTIC
         XTEMP2 = XTEMP1 - YTIC
         XBOX2 = XBOX1 + YTIC
      ELSEIF (KTIC.EQ.2) THEN
         XTEMP2 = XTEMP1
         XBOX2 = XBOX1
      ELSE
         XTEMP2 = XTEMP1 + YTIC
         XBOX2 = XBOX1 - YTIC
      ENDIF
C
C Set the line thickness for tick marks then draw and label ...........
C
      IF (POWERY) THEN
         IF (NATLOG(1)) THEN
            WORD2 = ' e'
         ELSEIF (NATLOG(2)) THEN
            WORD2 = ' 2'
         ELSEIF (NATLOG(3)) THEN
            WORD2 = ' 3'
         ELSEIF (NATLOG(4)) THEN
            WORD2 = ' 4'
         ELSEIF (NATLOG(5)) THEN
            WORD2 = ' 5'
         ELSEIF (NATLOG(6)) THEN
            WORD2 = ' 6'
         ELSEIF (NATLOG(7)) THEN
            WORD2 = ' 7'
         ELSEIF (NATLOG(8)) THEN
            WORD2 = ' 8'
         ELSEIF (NATLOG(9)) THEN
            WORD2 = ' 9'
         ELSEIF (NATLOG(10)) THEN
            WORD2 = '10'
         ENDIF
      ENDIF
      DO I = 0, MYTIC
         DI = DBLE(I)
         IF (MYTIC.EQ.0) THEN
            YTEMP = (YA + YB)/TWO
            YVAL = (YMAX + YMIN)/TWO
         ELSE
            YTEMP = DI*(YB - YA)/DMYTIC + YA
            YVAL = DI*(YMAX - YMIN)/DMYTIC + YMIN
         ENDIF
         IF (BRAY_CURTIS) YVAL = F100 - YVAL
         IF (.NOT.MONO) ICOLOR = KCOLOR(2)
         IF (SHOW_YAXIS .AND. PLOTY(I + 1)) THEN
            CALL SOLID_LINE$(XTEMP1, YTEMP, XTEMP2, YTEMP, ICOLOR)
            IF (BOXIT .AND. .NOT.TWO_PLOTS)
     +         CALL SOLID_LINE$(XBOX1, YTEMP, XBOX2, YTEMP, ICOLOR)
         ENDIF
         
         IF (YGRID) THEN
C         IF (YGRID .AND..NOT.TWO_PLOTS) THEN
C
C Draw grid lines
C           
            CALL SAVGRD$(I_COLR, I_LINE, I_WIDE,
     +                   STORE)           
            CALL GSLN$(I_LINE)
            IF (I_COLR.LT.0) THEN
               J_COLR = ICOLOR
            ELSE
               J_COLR = I_COLR
            ENDIF      
            IF (I_WIDE.EQ.1) THEN
               WIDTH = THICK/FOUR
            ELSEIF (I_WIDE.EQ.2) THEN
               WIDTH = THICK/TWO
            ELSEIF (I_WIDE.EQ.3) THEN
               WIDTH = THICK 
            ELSEIF (I_WIDE.EQ.4) THEN
               WIDTH = THREE*THICK/TWO     
            ELSE   
               WIDTH = TWO*THICK
            ENDIF   
            CALL GSLWSC$(WIDTH)
            IF (I_LINE.EQ.1) THEN  
               CALL SOLID_LINE$(XSTART, YTEMP, XBOX1, YTEMP, J_COLR)
            ELSE   
               CALL DASHED_LINE$(XSTART, YTEMP, XBOX1, YTEMP, J_COLR)
            ENDIF   
            CALL GSLWSC$(THICK)
         ENDIF
         
         IF (PLOTY(I + 1)) THEN
            IF (POWERY) THEN
               IF (OK) THEN
                  NY = NINT(YVAL)
                  IF (NY.EQ.0) THEN
C                     TLABEL = '1'
C                     SYMBOL = '0'
                      TLABEL = WORD2//'0'
                      SYMBOL = '002'
                  ELSEIF (NY.EQ.1) THEN
C                     TLABEL = WORD2
C                     SYMBOL = '00'
                      TLABEL = WORD2//'1'
                      SYMBOL = '002'
                  ELSE
                     WRITE (LABEL5,'(I5)') NY
                     CALL TRIML1 (LABEL5)
                     TLABEL = WORD2//LABEL5
                     SYMBOL = '0022222'
                  ENDIF
               ELSE
                  WRITE (LABEL7,'(F7.2)') YVAL
                  CALL TRIML1(LABEL7)
                  TLABEL = WORD2//LABEL7(1:5)
                  SYMBOL = '0022222'
               ENDIF
            ELSE
               IF (GTYPE1) THEN
                  WRITE (TLABEL,'(I10)') NINT(YVAL)
               ELSE
                  WRITE (TLABEL,FRMAT) YVAL
                  IF (NSIGY.EQ.2) CALL XFRMAT$ (NSIGY,
     +                                          YVAL,
     +                                          TLABEL, FRMAT)                   
               ENDIF
               CALL TRIML1 (TLABEL)
               SYMBOL = '0000000000'
            ENDIF
            IF (.NOT.MONO) ICOLOR = KCOLOR(3)
C
C Specify the X,Y-coordinates for the labels
C
            X = MIN(XTEMP1,XTEMP2) - TWO*YTIC
            Y = YTEMP
C
C Add a % if PCENTY = .TRUE.
C
            IF (PCENTY .AND. .NOT.POWERY) THEN
               CALL TRIML1 (TLABEL)
               J = LEN200(TLABEL)
               IF (J.LT.10) TLABEL(J + 1:J + 1) = '%'
               SYMBOL = '00000000'
            ENDIF
            CALL PLTSTR$(ICOLOR, NCFONT, NFONT, N0, NOUT_PS,
     +                   ZERO, YSIZE*XPC, ZERO, X, Y, Y_SCALE, BLANK,
     +                   TLABEL,
     +                   SYMBOL, 'ty', HARD_COPY, HPGL, PS)
            CALL TRIML1 (TLABEL)
            NYFIG = MAX(NYFIG, LEN200(TLABEL))
         ENDIF
      ENDDO
C
C Draw extra tick marks if required.....................................
C
      IF (SHOW_YAXIS .AND. NATLOG(12) .AND. OK .AND. POWERY .AND.
     +    MYTIC.GT.0 .AND. KTIC.NE.2) THEN
         IF (KTIC.EQ.1) THEN
            XTEMP2 = XTEMP2 + YTIC/TWO
            XBOX2 = XBOX2 - YTIC/TWO
         ELSE
            XTEMP2 = XTEMP2 - YTIC/TWO
            XBOX2 = XBOX2 + YTIC/TWO
         ENDIF
         IF (.NOT.MONO) ICOLOR = KCOLOR(2)
         Y1 = YA
         DO I = 1, MYTIC
            DI = DBLE(I)
            Y2 = DI*(YB - YA)/DMYTIC + YA
            Y3 = Y2 - Y1
            DO J = 2, 9
               YTEMP = Y1 + LOG10(DBLE(J))*Y3
               CALL SOLID_LINE$(XTEMP1, YTEMP, XTEMP2, YTEMP, ICOLOR)
               IF (BOXIT) CALL SOLID_LINE$(XBOX1, YTEMP, XBOX2, YTEMP,
     +                                     ICOLOR)
            ENDDO
            Y1 = Y2
         ENDDO
      ENDIF
C
C Draw Y-Axis exponential if required. Use DELTA to space exponent if req.
C
      IF (GTYPE1) THEN
C
C Restore font sizes 
C      
         IF (PS) THEN
            IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)
            IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)
         ENDIF          
         RETURN
      ENDIF  
      IF (NYMAG.LT.-N2 .OR. NYMAG.GT.N3) THEN
         WRITE (EXPONT, FMT = '(I4)') NYMAG
      ELSE
C
C Restore font sizes 
C      
         IF (PS) THEN
            IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)
            IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)
         ENDIF             
         RETURN
      ENDIF
      IF (.NOT.MONO) ICOLOR = KCOLOR(3)
      LABEL4 = EXPONT
      CALL TRIML1 (LABEL4)
      IF (PS) XBEGIN = XBEGIN + PSADDY
      YBEGIN = YB - CHEIGHT/TWO - EXTRA3 - EXTRA4
      IF (PS) THEN
         CALL PSNUMB$(ICOLOR, XBEGIN, YBEGIN, 'E'//LABEL4, 'tl')
      ELSE
         CALL PLTSTR$(ICOLOR, NCFONT, NFONT, N0, NOUT_PS,
     +                ZERO, YSIZE*XPC, ZERO, XBEGIN, YBEGIN, Y_SCALE,
     +                BLANK,
     +                TIME10//LABEL4, '3002222', 'tr', HARD_COPY, HPGL,
     +                PS)
      ENDIF
      NYFIG = MAX(NYFIG, LEN200(LABEL4) + 3)
C
C Restore font sizes 
C      
      IF (PS) THEN
         IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)
         IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)
      ENDIF   
C
C This format statements must NOT be edited
C      
  100 FORMAT ('/ty-size ty-size',1X,f7.3,1X,'mul def')
  200 FORMAT ('/tl-size tl-size',1X,f7.3,1X,'mul def')
      END
C
C
