C
C
      SUBROUTINE Z2TEMP$(ITHETA, NEBMAX, NMAX, NX, NXTEMP, NY, NYTEMP,
     +                   EB, EBTEMP, X, XTEMP, Y, YTEMP, Z, ZTEMP)
C
C
C ACTION : Transform XYZ to correspond to rotations
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 1/9/95
C          29/09/1995 Removed ISAV
C          25/02/2002 added NEBMAX, EB, EBTEMP 
C          13/05/2007 added INTENTS
C
      IMPLICIT  NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NEBMAX, NMAX, NX, NY
      INTEGER,          INTENT (INOUT) :: ITHETA
      INTEGER,          INTENT (OUT)   :: NXTEMP, NYTEMP
      DOUBLE PRECISION, INTENT (IN)    :: EB(NEBMAX,NEBMAX), 
     +                                    X(NMAX), Y(NMAX), 
     +                                    Z(NMAX,NMAX) 
      DOUBLE PRECISION, INTENT (OUT)   :: EBTEMP(NEBMAX,NEBMAX),
     +                                    XTEMP(NMAX), YTEMP(NMAX),
     +                                    ZTEMP(NMAX,NMAX)
C
C Locals
C      
      INTEGER   I, J, K
      EXTERNAL  PUTWAR$
C
C Initialise if ITHETA not 0, 90, 180, 270
C
      IF (ITHETA.NE.0 .AND. ITHETA.NE.90 .AND.ITHETA.NE.180 .AND.
     +    ITHETA.NE.270) THEN
         CALL PUTWAR$('ITHETA re-set to 0 in Z2TEMP')
         ITHETA = 0
      ENDIF
C
C Define temporary variables
C
      IF (ITHETA.EQ.0) THEN
         NXTEMP = NX
         DO I = 1, NXTEMP
            XTEMP(I) = X(I)
         ENDDO
         NYTEMP = NY
         DO I = 1, NYTEMP
            YTEMP(I) = Y(I)
         ENDDO
         DO J = 1, NYTEMP
            DO I = 1, NXTEMP
               ZTEMP(I,J) = Z(I,J)
               EBTEMP(I,J) = EB(I,J)
            ENDDO
         ENDDO
      ELSEIF (ITHETA.EQ.90) THEN
         NXTEMP = NY
         DO I = 1, NXTEMP
            XTEMP(I) = Y(I)
         ENDDO
         NYTEMP = NX
         DO I = 1, NYTEMP
            YTEMP(I) = X(I)
         ENDDO
         DO J = 1, NYTEMP
            DO I = 1, NXTEMP
               ZTEMP(I,J) = Z(J, NXTEMP - I + 1)
               EBTEMP(I,J) = EB(J, NXTEMP - I + 1)
            ENDDO
         ENDDO
      ELSEIF (ITHETA.EQ.180) THEN
         NXTEMP = NX
         DO I = 1, NXTEMP
            XTEMP(I) = X(I)
         ENDDO
         NYTEMP = NY
         DO I = 1, NYTEMP
            YTEMP(I) = Y(I)
         ENDDO
         DO J = 1, NYTEMP
            K = NYTEMP - J + 1
            DO I = 1, NXTEMP
               ZTEMP(I,J) = Z(NXTEMP - I + 1, K)
               EBTEMP(I,J) = EB(NXTEMP - I + 1, K)
            ENDDO
         ENDDO
      ELSEIF (ITHETA.EQ.270) THEN
         NXTEMP = NY
         DO I = 1, NXTEMP
            XTEMP(I) = Y(I)
         ENDDO
         NYTEMP = NX
         DO I = 1, NYTEMP
            YTEMP(I) = X(I)
         ENDDO
         DO J = 1, NYTEMP
            K = NYTEMP - J + 1
            DO I = 1, NXTEMP
               ZTEMP(I,J) = Z(K,I)
               EBTEMP(I,J) = EB(K,I)
            ENDDO
         ENDDO
      ENDIF
      END
C
C
