C
C
      SUBROUTINE ZCOLOR$(COLOUR_INDEX,
     +                   ZMEAN)
C
C ACTION : Use ZMEAN to define COLOUR_INDEX
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 30/8/95
C          01/09/2001 redfined colour sequence to a 28 place rainbow effect  
C          13/05/2007 added INTENTS
C
C          Note: IRAIN must equal IRAIN in subroutine PALETT$
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (OUT) :: COLOUR_INDEX
      DOUBLE PRECISION, INTENT (IN)  :: ZMEAN
C
C Locals
C      
      INTEGER    IRAIN(28)
      DOUBLE PRECISION ZERO, ONE, FACTOR
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, FACTOR = 27.0D+00)
      EXTERNAL   PUTFAT$
      INTRINSIC  NINT
      DATA       IRAIN / 36, 12, 28,  4, 24,  6, 39, 30,
     +                   14, 38, 34, 10, 26,  2, 31,  3,
     +                   27, 11, 35, 33,  9, 25,  1, 32,
     +                    5, 13, 29, 37 /
      IF (ZMEAN.LT.ZERO .OR. ZMEAN.GT.ONE) THEN
         CALL PUTFAT$('ZMEAN out of range in ZCOLOR$')
         COLOUR_INDEX = 0
         RETURN
      ENDIF
C
C Map ZMEAN onto IRAIN (1 to 28) then return COLOUR_INDEX
C
      COLOUR_INDEX = IRAIN(1 + NINT(FACTOR*ZMEAN))
      END
C 
C