C
C
      SUBROUTINE ZLABEL$(ICOLOR, KCOLOR, KTIC, MZTIC, NCFONT, NKCOL,
     +                   NLOG, NOUT_PS, NWORDS, NZFIG, NZMAG,
     +                   CHEIGHT,
     +                   EXTRA3, EXTRA4,
     +                   XBEGIN, XPC,
     +                   ZA, ZB, ZMAX, ZMIN, Z_SCALE, ZTIC,
     +                   HARD_COPY, HPGL, MONO, NATLOG, PCENTZ, PHIGHZ,
     +                   PLOTZ, POWERZ, PS, SHOW_ZAXIS, ZTOINT)
     
C
C
C ACTION : Z-legend/label for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 6/6/95
C          07/08/1995 Derived from YLABEL
C          16/09/1996 Allowed to shift Z-axis
C          18/09/1996 Added NWORDS and PLOTZ
C          19/09/1996 Added PLTSTR$
C          15/10/1996 Added POWERZ for powers of ten
C          14/07/1997 win32 version
C          01/02/2000 Added NATLOG
C          18/02/2000 added PCENTZ
C          23/02/2000 added PHIGHZ
C          03/07/2000 rationalised for double precision plotting
C          23/10/2000 suppressed tick marks if PLOTZ(I + 1) = .FALSE.
C          06/11/2000 added NFONT
C          21/07/2001 added SHOW_ZAXIS.
C          19/06/2003 checked MZTIC and PLOTZ before plotting
C          08/05/2007 added INTENTS
C          21/07/2009 added GRFSIG$
C          26/08/2009 extensive editing and disabled PHIGHZ
C          21/10/2009 added labelling improvements suggested by Samad
C          13/02/2011 added call to FSIZES$ to adjust font sizes
C          26/12/2013 added PS_SIZE to make sure font-size changes are reversed 
C          23/06/2016 added call to XFRMAT$               
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER,          INTENT (IN)    :: NKCOL, NLOG, NOUT_PS, NWORDS
      INTEGER,          INTENT (IN)    :: KCOLOR(NKCOL), KTIC, MZTIC,
     +                                    NCFONT,  NZMAG
      INTEGER,          INTENT (OUT)   :: NZFIG 
      INTEGER,          INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION, INTENT (IN)    :: CHEIGHT, EXTRA3, EXTRA4,
     +                                    XPC, ZA, ZB, ZMAX,
     +                                    ZMIN, Z_SCALE, ZTIC 
      DOUBLE PRECISION, INTENT (INOUT) :: XBEGIN
      LOGICAL,          INTENT (IN)    :: HARD_COPY, HPGL, MONO,
     +                                    NATLOG(NLOG), PCENTZ, PHIGHZ,
     +                                    PLOTZ(NWORDS), POWERZ, PS,
     +                                    SHOW_ZAXIS 
      LOGICAL,          INTENT (INOUT) :: ZTOINT
C
C Locals
C
      INTEGER    I, J, LEN200, NFONT, NZ, NZMAG1
      INTEGER    ISIGZ, ITYPE, MTRANS, NFIGZ, NSIGZ
      PARAMETER (ISIGZ = 3, ITYPE = 15)
      INTEGER    N0, N1, N2, N3, N7
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N7 = 7)
      DOUBLE PRECISION ZERO, ONE, TWO, TEN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           TEN = 10.0D+00)
      DOUBLE PRECISION X, XBOX1, XBOX2, Y, ZBEGIN, ZTEMP, ZVAL
      DOUBLE PRECISION ANGLE, DI, DMZTIC, Z1, Z2, Z3, ZSIZE
      DOUBLE PRECISION PS_SIZE(2)
      CHARACTER  BLANK*1, TIME10*3
      PARAMETER (BLANK = ' ', TIME10 = '*10')
      CHARACTER  EXPONT*4, FRMAT*20, LABEL4*4, LABEL5*5, 
     +           LABEL7*7, TLABEL*10
      CHARACTER  SYMBOL*10, WORD1*1, WORD2*2
      LOGICAL    OK, GTYPE1
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   TRIML1, LEN200
      EXTERNAL   PSNUMB$, SOLID_LINE$, PLTSTR$, WGBFNT$, GRFSIG$, 
     +           SAVETR$, FSIZES$
      EXTERNAL   XFRMAT$
      INTRINSIC  ABS, NINT, LOG10, DBLE, MAX
C
C This SAVE prevents ftn95 from allowing the strings to become undefined
C
      SAVE       WORD2
      DATA       WORD2 / '10' /
C
C Define NFONT
C
      CALL WGBFNT$(I, NFONT,
     +             ANGLE)
  
C
C Use PHIGHZ to silence FTN95
C     
      OK = PHIGHZ
C
C Check then initialise formats
C
      NZFIG = 0
      IF (MZTIC.LT.0) RETURN
C
C Define ZSIZE
C     
      CALL FSIZES$ (ITYPE,
     +              ZSIZE,
     +              STORE)  
      DO I = 1, 2
         PS_SIZE(I) = - ONE
      ENDDO   
      IF (PS) THEN
         WRITE (NOUT_PS,100) ZSIZE   
         PS_SIZE(1) = ZSIZE   
         WRITE (NOUT_PS,200) ZSIZE
         PS_SIZE(2) = ZSIZE
      ENDIF         
      OK = .FALSE.
      DO I = 0, MZTIC
         IF (PLOTZ(I + 1)) OK = .TRUE.
      ENDDO
      IF (.NOT.OK) THEN
C
C Restore PS font sizes
C      
         IF (PS) THEN
            IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)      
            IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)      
         ENDIF          
         RETURN
      endif   
      DMZTIC = DBLE(MZTIC)  
      IF (ZTOINT .AND. MZTIC.GT.0) THEN
         DO I = 0, MZTIC
            DI = DBLE(I)
            ZVAL = DI*(ZMAX - ZMIN)/DMZTIC + ZMIN
            NZ = NINT(ZVAL)
            IF (I.GT.0) THEN
               IF (NZ.EQ.J) ZTOINT = .FALSE.
            ENDIF
            J = NZ
         ENDDO
      ENDIF
      OK = POWERZ
      IF (POWERZ .AND. MZTIC.GT.0) THEN
         DO I = 0, MZTIC
            DI = DBLE(I)
            ZVAL = DI*(ZMAX - ZMIN)/DMZTIC + ZMIN
            NZ = NINT(ZVAL)
            IF (ABS(ZVAL).GT.0.001D+00) THEN
               IF (ABS((DBLE(NZ) - ZVAL)/ZVAL).GT.0.01D+00) OK = .FALSE.
            ENDIF
            IF (I.GT.0) THEN
               IF (NZ.EQ.J) OK = .FALSE.
            ENDIF
            J = NZ
         ENDDO
      ENDIF
      GTYPE1 = .FALSE.
      IF (ZTOINT) THEN
         IF (ZMIN.GE.-9999999.0D+00 .AND.
     +       ZMAX.LE. 9999999.0D+00) THEN
            GTYPE1 = .TRUE.
         ENDIF
      ENDIF
      IF (.NOT.GTYPE1) THEN
         CALL SAVETR$ (MTRANS,
     +                 STORE)            
         CALL GRFSIG$(ISIGZ, MTRANS, NFIGZ, NSIGZ,
     +                'Z')
         IF (NSIGZ.EQ.3) THEN
C
C High precision
C              
            IF (NZMAG .LT. - N2) THEN
               WRITE (FRMAT, '(A,I4,A)') '(',-NZMAG,'P,F8.4)'
            ELSEIF (NZMAG .EQ. - N2) THEN
               FRMAT = '(F10.6)'
            ELSEIF (NZMAG .EQ. - N1) THEN
               FRMAT = '(F10.5)'
            ELSEIF (NZMAG.EQ. N0) THEN
               FRMAT = '(F10.4)'
            ELSEIF (NZMAG .EQ. N1) THEN
               FRMAT = '(F10.3)'
            ELSEIF (NZMAG .EQ. N2) THEN
               FRMAT = '(F10.2)'
            ELSEIF (NZMAG .EQ. N3) THEN
               FRMAT = '(F10.1)'   
            ELSE
               WRITE (FRMAT, '(A,I4,A)') '(',-NZMAG,'P,F8.4)'
            ENDIF
         ELSEIF (NSIGZ.EQ.2) THEN  
C
C Automatic precision
C
            NFIGZ = MAX(N1,NFIGZ)

            NZMAG1 = NZMAG
         
            IF (NZMAG1.EQ.-N2 .OR.
     +         (NZMAG1.EQ.-N1 .AND. NFIGZ.EQ.N1) .OR.
     +         (NZMAG1.GE.N0  .AND. NZMAG1.LE.N3)) THEN
               NFIGZ =  NFIGZ - NZMAG1
               NZMAG1 = N0
            ENDIF                        

            IF (NFIGZ.LT.N1) THEN
               NFIGZ = N1
            ELSEIF (NFIGZ.GT.N7) THEN   
               NFIGZ = N7
            ENDIF   
        
            WRITE (WORD1,'(I1)') NFIGZ

            IF (NZMAG1.GE.-N2 .AND. NZMAG1.LE.N3) THEN
               FRMAT = '(F10.'//WORD1//')'
            ELSE   
               WRITE (FRMAT, '(A,I4,A)') '(',-NZMAG,'P,F10.'//WORD1//')'
            ENDIF   
            
            IF (NZMAG1 .EQ. N2 .OR. NZMAG1 .EQ. N3) THEN
               IF (NFIGZ.LT.N2) GTYPE1 = .TRUE.
            ENDIF                     
         ELSE
C
C Low precision
C           
            IF (NZMAG .LT. - N2) THEN
               WRITE (FRMAT, '(A,I4,A)') '(',-NZMAG,'P,F6.1)'
            ELSEIF (NZMAG .EQ. - N2) THEN
               FRMAT = '(F10.3)'
            ELSEIF (NZMAG .EQ. - N1) THEN
               FRMAT = '(F10.2)'
            ELSEIF (NZMAG.EQ. N0) THEN
               FRMAT = '(F10.1)'
            ELSEIF (NZMAG .EQ. N1) THEN
               FRMAT = '(F10.1)'
            ELSEIF (NZMAG .EQ. N2 .OR. NZMAG .EQ. N3) THEN
               GTYPE1 = .TRUE.
            ELSE
               WRITE (FRMAT, '(A,I4,A)') '(',-NZMAG,'P,F6.1)'
            ENDIF
         ENDIF
      ENDIF
C
C Calculate parameters for tick marks on Z-axis ........................
C
      XBOX1 = XBEGIN
      XBEGIN = XBOX1 + CHEIGHT/TEN
      IF (KTIC.EQ.1) THEN
         XBEGIN = XBEGIN + ZTIC
         XBOX2 = XBOX1 + ZTIC
      ELSEIF (KTIC.EQ.2) THEN
         XBOX2 = XBOX1
      ELSE
         XBOX2 = XBOX1 - ZTIC
      ENDIF
C
C Set the line thickness for tick marks then draw and label ...........
C
      IF (POWERZ) THEN
         IF (NATLOG(1)) THEN
            WORD2 = ' e'
         ELSEIF (NATLOG(2)) THEN
            WORD2 = ' 2'
         ELSEIF (NATLOG(3)) THEN
            WORD2 = ' 3'
         ELSEIF (NATLOG(4)) THEN
            WORD2 = ' 4'
         ELSEIF (NATLOG(5)) THEN
            WORD2 = ' 5'
         ELSEIF (NATLOG(6)) THEN
            WORD2 = ' 6'
         ELSEIF (NATLOG(7)) THEN
            WORD2 = ' 7'
         ELSEIF (NATLOG(8)) THEN
            WORD2 = ' 8'
         ELSEIF (NATLOG(9)) THEN
            WORD2 = ' 9'
         ELSEIF (NATLOG(10)) THEN
            WORD2 = '10'
         ENDIF
      ENDIF
      DO I = 0, MZTIC
         DI = DBLE(I)
         IF (MZTIC.EQ.0) THEN
            ZTEMP = (ZA + ZB)/TWO
            ZVAL = (ZMAX + ZMIN)/TWO
         ELSE
            ZTEMP = DI*(ZB - ZA)/DMZTIC + ZA
            ZVAL = DI*(ZMAX - ZMIN)/DMZTIC + ZMIN
         ENDIF
         IF (.NOT.MONO) ICOLOR = KCOLOR(2)
         IF (SHOW_ZAXIS .AND. PLOTZ(I + 1)) THEN
            CALL SOLID_LINE$(XBOX1, ZTEMP, XBOX2, ZTEMP, ICOLOR)
            IF (POWERZ) THEN
               IF (OK) THEN
                  NZ = NINT(ZVAL)
                  IF (NZ.EQ.0) THEN
                     TLABEL = '1'
                     SYMBOL = '0'
                  ELSEIF (NZ.EQ.1) THEN
                     TLABEL = WORD2
                     SYMBOL = '00'
                  ELSE
                     WRITE (LABEL5,'(I5)') NZ
                     CALL TRIML1 (LABEL5)
                     TLABEL = WORD2//LABEL5
                     SYMBOL = '0022222'
                  ENDIF
               ELSE
                  WRITE (LABEL7,'(F7.2)') ZVAL
                  CALL TRIML1(LABEL7)
                  TLABEL = WORD2//LABEL7(1:5)
                  SYMBOL = '0022222'
               ENDIF
            ELSE
               IF (GTYPE1) THEN
                  WRITE (TLABEL,'(I10)') NINT(ZVAL)
               ELSE
                  WRITE (TLABEL,FRMAT) ZVAL
                  IF (NSIGZ.EQ.2) CALL XFRMAT$ (NSIGZ,
     +                                          ZVAL,
     +                                          TLABEL, FRMAT)                   
               ENDIF
               CALL TRIML1 (TLABEL)
               SYMBOL = '0000000000'
            ENDIF
            IF (.NOT.MONO) ICOLOR = KCOLOR(3)
            X = XBEGIN + ZTIC
            Y = ZTEMP
C
C Add a % if PCENTZ = .TRUE.
C
            IF (PCENTZ .AND. .NOT.POWERZ) THEN
               CALL TRIML1 (TLABEL)
               J = LEN200(TLABEL)
               IF (J.LT.10) TLABEL(J + 1:J + 1) = '%'
               SYMBOL = '0000000'
            ENDIF
            CALL PLTSTR$(ICOLOR, NCFONT, NFONT, N0, NOUT_PS,
     +                   ZERO, ZSIZE*XPC, ZERO, X, Y, Z_SCALE, BLANK,
     +                   TLABEL,
     +                   SYMBOL, 'tz', HARD_COPY, HPGL, PS)
            CALL TRIML1 (TLABEL)
            NZFIG = MAX(NZFIG, LEN200(TLABEL))
         ENDIF
      ENDDO
C
C Draw extra tick marks if required.....................................
C
      IF (SHOW_ZAXIS .AND. NATLOG(12) .AND. OK .AND. POWERZ .AND.
     +    MZTIC.GT.0 .AND. KTIC.NE.2) THEN
         IF (KTIC.EQ.1) THEN
            XBOX2 = XBOX2 + ZTIC/TWO
         ELSE
            XBOX2 = XBOX2 - ZTIC/TWO
         ENDIF
         IF (.NOT.MONO) ICOLOR = KCOLOR(2)
         Z1 = ZA
         DO I = 1, MZTIC
            DI = DBLE(I)
            Z2 = DI*(ZB - ZA)/DMZTIC + ZA
            Z3 = Z2 - Z1
            DO J = 2, 9
               ZTEMP = Z1 + LOG10(DBLE(J))*Z3
               CALL SOLID_LINE$(XBOX1, ZTEMP, XBOX2, ZTEMP, ICOLOR)
            ENDDO
            Z1 = Z2
         ENDDO
      ENDIF
C
C Draw Z-Axis exponential if required. Use DELTA to space exponent if req.
C
      IF (GTYPE1) THEN
C
C Restore PS font sizes
C      
         IF (PS) THEN
            IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)      
            IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)      
         ENDIF             
         RETURN
      ENDIF   
      IF (NZMAG.LT.-N2 .OR. NZMAG.GT.N3) THEN
         WRITE (EXPONT, FMT = '(I4)') NZMAG
      ELSE
C
C Restore PS font sizes
C      
         IF (PS) THEN
            IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)      
            IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)      
         ENDIF             
         RETURN
      ENDIF
      IF (.NOT.MONO) ICOLOR = KCOLOR(3)
      LABEL4 = EXPONT
      CALL TRIML1 (LABEL4)
      ZBEGIN = ZB - CHEIGHT/TWO - EXTRA3 - EXTRA4
      IF (PS) THEN
         CALL PSNUMB$(ICOLOR, XBEGIN + ZTIC, ZBEGIN, 'E'//LABEL4, 'tl')
      ELSE
         CALL PLTSTR$(ICOLOR, NCFONT, NFONT, N0, NOUT_PS,
     +                ZERO, ZSIZE*XPC, ZERO, XBEGIN + ZTIC, ZBEGIN,
     +                Z_SCALE,
     +                BLANK, TIME10//LABEL4, '3002222', 'tl',
     +                HARD_COPY, HPGL, PS)

      ENDIF
      NZFIG = MAX(NZFIG, LEN200(LABEL4) + 3)
C
C Restore PS font sizes
C      
      IF (PS) THEN
         IF (PS_SIZE(1).GT.ZERO) WRITE (NOUT_PS,100) ONE/PS_SIZE(1)      
         IF (PS_SIZE(2).GT.ZERO) WRITE (NOUT_PS,200) ONE/PS_SIZE(2)      
      ENDIF   
C
C This format statement must not be edited
C      
  100 FORMAT ('/tz-size tz-size',1X,f7.3,1X,'mul def')      
  200 FORMAT ('/tl-size tl-size',1X,f7.3,1X,'mul def')      
      END
C
C
