C
C Also requires:- ACM 493 RPOLY bundled as RPOLY with extensive editing
C ===============
C    RPOLY0$
C    FXSHFR$
C    QUADIT$
C    REALIT$
C    CALCSC$
C    NEXTTK$
C    NEWEST$
C    QUADSD$
C    QUAD00$
C
      SUBROUTINE C02AGF$(A, N, SCALE, Z, W, IFAIL)
C
C ACTION : Zeros of a real polynomial using RPOLY: ACM TOMS 493
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 7/5/97
C          The restriction on maximum degree is set by parameter
C          KMAX and the array declarations in the RPOLY code.
C          Note: this is not the NAG method
C          Extensive revision to make sure a.bd+00 is used everywhere
C          Date of this version 28/3/99
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER    IFAIL, N
      DOUBLE PRECISION A(0:N), Z(2,N), W(2*(N + 1))
      LOGICAL  SCALE
C
C Local variables
C
      INTEGER    I, NDEG
      INTEGER    K0, K1, K2, K3, K5, KMAX
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K5 = 5, KMAX = 200)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DOUBLE PRECISION OP(KMAX + 1), ZEROI(KMAX), ZEROR(KMAX)
      DOUBLE PRECISION RTOL, X02AMF$
      LOGICAL    FAULT
      EXTERNAL   RPOLY0$, X02AMF$
      INTRINSIC  ABS
C
C Is it safe ?
C
      W(1) = ONE!to silence ftn95
      IF (SCALE) IFAIL = K0!to silence ftn95
      IFAIL = K0
      RTOL = 1.0D+09*X02AMF$()
      IF (ABS(A(K0)).LE.RTOL) THEN
         IFAIL = K1
         RETURN
      ENDIF
      IF (N.LT.1) THEN
         IFAIL = K1
         RETURN
      ENDIF
      IF (N.GT.KMAX) THEN
         IFAIL = K5
         RETURN
      ENDIF
C
C Initialise
C
      DO I = K1, KMAX
         OP(I) = ONE
         ZEROI(I) = ONE
         ZEROR(I) = ONE
      ENDDO
      OP(KMAX + K1) = ONE
C
C Copy the arguments
C
       NDEG = N
       DO I = K1, NDEG + K1
          OP(I) = A(I - K1)
       ENDDO
C
C Find the zeros
C
       CALL RPOLY0$(OP, NDEG, ZEROR, ZEROI, FAULT)
       IF (FAULT) THEN
          IFAIL = K3
       ENDIF
C
C Return the real and imaginary parts in Z
C
       DO I = K1, N
          Z(K1,N - I + K1) = ZEROR(I)
          Z(K2,N - I + K1) = ZEROI(I)
       ENDDO
       END
C
C
