C
C
      SUBROUTINE C05NBF$(FCN, N, X, FVEC, XTOL, WA, LWA, IFAIL)
C
C ACTION : Version of NAG routine C05NBF
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 23/1/99
C
      IMPLICIT   NONE
      INTEGER    N, LWA, IFAIL
      INTEGER    INFO
      DOUBLE PRECISION X(N), FVEC(N), XTOL, WA(LWA)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION TOL
      EXTERNAL   FCN, HYBRD1
C
C Check input parameters
C
      IFAIL = 0
      IF (N.LE.0 .OR. XTOL.LT.ZERO .OR. LWA.LT.(N*(3*N + 13))/2) THEN
         IFAIL = 1
         RETURN
      ENDIF
      TOL = XTOL
      CALL HYBRD1 (FCN, N, X, FVEC, TOL, INFO, WA, LWA)
      IF (INFO.EQ.0) THEN
         IFAIL = 1
      ELSEIF (INFO.EQ.1) THEN
         IFAIL = 0
      ELSE
         IFAIL = INFO
      ENDIF
      END
C
C
