C
C
      SUBROUTINE C05QBF$(FCN, N, X, FVEC, XTOL, IUSER, RUSER, IFAIL)
C
C ACTION : Version of NAG routine C05QBF
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 11/07/2016 
C
      IMPLICIT   NONE
      INTEGER    N, IUSER(*), IFAIL
      INTEGER    INFO
      DOUBLE PRECISION X(N), FVEC(N), XTOL, RUSER(*)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION TOL
      EXTERNAL   FCN, NAG_HYBRD1
C
C Check input parameters
C
      IFAIL = 0
      IF (N.LE.0) THEN
         IFAIL = 11
         RETURN
      ELSEIF (XTOL.LT.ZERO) THEN
         IFAIL = 12
         RETURN   
      ENDIF
      TOL = XTOL
      CALL NAG_HYBRD1 (FCN, N, X, FVEC, TOL, IUSER, RUSER, INFO)
      IF (INFO.EQ.0) THEN
         IFAIL = 1
      ELSEIF (INFO.EQ.1) THEN
         IFAIL = 0
      ELSE
         IFAIL = INFO
      ENDIF
      END
C
C
