C
C
C===========================
C primary routines
C===========================
C     INCLUDE 'DQXGS.FOR'  ... 1
C     INCLUDE 'DQXGSE.FOR' ... 1
C     INCLUDE 'DQXG.FOR'   ... 1 ... not called ?
C     INCLUDE 'DQXGE.FOR'  ... 2 ... not called ?
C     INCLUDE 'DQXLQM.FOR' ... 2
C     INCLUDE 'DQXRUL.FOR' ... 2
C     INCLUDE 'DQXRRD.FOR' ... 2
C     INCLUDE 'DQXCPY.FOR' ... 2
C     INCLUDE 'DQPSRT.FOR' ... 3
C     INCLUDE 'DQELG.FOR'  ... 3
C     INCLUDE 'D1MACH.FOR' ... 3
C===========================
C current sources
C===========================
C     INCLUDE 'D01AJF1.FOR'
C     INCLUDE 'D01AJF2.FOR'
C     INCLUDE 'D01AJF3.FOR'
C===========================
C
C
C
      SUBROUTINE D01AJF$(F, A, B, EPSABS, EPSREL, RESUL, ABSERR, W, LW,
     +                   IW, LIW, IFAIL)
C
C ACTION : Use quadpack as described by Romani et al in
C          ACMTOMS algorithm 691 (17 (1991), 218-232)
C AUTHOR : Editing of the source by W.G.Bardsley, 7/7/97
C
C          Note that the following routines are used but the dimensions
C          are not as the NAG ones. In particular
C          LW >= LIMIT*46
C          LIW >= LIMIT*3
C          where LIMIT = max. no. partitions
C
C*****INCLUDE 'DQXGS.FOR'
C*****INCLUDE 'DQXGSE.FOR'
C*****INCLUDE 'DQXG.FOR'
C*****INCLUDE 'DQXGE.FOR'
C*****INCLUDE 'DQXLQM.FOR'
C*****INCLUDE 'DQXRUL.FOR'
C*****INCLUDE 'DQXRRD.FOR'
C*****INCLUDE 'DQXCPY.FOR'
C*****INCLUDE 'DQPSRT.FOR'
C*****INCLUDE 'DQELG.FOR'
C*****INCLUDE 'D1MACH.FOR'
C
      IMPLICIT   NONE
      INTEGER    IFAIL, LIW, LW, IW(LIW)
      INTEGER    LAST, LIMIT
      DOUBLE PRECISION F, A, B, EPSABS, EPSREL, RESUL, ABSERR, W(LW)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   F, DQXGS
C
C First the NAG test
C
      IFAIL = 0
      ABSERR = ZERO
      RESUL = ZERO
      IF (LW.LT.4 .OR. LIW.LT.LW/8 + 2) THEN
         IFAIL = 6
         RETURN
      ENDIF
C
C Now the stronger test
C
      LIMIT = LW/46
      IF (LIMIT.LT.3 .OR. LIW.LT.3*LIMIT) THEN
         IFAIL = 7
         RETURN
      ENDIF
      CALL DQXGS (F, A, B, EPSABS, EPSREL, RESUL, ABSERR, IFAIL, LIMIT,
     +            LIW, LW, LAST, IW, W)
      IW(1) = LAST
      END
C
C
