C
C
      SUBROUTINE D01EAF$(NDIM, A, B, MINCLS, MAXCLS, NFUN, FUNSUB,
     +                   ABSREQ, RELREQ, LENWRK, WRKSTR, FINEST,
     +                   ABSEST, IFAIL)
C
C Substitute for D01EAF which uses calls to DCUHRE
C by: w.g.bardsley, University of Manchester, U.K, 10/10/2001
C Note: the test for LENWRK is the NAG test but the workspace required
C       by DCUHRE may be larger so additional dimension tests are applied
C       leading to IFAIL = 5, 6, 7
C       In the event of IFAIL > 1 and IFAIL.NE.11
C       then IFAIL is increased to IFAIL + 100 to alert users of error
C       exit values from DCUHRE.
C       The mechansim for setting NUM, MAXPTS and MAXSUB depending on
C       KEY, etc. is described in the prologue to DCHURE and it is not
C       dependent on the value of MAXCLS supplied except for checking.
C
      IMPLICIT   NONE
      INTEGER    NDIM, MINCLS, MAXCLS, NFUN, LENWRK, IFAIL
      INTEGER    M, N, NEVAL, RESTAR
      INTEGER    ICOUNT, KEY, MAXPTS, MAXSUB, NUM, NW
      DOUBLE PRECISION A(NDIM), B(NDIM), ABSREQ, RELREQ,
     +                 WRKSTR(LENWRK), FINEST(NFUN), ABSEST(NFUN)
      DOUBLE PRECISION R
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   DCUHRE, FUNSUB
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
C
C Set IFAIL = 0
C
      IFAIL = 0
C
C Is it safe ?
C
      M = NFUN
      N = NDIM
      IF (M.LT.1 .OR. N.LT.1) THEN
         IFAIL = 4
         RETURN
      ENDIF
      IF (N.LT.11) THEN
         R = 2**N + 2*N*N + 2*N + 1
      ELSE
         R = 1 + N*(4*N*N - 6*N + 14)/3
      ENDIF
      IF (MAXCLS .LT. MINCLS .OR. MAXCLS.LT.R .OR.
     +    ABSREQ.LT.ZERO .OR. RELREQ.LT.ZERO .OR.
     +    LENWRK.LT.(8*NDIM + 11*NFUN + 3)) THEN
          IFAIL = 4
          RETURN
      ENDIF
      IF (MINCLS.GE.0) THEN
C
C First time call so initialise ICOUNT
C
         DO ICOUNT = 1, LENWRK
            WRKSTR(ICOUNT) = ZERO
         ENDDO 
         RESTAR = 0
         ICOUNT = 0  
      ELSE
C
C Trying to improve so increment ICOUNT to increase MAXPTS and MAXSUB
C
         RESTAR = 1
         ICOUNT = ICOUNT + 1
      ENDIF
C
C Set KEY and NUM then MAXPTS, MAXSUB and dimension checks required for DCUHRE
C
      IF (NDIM.EQ.2) THEN
         KEY = 0
         NUM = 65
      ELSEIF (NDIM.EQ.3) THEN
         KEY = 0
         NUM = 127
      ELSE
C
C Toggle next lines for altered precision where KEY = 0 is the default
C and KEY = 4 is for lower precsion, i.e. smaller NUM
C
C********KEY = 4
C********NUM = 1 + 6*NDIM + 2*NDIM*(NDIM - 1) + 2**NDIM
C
         KEY = 0
         NUM = 1 + 8*NDIM + 6*NDIM*(NDIM - 1) + 2**NDIM +
     +         4*NDIM*(NDIM - 1)*(NDIM - 2)/3
      ENDIF
C
C Note that MAXSUB is 2, then 3, 4, ... for re-tries
C
      MAXPTS = (3 + 2*ICOUNT)*NUM
      MAXSUB = (MAXPTS - NUM)/(2*NUM) + 1
      NW = MAXSUB*(2*NDIM + 2*NFUN + 2) + 17*NFUN + 1
      IF (MAXPTS.LT.MINCLS) THEN
         IFAIL = 5
         RETURN
      ELSEIF (MAXPTS.GT.MAXCLS) THEN
         IFAIL = 6
         RETURN
      ENDIF
      IF (NW.GT.LENWRK) THEN
         IFAIL = 7
         RETURN
      ENDIF
C
C Initialise NEVAL which is necessary when RESTAR = 1 then call DCUHRE
C
      NEVAL = 0
      CALL DCUHRE (NDIM, NFUN, A, B, MINCLS, MAXPTS, FUNSUB, ABSREQ,
     +             RELREQ, KEY, LENWRK, RESTAR, FINEST, ABSEST, NEVAL,
     +             IFAIL, WRKSTR)
      IF (IFAIL.EQ.11) THEN
         IFAIL = 2
      ELSEIF (IFAIL.GT.1) THEN
         IFAIL = IFAIL + 100
      ENDIF
C
C Copy NEVAL into MINCLS to return the number of function evaluations
C
      MINCLS = NEVAL
      END
C
C
