C
C
      SUBROUTINE E02ADF$(M, KPLUS1, NROWS, X, Y, W, WORK1, WORK2, A, S,
     +                   IFAIL)
C
C ACTION : Modification of NAG routine E02ADF to fit polynomials
C
      IMPLICIT  NONE
      INTEGER   IFAIL, KPLUS1, M, NROWS
      INTEGER   I, IPLUS1, IPLUS2, J, JPLUS1, JPLUS2, JREV, K, LR1,
     +          MDIST
      DOUBLE PRECISION A(NROWS,KPLUS1), S(KPLUS1), W(M), WORK1(3,M),
     +                 WORK2(2,KPLUS1), X(M), Y(M)
      DOUBLE PRECISION ALPIP1, BETAI, BJ, BJP1, BJP2, CI, D, DF, DI,
     +                 DIM1, DJ, EPSR, FACTOR, PIJ, SIGMAI, WRPR,
     +                 WRPRSQ, X1, XCAPR, XM
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      INTRINSIC SQRT
C
C Check the input data
C
      IFAIL = 0
      IF (KPLUS1.LT.1 .OR. M.LT.KPLUS1) THEN
         IFAIL = 4
         RETURN
      ENDIF
      K = KPLUS1 - 1
      DO I = 1, M
         IF (W(I).LE.ZERO) THEN
            IFAIL = 1
            RETURN
         ENDIF
      ENDDO
      MDIST = 1
      DO I = 2, M
         IF (X(I).LT.X(I - 1)) THEN
            IFAIL = 2
            RETURN
         ELSEIF (X(I).GT.X(I - 1)) THEN
           MDIST = MDIST + 1
         ENDIF
      ENDDO
      IF (MDIST.EQ.1) THEN
         IFAIL = 3
         RETURN
      ENDIF
      IF (MDIST.LE.K) THEN
         IFAIL = 4
         RETURN
      ENDIF
      IF (NROWS.LT.KPLUS1) THEN
         IFAIL = 5
         RETURN
      ENDIF
C
C Proceed ... The data are now consistent for fitting
C
      X1 = X(1)
      XM = X(M)
      D = XM - X1
      DO I = 1, M
         WORK1(1,I) = W(I)*Y(I)
         WORK1(2,I) = ((X(I) - X1) - (XM - X(I)))/D
      ENDDO
C
C The main loop
C
      I = 1
      BETAI = ZERO
      DO IPLUS1 = 1, KPLUS1
         IPLUS2 = IPLUS1 + 1
         IF (IPLUS1.NE.KPLUS1) THEN
            DO JPLUS1 = IPLUS2, KPLUS1
               A(IPLUS1,JPLUS1) = ZERO
            ENDDO
            WORK2(1,IPLUS2) = ZERO
            WORK2(2,IPLUS2) = ZERO
         ENDIF
         ALPIP1 = ZERO
         CI = ZERO
         DI = ZERO
         A(I,IPLUS1) = ZERO
         WORK2(1,IPLUS1) = ONE
         IF (KPLUS1.GT.1) WORK2(2,1) = WORK2(1,2)
         DO LR1 = 1, M
            XCAPR = WORK1(2,LR1)
            IF (IPLUS1.LE.1) THEN
               WRPR = W(LR1)*HALF*WORK2(1,1)
               WORK1(3,LR1) = WRPR
               GOTO 20
            ENDIF
            J = IPLUS2
            IF (XCAPR.LT.- HALF) THEN
               FACTOR = TWO*(ONE + XCAPR)
               DJ = ZERO
               BJ = ZERO
               DO JREV = 1, I
                  J = J - 1
                  DJ = WORK2(1,J) - DJ + FACTOR*BJ
                  BJ = DJ - BJ
               ENDDO
               WRPR = W(LR1)*(HALF*WORK2(1,1) - DJ + HALF*FACTOR*BJ)
               WORK1(3,LR1) = WRPR
               GOTO 20
            ENDIF
            IF (XCAPR.LE.HALF) THEN
               FACTOR = TWO*XCAPR
               BJP1 = ZERO
               BJ = ZERO
               DO JREV = 1, I
                  J = J - 1
                  BJP2 = BJP1
                  BJP1 = BJ
                  BJ = WORK2(1,J) - BJP2 + FACTOR*BJP1
               ENDDO
               WRPR = W(LR1)*(HALF*WORK2(1,1) - BJP1 + HALF*FACTOR*BJ)
               WORK1(3,LR1) = WRPR
               GOTO 20
            ENDIF
            FACTOR = TWO*(ONE - XCAPR)
            DJ = ZERO
            BJ = ZERO
            DO JREV = 1, I
               J = J - 1
               DJ = WORK2(1,J) + DJ - FACTOR*BJ
               BJ = BJ + DJ
            ENDDO
            WRPR = W(LR1)*(HALF*WORK2(1,1) + DJ - HALF*FACTOR*BJ)
            WORK1(3,LR1) = WRPR
   20       CONTINUE
            WRPRSQ = WRPR**2
            DI = DI + WRPRSQ
            CI = CI + WRPR*WORK1(1,LR1)
            ALPIP1 = ALPIP1 + WRPRSQ*XCAPR
         ENDDO
         CI = CI/DI
         IF (IPLUS1.NE.1) BETAI = DI/DIM1
         ALPIP1 = TWO*ALPIP1/DI
         SIGMAI = ZERO
         DO LR1 = 1, M
            EPSR = WORK1(1,LR1) - CI*WORK1(3,LR1)
            WORK1(1,LR1) = EPSR
            SIGMAI = SIGMAI + EPSR**2
         ENDDO
         IF (IPLUS1.GE.M) THEN
            S(IPLUS1) = ZERO
         ELSE
            DF = M - IPLUS1
            S(IPLUS1) = SQRT(SIGMAI/DF)
         ENDIF
         DO JPLUS1 = 1, IPLUS1
            JPLUS2 = JPLUS1 + 1
            PIJ = WORK2(1,JPLUS1)
            A(IPLUS1,JPLUS1) = A(I,JPLUS1) + CI*PIJ
            IF (JPLUS2.GT.KPLUS1) GOTO 40
            WORK2(1,JPLUS1) = WORK2(1,JPLUS2) + WORK2(2,JPLUS1) -
     *                        ALPIP1*PIJ - BETAI*WORK2(2,JPLUS2)
            WORK2(2,JPLUS2) = PIJ
         ENDDO
         DIM1 = DI
         I = IPLUS1
      ENDDO
   40 CONTINUE
      END
C
C
