C
C
      SUBROUTINE E02AKF$(NP1, XMIN, XMAX, A, IA1, LA, X, RESUL, IFAIL)
C
C ACTION : Evaluate a polynomial like the NAG routine E02AKF
C
      IMPLICIT NONE
      INTEGER  IA1, IFAIL, LA, NP1
      INTEGER  J, JREV, N
      DOUBLE PRECISION A(LA), RESUL, X, XMAX, XMIN
      DOUBLE PRECISION XCAP
      DOUBLE PRECISION AJ, BJ, CJ, FACTOR, SUM1
      DOUBLE PRECISION ZERO, HALF, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, TWO = 2.0D+00)
C
C Check input data
C
      IFAIL = 0
      IF (NP1.LT.1 .OR.
     +    IA1.LT.1 .OR.
     +    LA.LT.1 + (NP1 - 1)*IA1 .OR.
     +    XMIN.GE.XMAX) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (X.GT.XMAX .OR. X.LT.XMIN) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Calculate XCAP
C
      XCAP = ((X - XMIN) - (XMAX - X))/(XMAX - XMIN)
C
C Evaluate
C
      IF (NP1.LE.1) THEN
         SUM1 = HALF*A(1)
         GOTO 60
      ENDIF
      N = NP1 - 1
      AJ = ZERO
      BJ = ZERO
      J = 1 + NP1*IA1
      IF (XCAP.GT.HALF) GOTO 40
      IF (XCAP.GE.- HALF) GOTO 20
      FACTOR = TWO + (XCAP + XCAP)
      DO JREV = 1, N
         J = J - IA1
         AJ = A(J) - AJ + BJ*FACTOR
         BJ = AJ - BJ
      ENDDO
      SUM1 = HALF*A(1) - AJ + HALF*FACTOR*BJ
      GOTO 60
   20 CONTINUE
      FACTOR = XCAP + XCAP
      DO JREV = 1, N
         J = J - IA1
         CJ = BJ
         BJ = AJ
         AJ = A(J) - CJ + BJ*FACTOR
      ENDDO
      SUM1 = HALF*A(1) - BJ + HALF*FACTOR*AJ
      GOTO 60
   40 CONTINUE
      FACTOR = TWO - (XCAP + XCAP)
      DO JREV = 1, N
         J = J - IA1
         AJ = A(J) + AJ - BJ*FACTOR
         BJ = AJ + BJ
      ENDDO
      SUM1 = HALF*A(1) + AJ - HALF*FACTOR*BJ
   60 CONTINUE
      RESUL = SUM1
      END
C
C
