C
C
      SUBROUTINE E02BAF$(M, NCAP7, X, Y, W, K, WORK1, WORK2, C, SS,
     +                  IFAIL)
C
C ACTION : Fit wtd. least squares splines like nag routine e02baf
C
      IMPLICIT NONE
      INTEGER  IFAIL, M, NCAP7
      INTEGER  I, IPLUSJ, IU, J, JOLD, JPLUSL, JREV, L,
     +         L4, LPLUS1, LPLUSU, NCAP, NCAP3, NCAPM1, NR
      DOUBLE PRECISION SS
      DOUBLE PRECISION C(NCAP7), K(NCAP7), W(M), WORK1(M),
     +                 WORK2(4,NCAP7), X(M), Y(M)
      DOUBLE PRECISION ACOL, AROW, CCOL, COSINE, CROW, D, D4, D5, D6,
     +                 D7, D8, D9, DPRIME, E2, E3, E4, E5, K0, K1, K2,
     +                 K3, K4, K5, K6, N1, N2, N3, RELEMT, S, SIGMA,
     +                 SINE, WI, XI
      DOUBLE PRECISION RTOL, X02AMF$
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   X02AMF$
      INTRINSIC  ABS, SQRT
C
C Set IFAIL = 0 then test for sufficient distinct data points
C
      IFAIL = 0
      IF (NCAP7.LT.8 .OR. M.LT.NCAP7 - 4) THEN
         IFAIL = 4
         RETURN
      ENDIF
C
C Define NCAP, NCAPM1, NCAP3, K(J)
C
      NCAP = NCAP7 - 7
      NCAPM1 = NCAP - 1
      NCAP3 = NCAP + 3
      DO J = 1, 4
         I = NCAP3 + J
         K(J) = X(1)
         K(I) = X(M)
      ENDDO
C
C Are the knots in increasing order and interior to the data
C
      IF (K(5).LE.X(1) .OR. K(NCAP3).GE.X(M)) THEN
         IFAIL = 1
         RETURN
      ENDIF
      DO J = 4, NCAP3
         IF (K(J).GT.K(J + 1)) THEN
            IFAIL = 1
            RETURN
         ENDIF
      ENDDO
C
C Are the weights positive
C
      DO I = 1, M
         IF (W(I).LE.ZERO) THEN
            IFAIL = 2
            RETURN
         ENDIF
      ENDDO
C
C Are the data in increasing order
C
      WORK1(1) = X(1)
      J = 2
      DO I = 2, M
         IF (X(I).LT.WORK1(J - 1)) THEN
            IFAIL = 3
            RETURN
         ELSEIF (X(I).GT.WORK1(J - 1)) THEN
            WORK1(J) = X(I)
            J = J + 1
         ENDIF
      ENDDO
C
C Are there sufficient data values for the knots to give a unique solution
C
      NR = J - 1
      IF (NR.LT.NCAP3) THEN
         IFAIL = 4
         RETURN
      ENDIF
      DO J = 1, 4
         IF (J.GE.NCAP) GOTO 40
         I = NCAP3 - J + 1
         L = NR - J + 1
         IF (WORK1(J).GE.K(J + 4) .OR. K(I).GE.WORK1(L)) THEN
            IFAIL = 5
            RETURN
         ENDIF
      ENDDO
      IF (NCAP.LE.5) GO TO 40
      NR = NR - 4
      I = 4
      DO J = 5, NCAPM1
         K0 = K(J + 4)
         K4 = K(J)
   20    CONTINUE
         I = I + 1
         IF (WORK1(I).LE.K4) GOTO 20
         IF (I.GT.NR .OR. WORK1(I).GE.K0) THEN
            IFAIL = 5
            RETURN
         ENDIF
      ENDDO
   40 CONTINUE
      DO I = 1, NCAP3
         DO L = 1, 4
            WORK2(L,I) = ZERO
         ENDDO
         C(I) = ZERO
      ENDDO
C
C The main loop
C
      RTOL = 1.0D+09*X02AMF$()
      SIGMA = ZERO
      J = 0
      JOLD = 0
      DO I = 1, M
         WI = W(I)
         XI = X(I)
   60    CONTINUE
         IF (XI.LT.K(J + 4) .OR. J.GT.NCAPM1) GOTO 80
            J = J + 1
            GOTO 60
   80    CONTINUE
         IF (J.NE.JOLD) THEN
            K1 = K(J + 1)
            K2 = K(J + 2)
            K3 = K(J + 3)
            K4 = K(J + 4)
            K5 = K(J + 5)
            K6 = K(J + 6)
            D4 = ONE/(K4 - K1)
            D5 = ONE/(K5 - K2)
            D6 = ONE/(K6 - K3)
            D7 = ONE/(K4 - K2)
            D8 = ONE/(K5 - K3)
            D9 = ONE/(K4 - K3)
            JOLD = J
         ENDIF
         E5 = K5 - XI
         E4 = K4 - XI
         E3 = XI - K3
         E2 = XI - K2
         N1 = WI*D9
         N2 = E3*N1*D8
         N1 = E4*N1*D7
         N3 = E3*N2*D6
         N2 = (E2*N1+E5*N2)*D5
         N1 = E4*N1*D4
         WORK1(4) = E3*N3
         WORK1(3) = E2*N2 + (K6 - XI)*N3
         WORK1(2) = (XI - K1)*N1 + E5*N2
         WORK1(1) = E4*N1
         CROW = Y(I)*WI
         DO LPLUS1 = 1, 4
            L = LPLUS1 - 1
            RELEMT = WORK1(LPLUS1)
            IF (ABS(RELEMT - ZERO).GE.RTOL) THEN
               JPLUSL = J + L
               L4 = 4 - L
               D = WORK2(1,JPLUSL)
               IF (ABS(RELEMT).GE.D) DPRIME = ABS(RELEMT)
     +             *SQRT(ONE + (D/RELEMT)**2)
               IF (ABS(RELEMT).LT.D) DPRIME = D*SQRT(ONE+(RELEMT/D)**2)
               WORK2(1,JPLUSL) = DPRIME
               COSINE = D/DPRIME
               SINE = RELEMT/DPRIME
               IF (L4.GE.2) THEN
                  DO IU = 2, L4
                     LPLUSU = L + IU
                     ACOL = WORK2(IU,JPLUSL)
                     AROW = WORK1(LPLUSU)
                     WORK2(IU,JPLUSL) = COSINE*ACOL + SINE*AROW
                     WORK1(LPLUSU) = COSINE*AROW - SINE*ACOL
                  ENDDO
               ENDIF
               CCOL = C(JPLUSL)
               C(JPLUSL) = COSINE*CCOL + SINE*CROW
               CROW = COSINE*CROW - SINE*CCOL
            ENDIF
         ENDDO
         SIGMA = SIGMA + CROW**2
      ENDDO
      SS = SIGMA
      L = - 1
      DO JREV = 1, NCAP3
         J = NCAP3 - JREV + 1
         D = WORK2(1,J)
         IF (ABS(D).LE.RTOL) THEN
            IFAIL = 5
            RETURN
         ENDIF
         IF (L.LT.3) L = L + 1
         S = C(J)
         IF (L.NE.0) THEN
            DO I = 1, L
               IPLUSJ = I + J
               S = S - WORK2(I + 1,J)*C(IPLUSJ)
            ENDDO
         ENDIF
         C(J) = S/D
      ENDDO
      END
C
C
