C
C
      SUBROUTINE E02BCF$(NCAP7, K, C, X, LEFT, S, IFAIL)
C
C ACTION : Evaluate spline like nag e02bcf
C
      IMPLICIT NONE
      INTEGER  IFAIL, LEFT, NCAP7
      INTEGER  J, J1, L
      DOUBLE PRECISION X
      DOUBLE PRECISION C(NCAP7), K(NCAP7), S(4)
      DOUBLE PRECISION C1, C2, C3, C4, D1N41, D1N42, D1N43, D1N44,
     +                 D2N41, D2N42, D2N43, D2N44, D3N41, D3N42, D3N43,
     +                 D3N44, E2, E3, E4, E5, K1, K2, K3, K4, K5,
     +                 K6, M11, M21, M22, M32, N41, N42, N43, N44, P4,
     +                 P5, P6
      DOUBLE PRECISION HALF, THREE, SIX
      PARAMETER (HALF = 0.5D+00, THREE = 3.0D+00, SIX = 6.0D+00)
      IFAIL = 0
      IF (NCAP7.LT.8) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (K(4).GE.K(NCAP7 - 3)) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (X.LT.K(4) .OR. X.GT.K(NCAP7 - 3)) THEN
         IFAIL = 2
         RETURN
      ENDIF
      J1 = 4
      J = NCAP7 - 3
   20 CONTINUE
      L = (J1 + J)/2
      IF (J - J1.GT.1) THEN
         IF (LEFT.NE.1 .AND. X.GE.K(L) .OR.
     +       LEFT.EQ.1 .AND. X.GT.K(L)) THEN
            J1 = L
            GOTO 20
         ELSE
            J = L
            GOTO 20
         ENDIF
      ENDIF
      J = J - 4
      K1 = K(J + 1)
      K2 = K(J + 2)
      K3 = K(J + 3)
      K4 = K(J + 4)
      K5 = K(J + 5)
      K6 = K(J + 6)
      E2 = X - K2
      E3 = X - K3
      E4 = K4 - X
      E5 = K5 - X
      P4 = K4 - K1
      P5 = K5 - K2
      P6 = K6 - K3
      M11 = SIX/(K4 - K3)
      M21 = - M11/(K4 - K2)
      M22 = M11/(K5 - K3)
      D3N41 = M21/P4
      M32 = (M21 - M22)/P5
      D3N44 = M22/P6
      D3N42 = - D3N41 - M32
      D3N43 = M32 - D3N44
      M21 = - E4*M21
      M22 = E3*M22
      D2N41 = M21/P4
      M32 = (M21 - M22)/P5
      D2N44 = M22/P6
      D2N42 = - D2N41 - M32
      D2N43 = M32 - D2N44
      M21 = HALF*M21
      M22 = HALF*M22
      D1N41 = - E4*M21/P4
      M32 = (E2*M21 + E5*M22)/P5
      D1N44 = E3*M22/P6
      D1N42 = - D1N41 - M32
      D1N43 = M32 - D1N44
      N41 = - E4*D1N41/THREE
      N42 = (- (X - K1)*D1N41 + E5*M32)/THREE
      N43 = (E2*M32 + (K6 - X)*D1N44)/THREE
      N44 = E3*D1N44/THREE
      C1 = C(J)
      C2 = C(J + 1)
      C3 = C(J + 2)
      C4 = C(J + 3)
      S(1) = C1*N41 + C2*N42 + C3*N43 + C4*N44
      S(2) = C1*D1N41 + C2*D1N42 + C3*D1N43 + C4*D1N44
      S(3) = C1*D2N41 + C2*D2N42 + C3*D2N43 + C4*D2N44
      S(4) = C1*D3N41 + C2*D3N42 + C3*D3N43 + C4*D3N44
      END
C
C
