C
C
      SUBROUTINE E02GBF$(M, N, MPL, E, IE, F, X, MXS, MONIT, IPRINT,
     +                   K, EL1IN, INDX, W, IW, IFAIL)
C
C ACTION : Overdetermined L1 with constraints using ACMTOMS 563 = CL1
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 20/9/97
C          This version does not use IPRINT and MONIT is not called
C          at all whatever the value of IPRINT. This could be altered
C          by linking IPRINT and PSW
C          Note that the workspace is partitioned to be used to hold
C          RESID (the residuals) from CL1, so make sure LIW is large
C          enough to hold residuals on top of the workspace for CL1
C          Precision is set as EPSI and BIG in the various CL1 codes
C          EPSI is set at 1.0D-10 but NAG is set at machine precision
C          so decrease EPSI in the subroutines if required.
C
      IMPLICIT NONE
C
C NAG arguments
C
      INTEGER    M, N, MPL, IE, MXS, IPRINT, K, INDX(MPL), IW, IFAIL
      DOUBLE PRECISION E(IE,MPL), F(MPL), X(N), EL1IN, W(IW)
C
C CL1 arguments
C
      INTEGER    NEQNS, NEQC, NIQC, NVARS, NACT, IFL, MXS1, NER
      INTEGER    NSTART
      INTEGER    NITER
      INTEGER    MXSMIN
      PARAMETER (MXSMIN = 50)
      LOGICAL    PSW
      PARAMETER (PSW = .FALSE.)
      EXTERNAL   CL1
      EXTERNAL   MONIT
      INTRINSIC  MAX
C
C Assign CL1 parameters and define NSTART
C
      NEQNS = M
      NEQC = 0
      NIQC = MPL - M
      NVARS = N
      NSTART = (3*NVARS*NVARS + 11*NVARS + 2)/2 +
     +          2*(NEQNS + NEQC + NIQC) + 1
C
C Check the input data
C
      IFAIL = 0
      IF (N.LT.2 .OR.
     +    M.LT.N .OR.
     +    MPL.LT.M .OR.
     +    IW.LT.(3*MPL + 5*N + N*N + (N + 1)*(N + 2)/2) .OR.
     +    IW.LT.(NSTART + M) .OR.
     +    IE.LT.N) THEN
         IFAIL = 4
         RETURN
      ENDIF
C
C All is well so proceed to call CL1
C
      MXS1 = MAX(MXSMIN, MXS)
      NER = IE
      CALL CL1 (NEQNS, NEQC, NIQC, NVARS, NACT, IFL, MXS1, PSW, E, NER,
     +          X, F, EL1IN, W(NSTART), INDX, W(1))
      IFAIL = IFL - 1
      IF (IFAIL.GE.0 .OR. IPRINT.LE.0) RETURN
      NITER = 1
      CALL MONIT (N, X, NITER, K, EL1IN)
      END
C
C
