C
C
      SUBROUTINE F01ABF$(A, IA, N, B, IB, Z, IFAIL)
C
C ACTION : Accurate inverse of a pos def matrix
C AUTHOR : W.G.Bardsley, University of Manchester, 14/7/97
C          Using BLAS/LAPACK
C
      IMPLICIT   NONE
      INTEGER    IA, IB, IFAIL, N
      INTEGER    I, J
      DOUBLE PRECISION A(IA,*), B(IB,*), Z(*)
      CHARACTER  UPLO*1
      PARAMETER (UPLO = 'U')
      EXTERNAL   DPOTRF, DPOTRI
      Z(1) = 1.0D+00!to silence ftn95
C
C Copy upper triangle of A into B
C
      DO I = 1, N
         DO J = I, N
            B(I,J) = A(I,J)
         ENDDO
      ENDDO
C
C Calculations
C
      CALL DPOTRF (UPLO, N, B, IB, IFAIL)
      IF (IFAIL.NE.0) RETURN
      CALL DPOTRI (UPLO, N, B, IB, IFAIL)
      IF (IFAIL.LT.0) THEN
         IFAIL = IFAIL - 1000
      ELSEIF (IFAIL.GT.0) THEN
         IFAIL = IFAIL + 1000
      ENDIF
C
C Fill in lower triangle of B
C
      DO I = 2, N
         DO J = 1, I - 1
            B(I,J) = B(J,I)
         ENDDO
      ENDDO
C
C Fill in the displaced lower triangle of A
C
      DO I = 1, N
         DO J = 1, I
            A(I + 1,J) = B(I,J)
         ENDDO
      ENDDO
      END
C
C
