C
C
      SUBROUTINE F01ACF$(N, EPS, A, IA, B, IB, Z, L, IFAIL)
C
C ACTION: Version of F01ACF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 24/06/2001
C
      IMPLICIT   NONE
      INTEGER    IA, IB, IFAIL, L, N
      INTEGER    I, IFAIL1, J, J1
      DOUBLE PRECISION EPS
      DOUBLE PRECISION A(IA,*), B(IB,*), Z(*)
      DOUBLE PRECISION C, C1, C2, D, D1, D2, E, XMAX, ZMAX
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   F01ADF$, X03AAF$
      INTRINSIC  ABS
      E = ONE
      L = 0
      IFAIL = 1
      CALL F01ADF$(N, A, IA, IFAIL)
      IF (IFAIL.NE.0) RETURN
      IFAIL = 1
      IFAIL1 = 0
   20 CONTINUE
      DO I = 1, N
         DO J = 1, N
            J1 = J + 1
            C1 = ZERO
            IF (J.LT.I) GOTO 40
            IF (I.EQ.J) C1 = -ONE
            CALL X03AAF$(A(1,I),(N-I+1)*IA,A(J1,1),N*IA-J1+1,I,1,IA,C1,
     *                   ZERO,D1,D2,.TRUE.,IFAIL1)
            IF (I.EQ.N) GOTO 60
            C1 = D1
            C2 = D2
            CALL X03AAF$(A(I,I+1),(N-I)*IA-I+1,A(J1,I+1),(N-I)*IA-J1+1,
     *                   J-I,IA,IA,C1,C2,D1,D2,.TRUE.,IFAIL1)
            IF (J1.GT.N) GOTO 60
            C1 = D1
            C2 = D2
            CALL X03AAF$(A(I,J1),(N-J)*IA-I+1,A(J1+1,J),(N-J+1)*IA-J1,
     *                   N-J,IA,1,C1,C2,D1,D2,.TRUE.,IFAIL1)
            GOTO 60
   40       CALL X03AAF$(A(1,I),(N-I+1)*IA,A(J1,1),N*IA-J1+1,J,1,IA,C1,
     *                   ZERO,D1,D2,.TRUE.,IFAIL1)
            C1 = D1
            C2 = D2
            CALL X03AAF$(A(J1,I),(N-I+1)*IA-J1+1,A(J1+1,J),
     *                   (N-J+1)*IA-J1,
     *                   I-J1+1,1,1,C1,C2,D1,D2,.TRUE.,IFAIL1)
            IF (I.EQ.N) GOTO 60
            C1 = D1
            C2 = D2
            CALL X03AAF$(A(I,I+1),(N-I)*IA-I+1,A(I+2,J),(N-J+1)*IA-I-1,
     *                   N-I,IA,1,C1,C2,D1,D2,.TRUE.,IFAIL1)
   60       B(I,J) = -D1
         ENDDO
      ENDDO
      XMAX = ZERO
      ZMAX = ZERO
      DO I = 1, N
         DO J = 1, I
            CALL X03AAF$(A(I+1,1),N*IA-I,B(1,J),(N-J+1)*IB,I,IA,1,ZERO,
     *                   ZERO,D1,D2,.TRUE.,IFAIL1)
            IF (I.EQ.N) GOTO 80
            C1 = D1
            C2 = D2
            CALL X03AAF$(A(I+2,I),(N-I+1)*IA-I-1,B(I+1,J),(N-J+1)*IB-I,
     *                  N-I,1,1,C1,C2,D1,D2,.TRUE.,IFAIL1)
   80       Z(J) = D1
         ENDDO
         DO J = 1, I
            C = ABS(A(I+1,J))
            D = ABS(Z(J))
            IF (C.GT.XMAX) XMAX = C
            IF (D.GT.ZMAX) ZMAX = D
            A(I+1,J) = A(I+1,J) + Z(J)
         ENDDO
      ENDDO
      L = L + 1
      D = ZMAX/XMAX
      IF (D.GT.E/2.0D+00) RETURN
      E = D
      IF (D.GT.2.0D+00*EPS) GOTO 20
      IFAIL = 0
      END
C
C
