C
C
      SUBROUTINE F02AAF$(A, IA, N, R, E, IFAIL)
C
C ACTION : Eigenvalues of a symmetric matrix
C AUTHOR : W.G.Bardsley, University of Manchester, 16/7/97
C          14/01/2006 introduced local allocatable workspace
C          Note: maximum domension set by LWORK not N as in NAG version
C          Using BLAS/LAPACK
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IA, IFAIL, N
      DOUBLE PRECISION A(IA,*), R(*), E(*)
C
C Locals
C
      INTEGER    IERR, LWORK, NB
      PARAMETER (NB = 64)
      DOUBLE PRECISION, ALLOCATABLE :: WORK(:)
      CHARACTER  JOBZ*1, UPLO*1
      PARAMETER (JOBZ = 'N', UPLO = 'L')
      EXTERNAL   DSYEV
      INTRINSIC  MAX
C
C Allocate workspace
C
      IERR = 0
      E(1) = 1.0D+00!to silence ftn95
      LWORK = MAX(3*N - 1, N*(NB + 2)) + 1
      IF (ALLOCATED(WORK)) DEALLOCATE(WORK, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      ALLOCATE(WORK(LWORK), STAT = IERR)
      IF (IERR.NE.0) RETURN  

C
C Calculations
C
      CALL DSYEV (JOBZ, UPLO, N, A, IA, R, WORK, LWORK, IFAIL)
      DEALLOCATE(WORK, STAT = IERR)
      END
C
C
