C
C
      SUBROUTINE F02AFF$(A, IA, N, RR, RI, INTGER, IFAIL)
C
C ACTION : Eigenvalues of a nonsymmetric matrix
C AUTHOR : W.G.Bardsley, University of Manchester, 20/7/97
C          14/01/2006 introduced allocatable work space
C          Note: maximum dimension set by LWORK not N as in NAG version
C          INTGER is not used
C          Using BLAS/LAPACK
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IA, IFAIL, N
      INTEGER    INTGER(*)
      DOUBLE PRECISION A(IA,*), RR(*), RI(*)
C
C Locals
C
      INTEGER    NB, N1
      PARAMETER (NB = 64, N1 = 1)
      INTEGER    IERR, LWORK, LDVL, LDVR
      PARAMETER (LDVL = 1, LDVR = 1)
      DOUBLE PRECISION, ALLOCATABLE :: WORK(:)
      DOUBLE PRECISION VL(LDVL,N1), VR(LDVR,N1)
      CHARACTER  JOBVL*1, JOBVR*1
      PARAMETER (JOBVL = 'N', JOBVR = 'N')
      EXTERNAL   DGEEV
      INTGER(1) = 1!to silence ftn95
      LWORK = NB*N
      IERR = 0
      IF (ALLOCATED(WORK)) DEALLOCATE(WORK, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      ALLOCATE(WORK(LWORK), STAT = IERR)
      IF (IERR.NE.0) RETURN  
C
C Calculations
C
      CALL DGEEV (JOBVL, JOBVR, N, A, IA, RR, RI, VL, LDVL, VR, LDVR,
     +            WORK, LWORK, IFAIL)
      DEALLOCATE (WORK, STAT = IERR)
      END
C
C
