C
C
      SUBROUTINE F02EBF$(JOB, N, A, LDA, WR, WI, VR, LDVR, VI, LDVI,
     +                   WORK, LWORK, IFAIL)
C
C Action: substitute for F02EBF
C Author: W.G.Bardsley, University of Manchester, U.K., 01/03/2005
C
      IMPLICIT NONE
C
C Arguments
C
      INTEGER  N, LDA, LDVR, LDVI, LWORK, IFAIL
      DOUBLE PRECISION A(LDA,*), WR(*), WI(*), VR(LDVR,*), VI(LDVI,*),
     +                 WORK(LWORK)
C
C Locals
C
      INTEGER    I, J
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  JOB*1
      CHARACTER  JOBVL*1, JOBVR*1
      PARAMETER (JOBVL = 'N')
      INTRINSIC  ABS, MAX
      EXTERNAL   DGEEV
C
C Is it safe ?
C
      IF (JOB.EQ.'N' .OR. JOB.EQ.'n') THEN
         JOBVR = 'N'
      ELSEIF (JOB.EQ.'V' .OR. JOB.EQ.'v') THEN
         JOBVR = 'V'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (N.LT.0 .OR.
     +   LDA.LT.MAX(1,N) .OR.
     +   LDVR.LT.1 .OR. (LDVR.LT.N .AND. JOBVR.EQ.'V') .OR.
     +   LDVI.LT.1 .OR. (LDVI.LT.N .AND. JOBVR.EQ.'V') .OR.
     +   LWORK.LT.MAX(1,4*N)) THEN
         IFAIL = 1
         RETURN
      ENDIF
      CALL DGEEV (JOBVL, JOBVR, N, A, LDA, WR, WI, VI, LDVI, VR,
     +            LDVR, WORK, LWORK, IFAIL)
      IF (IFAIL.NE.0) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Manipulate the eigenvectors to agree with F02EBF
C
      J = 1
      DO WHILE(J.LE.N)
         IF (ABS(WI(J)).GT.ZERO) THEN
C
C Complex conjugate pair so manipulate two columns
C
            DO I = 1, N
               VI(I,J) = VR(I,J + 1)
               VI(I,J + 1) = - VI(I,J)
           ENDDO
           DO I = 1, N
              VR(I,J + 1) = VR(I,J)
            ENDDO
C
C Increment J to allow for two columns being transformed
C
            J = J + 1
         ELSE
C
C Real so just maniplulate one column
C
            DO I = 1, N
               VI(I,J) = ZERO
            ENDDO
         ENDIF
C
C Increment J for next eigenvalue
C
         J = J + 1
      ENDDO
      END
C
C

