C
C
      SUBROUTINE F03AEF$(N, A, IA, P, D1, ID, IFAIL)
C
C ACTION: version of F03AEF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 01/07/2001
C         Note: the IFAIL mechanism is not the same as the NAG one
C
      IMPLICIT   NONE
      INTEGER    IA, ID, IFAIL, N
      INTEGER    I, J
      DOUBLE PRECISION D1
      DOUBLE PRECISION A(IA,*), P(*)
      DOUBLE PRECISION X
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   DGEMV
      INTRINSIC  ABS, SQRT, MAX
C
C Is it safe ?
C
      IFAIL = 0
      IF (N.LT.0 .OR. IA.LT.MAX(1,N)) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Copy upper triangle and diagonal
C
      DO J = 1, N
         DO I = 1, J
            A(J,I) = A(I,J)
         ENDDO
         P(J) = A(J,J)
      ENDDO
      D1 = ONE
      ID = 0
      DO I = 1, N
         X = A(I,I)
         D1 = D1*X
         IF (X.LE.ZERO) THEN
C
C Not positive definite so abort with IFAIL = 1
C
            IFAIL = 1
            D1 = ZERO
            ID = 0
            DO J = I, N
               A(J,J) = P(J)
            ENDDO
            RETURN
         ENDIF
   20    CONTINUE
         IF (ABS(D1).LT.ONE) GOTO 40
         D1 = D1*0.0625D+00
         ID = ID + 4
         GOTO 20
   40    CONTINUE
         IF (ABS(D1).GE.0.0625D+00) GOTO 60
         D1 = D1*16.0D+00
         ID = ID - 4
         GOTO 40
   60    CONTINUE
         X = ONE/SQRT(X)
         A(I,I) = P(I)
         P(I) = X
         IF (I.LT.N) THEN
            DO J = I + 1, N
               A(J,I) = A(J,I)*X
            ENDDO
            CALL DGEMV ('N', N-I, I, -ONE, A(I+1,1), IA, A(I+1,1), IA,
     +                  ONE, A(I+1,I+1), 1)
         ENDIF
      ENDDO
      IFAIL = 0
      END
C
C
