C
C
      SUBROUTINE F03AFF$(N, EPS, A, IA, D1, ID, P, IFAIL)
C
C ACTION : Determinant
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 20/7/97
C          Uses BLAS
C
      IMPLICIT   NONE
      INTEGER    IA, ID, IFAIL, N
      INTEGER    I, J, K, L
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      DOUBLE PRECISION D1, EPS
      DOUBLE PRECISION A(IA,*), P(*)
      DOUBLE PRECISION X, Y, Z
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   DGEMV, DTRSV
      INTRINSIC  ABS, SQRT, MAX
C
C Initialise
C
      D1 = ONE
      ID = N0
      IFAIL = N1
C
C Check
C
      IF (N.LT.N0 .OR. IA.LT.MAX(N1,N)) THEN
         IFAIL = N2
         RETURN
      ENDIF
C
C Empty P
C
      DO I = N1, N
         P(I) = ZERO
      ENDDO
C
C Calculate P
C
      DO J = N1, N
         DO I = N1, N
            P(I) = P(I) + A(I,J)**2
         ENDDO
      ENDDO
C
C Check/Transform P
C
      DO I = N1, N
         IF (P(I).LE.ZERO) RETURN
         Z = SQRT(P(I))
         IF (Z.LT.1.0D-300) THEN
            RETURN
         ELSE
            P(I) = ONE/Z
         ENDIF
      ENDDO
C
C The main loop
C
      D1 = ONE
      ID = N0
      DO K = N1, N
         L = K
         X = ZERO
         DO I = K, N
            Y = ABS(A(I,K)*P(I))
            IF (Y.GT.X) THEN
               X = Y
               L = I
            ENDIF
         ENDDO
         IF (L.NE.K) THEN
            D1 = - D1
            DO J = N1, N
               Y = A(K,J)
               A(K,J) = A(L,J)
               A(L,J) = Y
            ENDDO
            P(L) = P(K)
         ENDIF
         P(K) = L
         D1 = D1*A(K,K)
         IF (X.LT.8.0*EPS) RETURN

         DO WHILE (ABS(D1).GE.ONE)
            D1 = D1*0.0625
            ID = ID + 4
         ENDDO

         DO WHILE (ABS(D1).LT.0.0625)
            D1 = D1*16.0
            ID = ID - 4
         ENDDO

         IF (K.LT.N) THEN
            CALL DTRSV ('L', 'N', 'N', K, A, IA, A(1,K+1), N1)
            CALL DGEMV ('N', N-K, K, -ONE, A(K+1,1), IA, A(1,K+1), N1,
     +                  ONE, A(K+1,K+1), N1)
         ENDIF
      ENDDO
      IFAIL = N0
      END
C
C
