C
C
      SUBROUTINE F04AFF$(N, IR, A, IA, P, B, IB, EPS, X, IX, BB, IBB,
     +                   L, IFAIL)
C
C ACTION: version of F04AFF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 01/07/2001
C
      IMPLICIT  NONE
      DOUBLE    PRECISION EPS
      INTEGER   IA, IB, IBB, IFAIL, IR, IX, L, N
      DOUBLE PRECISION A(IA,*), B(IB,*), BB(IBB,*), P(*), X(IX,*)
      DOUBLE PRECISION BBMAX, D0, D1, D11, D2, XMAX
      DOUBLE PRECISION ZERO, HALF, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, TWO = 2.0D+00)
      INTEGER    I, ID2, IFAIL1, J
      EXTERNAL   F04AGF$, X03AAF$
      INTRINSIC  ABS
      IFAIL = 0
      DO J = 1, IR
         DO I = 1, N
            X(I,J) = ZERO
            BB(I,J) = B(I,J)
         ENDDO
      ENDDO
      L = 0
      D0 = ZERO
   20 CONTINUE
      CALL F04AGF$(N, IR, A, IA, P, BB, IBB, BB, IBB)
      L = L + 1
      ID2 = 0
      D1 = ZERO
      DO J = 1, IR
         DO I = 1, N
            X(I,J) = X(I,J) + BB(I,J)
         ENDDO
      ENDDO
      IFAIL1 = 0
      DO J = 1, IR
         BBMAX = ZERO
         XMAX = ZERO
         DO I = 1, N
            IF (ABS(X(I,J)).GT.XMAX) XMAX = ABS(X(I,J))
            IF (ABS(BB(I,J)).GT.BBMAX) BBMAX = ABS(BB(I,J))
            CALL X03AAF$(A(1,I), (N-I+1)*IA, X(1,J), (IR-J+1)*IX, I-1,
     +                   1, 1,
     +                   -B(I,J), ZERO, D11, D2, .TRUE., IFAIL1)
            CALL X03AAF$(A(I,I), (N-I+1)*IA-I+1, X(I,J),
     +                   (IR-J+1)*IX-I+1,
     +                   N-I+1, IA, 1, D11, D2, D11, D2, .TRUE., IFAIL1)
            BB(I,J) = -D11
         ENDDO
         IF (BBMAX.GT.D1*XMAX) D1 = BBMAX/XMAX
         IF (BBMAX.GT.TWO*EPS*XMAX) ID2 = 1
      ENDDO
      IF (D1.GT.D0*HALF .AND. L.NE.1) THEN
         IFAIL = 1
         RETURN
      ENDIF
      D0 = D1
      IF (ID2.EQ.1) GOTO 20
      END
C
C
