C
C
      SUBROUTINE FZ1CLF$(A, B, C, L, M, N, IFAIL)
C
C ACTION : Set A equal to B times C transpose (c.f. NAG routine F01CLF)
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          This code was originally part of POLNOM
C
      IMPLICIT   NONE
      INTEGER    IFAIL, L, M, N
      INTEGER    I, J, K
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      DOUBLE PRECISION A(L,M), B(L,N), C(M,N)
      DOUBLE PRECISION SUM1
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DO I = N1, L
         DO J = N1, M
            SUM1 = ZERO
            DO K = N1, N
               SUM1 = SUM1 + B(I,K)*C(J,K)
            ENDDO
            A(I,J) = SUM1
         ENDDO
      ENDDO
      IFAIL = N0
      END
C
C
