C
C
      SUBROUTINE G01AFF$(INOB, IPRED, M, N, NOBS, NUM, PRED, CHIS, P,
     +                   NPOS, NDF, M1, N1, IFAIL)
C
C ACTION : Chi-square and Fisher exact tests
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 16/3/97
C
C          IFAIL is not checked on entry so it is like IFAIL = 1
C
C          Otherwise this acts like the NAG routine as follows:-
C          Fisher exact is done if 2 by 2 and total <= 40 (changed 14/06/2014)
C          For larger 2 by 2 matrices the half correction is used
C          If NUM = 1 then shrinkage can take place if r(i,j) < 1
C          Factorials are calculated using log(gamma) (S14ABF$)
C          14/06/2014 introduced N_FISHER for Fisher-exact cut-off point which was N_FISHER = 40 in the
C                     original NAG code. Note that the dimension of P must now be at least P(N_FISHER/2 + 1)
C                     so P(21) is now P(*) and subroutines calling this subroutines must be redimensioned
C          09/10/2017 re-set N_FISHER to 40
C
      IMPLICIT    NONE
      INTEGER     IFAIL, INOB, IPRED, M, M1, N, N1, NDF, NPOS, NUM,
     +            NOBS(INOB,N)
      DOUBLE PRECISION CHIS, P(*), PRED(IPRED,N)
C
C Local variables
C
      INTEGER    I, INEW, ISIZE, ITRY, J, JNEW, JSIZE, JTRY, K, KNEW,
     +           NNEG, NTOT
      INTEGER    NCMIN, NRMIN, NC1, NC2, NR1, NR2
      INTEGER    MVAL, NVAL, NTEMP
      INTEGER    N_FISHER
      PARAMETER (N_FISHER = 40)
      DOUBLE PRECISION ZERO, HALF, ONE, EXPMIN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, HALF = 0.5D+00,
     +           EXPMIN = - 700.0D+00)
      DOUBLE PRECISION TEMP
      DOUBLE PRECISION CONST, C1, C2, DENOM, R, R1, R2, T
      DOUBLE PRECISION S14ABF$
      LOGICAL    SHRINK
      EXTERNAL   S14ABF$
      INTRINSIC  ABS, DBLE, EXP, MIN
C
C Initialise then pick up M, N since they are not to be changed
C
      IFAIL = 0
      MVAL = M
      NVAL = N
      NPOS = 0
      NDF = 0
      IF (NUM.NE.1) NUM = 0
      M1 = 0
      N1 = 0
      CHIS = ZERO
C
C Return here to start again if shrinkage has taken place
C
   20 CONTINUE
      NNEG = 0
C
C Work out the column marginals
C
      DO I = 1, NVAL - 1
         NOBS(MVAL,I) = 0
         DO J = 1, MVAL - 1
            IF (NOBS(J,I).LT.0) NNEG = NNEG + 1
            NOBS(MVAL,I) = NOBS(MVAL,I) + NOBS(J,I)
         ENDDO
      ENDDO
      IF (NNEG.GT.0) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Work out the row marginals
C
      DO I = 1, MVAL - 1
         NOBS(I,NVAL) = 0
         DO J = 1, NVAL - 1
            NOBS(I,NVAL) = NOBS(I,NVAL) + NOBS(I,J)
         ENDDO
      ENDDO
      IF (NNEG.GT.0) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Work out the total and define NOBS(MVAL,NVAL)
C
      NTOT = 0
      DO I = 1, NVAL - 1
         NTOT = NTOT + NOBS(MVAL,I)
      ENDDO
      NOBS(MVAL,NVAL) = NTOT
      IF (NTOT.EQ.0) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Shuffle the columns if necessary where there are zero columns
C
      N1 = NVAL - 1
      NTEMP = N1
      DO I = 1, NTEMP
         IF (NOBS(MVAL,I).EQ.0) THEN
            N1 = N1 - 1
            NVAL = NVAL - 1
            DO J = I, NVAL
               DO K = 1, MVAL
                  NOBS(K,J) = NOBS(K,J + 1)
               ENDDO
            ENDDO
         ENDIF
      ENDDO
C
C Shuffle the rows if necessary where there are zero rows
C
      M1 = MVAL - 1
      NTEMP = M1
      DO I = 1, NTEMP
         IF (NOBS(I,NVAL).EQ.0) THEN
            M1 = M1 - 1
            MVAL = MVAL - 1
            DO J = I, MVAL
               DO K = 1, NVAL
                  NOBS(J,K) = NOBS(J + 1,K)
               ENDDO
            ENDDO
         ENDIF
      ENDDO
      IF (N1.LT.2 .OR. M1.LT.2) THEN
         IFAIL = 1
         RETURN
      ENDIF
C
C Define T and NDOF
C
      NOBS(M1 + 1,N1  + 1) = NTOT
      T = DBLE(NTOT)
      NDF = (N1 - 1)*(M1 - 1)
      IF (M1.GT.2 .OR. N1.GT.2) THEN
C
C The general case
C
         SHRINK = .FALSE.
         DO I = 1, M1
            TEMP = DBLE(NOBS(I,NVAL))/T
            DO J = 1, N1
               PRED(I,J) = DBLE(NOBS(MVAL,J))*TEMP
               IF (NUM.EQ.1) THEN
                  IF (PRED(I,J).LT.ONE) THEN
C
C Exit from here if shrinkage is necessary
C
                     SHRINK = .TRUE.
                     INEW = I
                     JNEW = J
                     GOTO 40
                  ENDIF
               ENDIF
            ENDDO
         ENDDO
   40    CONTINUE
         IF (SHRINK) THEN
C
C Special option only if shrinkage is required and is actually necessary
C
            ISIZE = NOBS(INEW,NVAL)*M1
            JSIZE = NOBS(MVAL,JNEW)*N1
            IF (ISIZE.LE.JSIZE) THEN
C
C Shrink a row
C
               IF (INEW.EQ.1) THEN
                  ITRY = 2
               ELSEIF (INEW.EQ.M1) THEN
                  ITRY = M1 - 1
               ELSE
                  I = NOBS(INEW - 1,NVAL)
                  J = NOBS(INEW + 1,NVAL)
                  IF (I.LE.J) THEN
                     ITRY = INEW - 1
                  ELSE
                     ITRY = INEW + 1
                  ENDIF
               ENDIF
               JTRY = JNEW
            ELSE
C
C Shrink a column
C
               ITRY = INEW
               IF (JNEW.EQ.1) THEN
                  JTRY = 2
               ELSEIF (JNEW.EQ.N1) THEN
                  JTRY = N1 - 1
               ELSE
                  I = NOBS(MVAL,JNEW - 1)
                  J = NOBS(MVAL,JNEW + 1)
                  IF (I.LE.J) THEN
                     JTRY = JNEW - 1
                  ELSE
                     JTRY = JNEW + 1
                  ENDIF
               ENDIF
            ENDIF
            IF (ITRY.LT.INEW) THEN
C
C Add to previous row
C
               MVAL = MVAL - 1
               DO I = 1, N1
                  NOBS (ITRY,I) = NOBS(ITRY,I) + NOBS(INEW,I)
               ENDDO
               DO I = INEW, MVAL
                  DO J = 1, N1
                     NOBS(I,J) = NOBS(I + 1,J)
                  ENDDO
               ENDDO
            ELSEIF (ITRY.GT.INEW) THEN
C
C Add to next lower row
C
               MVAL = MVAL - 1
               DO I = 1, N1
                  NOBS (INEW,I) = NOBS(INEW,I) + NOBS(ITRY,I)
               ENDDO
               DO I = ITRY, MVAL
                  DO J = 1, N1
                     NOBS(I,J) = NOBS(I + 1,J)
                  ENDDO
               ENDDO
            ELSEIF (JTRY.LT.JNEW) THEN
C
C Add to previous column
C
               NVAL = NVAL - 1
               DO I = 1, M1
                  NOBS (I,JTRY) = NOBS(I,JTRY) + NOBS(I,JNEW)
               ENDDO
               DO I = JNEW, NVAL
                  DO J = 1, M1
                     NOBS(J,I) = NOBS(J,I + 1)
                  ENDDO
               ENDDO
            ELSEIF (JTRY.GT.JNEW) THEN
C
C Add to next right column
C
               NVAL = NVAL - 1
               DO I = 1, M1
                  NOBS (I,JNEW) = NOBS(I,JNEW) + NOBS(I,JTRY)
               ENDDO
               DO I = JTRY, NVAL
                  DO J = 1, M1
                     NOBS(J,I) = NOBS(J,I + 1)
                  ENDDO
               ENDDO
            ENDIF
C
C The contingency table has been shrunk so start again
C
            SHRINK = .FALSE.
            GOTO 20
         ENDIF
C
C Assign CHIS
C
         CHIS = ZERO
         DO I = 1, N1
            DO J = 1, M1
               CHIS = CHIS + (PRED(J,I) - DBLE(NOBS(J,I)))**2/PRED(J,I)
            ENDDO
         ENDDO
         NUM = 0
      ELSE
C
C 2 by 2 but too large for Fisher exact ... use continuity correction
C
         IF (NTOT.GT.N_FISHER) THEN
            DO I = 1, 2
               DO J = 1, 2
                  PRED(I,J) = DBLE(NOBS(MVAL,J))*DBLE(NOBS(I,NVAL))/T
               ENDDO
            ENDDO
            CHIS = ZERO
            DO I = 1, 2
               DO J = 1, 2
                  CHIS = CHIS + (ABS(NOBS(I,J) - PRED(I,J)) - HALF)**2
     +                          /PRED(I,J)
               ENDDO
            ENDDO
            NUM = 0
         ELSE
C
C Fisher exact ... adjust so R1 is the smallest marginal and C1 <= C2
C
            NC1 = NOBS(3,1)
            NC2 = NOBS(3,2)
            NR1 = NOBS(1,3)
            NR2 = NOBS(2,3)
            NCMIN = MIN(NC1,NC2)
            NRMIN = MIN(NR1,NR2)
            IF (NRMIN.GE.NCMIN) THEN
               IF (NC2.EQ.NCMIN) THEN
                  INEW = 2
               ELSE
                  INEW = 1
               ENDIF
               IF (NR2.LT.NR1) THEN
                  JNEW = 2
               ELSE
                  JNEW = 1
               ENDIF
               KNEW = NOBS(3,INEW)
               C1 = DBLE(NOBS(JNEW,3))
               NPOS = NOBS(JNEW,INEW) + 1
            ELSE
               IF (NR2.EQ.NRMIN) THEN
                  INEW = 2
               ELSE
                  INEW = 1
               ENDIF
               IF (NC2.LT.NC1) THEN
                  JNEW = 2
               ELSE
                  JNEW = 1
               ENDIF
               KNEW = NOBS(INEW,3)
               C1 = DBLE(NOBS(3,JNEW))
               NPOS = NOBS(INEW,JNEW) + 1
            ENDIF
C
C Now calculate P values using log(gamma)
C
            R1 = DBLE(KNEW)
            R2 = T - R1
            C2 = T - C1
            I = 1
            TEMP = R1 + ONE
            CONST = S14ABF$(TEMP, I)
            I = 1
            TEMP = R2 + ONE
            CONST = CONST + S14ABF$(TEMP, I)
            I = 1
            TEMP = C1 + ONE
            CONST = CONST + S14ABF$(TEMP, I)
            I = 1
            TEMP = C2 + ONE
            CONST = CONST + S14ABF$(TEMP, I)
            I = 1
            TEMP = T + ONE
            CONST = CONST - S14ABF$(TEMP, I)
            NUM = KNEW + 1
            DO I = 0, KNEW
               R = DBLE(I)
               TEMP = R + ONE
               J = 1
               DENOM = S14ABF$(TEMP, J)
               J = 1
               TEMP = R1 - R + ONE
               DENOM = DENOM + S14ABF$(TEMP, J)
               J = 1
               TEMP = C1 - R + ONE
               DENOM = DENOM + S14ABF$(TEMP, J)
               J = 1
               TEMP = T - C1 - R1 + R + ONE
               DENOM = DENOM + S14ABF$(TEMP, J)
               TEMP = CONST - DENOM
               IF (TEMP.LE.EXPMIN) TEMP = EXPMIN
               P(I + 1) = EXP(TEMP)
            ENDDO
         ENDIF
      ENDIF
      END
C
C
