C
C
      SUBROUTINE G01BJF$(N, P, K, PLEK, PGTK, PEQK, IFAIL)
C
C ACTION : Binomial distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/3/97
C
C          IFAIL is not tested on entry and the methods are not
C          as accurate as the NAG ones for extreme values of N and p.
C          The exact method is used for small N which is probably
C          more accurate than the NAG method
C
      IMPLICIT NONE
      INTEGER   IFAIL, K, N
      DOUBLE PRECISION P, PEQK, PGTK, PLEK
C
C Local variables
C
      INTEGER    I, NMAX
      PARAMETER (NMAX = 10)
      DOUBLE PRECISION ZERO, EPSI, ONE, TWO, TOLVAL
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-16, ONE = 1.0D+00,
     +           TWO = 2.0D+00, TOLVAL = 1.0D-8)
      DOUBLE PRECISION PMAX, PMIN
      PARAMETER (PMIN = EPSI, PMAX = ONE - EPSI)
      DOUBLE PRECISION PVAL, QVAL
      DOUBLE PRECISION XX, AA, BB, TOL, PP, PDF, QQ
      DOUBLE PRECISION COEFF(0:NMAX), PROB(0:NMAX)
      EXTERNAL G01EEF$
      INTRINSIC DBLE
C
C Initialise
C
      IFAIL = 0
      PLEK = ZERO
      PEQK = ZERO
      PGTK = ZERO
      IF (N.LE.0) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (P.LE.ZERO .OR. P.GE.ONE) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (K.LT.0 .OR. K.GT.N) THEN
         IFAIL = 3
         RETURN
      ENDIF
      IF (DBLE(N)*P*(ONE - P) .GT. 1.0D6) IFAIL = 5
      IF (P.LE.PMIN) THEN
         PVAL = PMIN
      ELSEIF (P.GE.PMAX) THEN
         PVAL = PMAX
      ELSE
         PVAL = P
      ENDIF
      QVAL = ONE - PVAL
      IF (N.EQ.1) THEN
C
C The special case N = 1
C
         IF (K.EQ.0) THEN
            PLEK = QVAL
            PEQK = QVAL
            PGTK = PVAL
         ELSE
            PLEK = ONE
            PEQK = PVAL
            PGTK = ZERO
         ENDIF
      ELSEIF (N.EQ.2) THEN
C
C The special case N = 2
C
         COEFF(0) = ONE
         COEFF(1) = TWO
         COEFF(2) = ONE
         PROB(0) = COEFF(0)*QVAL**2
         PROB(1) = COEFF(1)*PVAL*QVAL
         PROB(2) = COEFF(2)*PVAL**2
         IF (K.EQ.0) THEN
            PLEK = PROB(0)
            PEQK = PROB(0)
            PGTK = PROB(1) + PROB(2)
         ELSEIF (K.EQ.1) THEN
            PLEK = PROB(0) + PROB(1)
            PEQK = PROB(1)
            PGTK = PROB(2)
         ELSEIF (K.EQ.2) THEN
            PLEK = PROB(0) + PROB(1) + PROB(2)
            PEQK = PROB(2)
            PGTK = ZERO
         ENDIF
       ELSEIF (N.LE.NMAX) THEN
C
C The special cases N = 3 to N = NMAX
C
          COEFF(0) = ONE
          COEFF(1) = DBLE(N)
          COEFF(N - 1) = COEFF(1)
          COEFF(N) = ONE
          IF (N.EQ.4) THEN
             COEFF(2) = 6.0D+00
          ELSEIF (N.EQ.5) THEN
             COEFF(2) = 10.0D+00
             COEFF(3) = 10.0D+00
          ELSEIF (N.EQ.6) THEN
             COEFF(2) = 15.0D+00
             COEFF(3) = 20.0D+00
             COEFF(4) = 15.0D+00
          ELSEIF (N.EQ.7) THEN
             COEFF(2) = 21.0D+00
             COEFF(3) = 35.0D+00
             COEFF(4) = 35.0D+00
             COEFF(5) = 21.0D+00
          ELSEIF (N.EQ.8) THEN
             COEFF(2) = 28.0D+00
             COEFF(3) = 56.0D+00
             COEFF(4) = 70.0D+00
             COEFF(5) = 56.0D+00
             COEFF(6) = 28.0D+00
          ELSEIF (N.EQ.9) THEN
             COEFF(2) = 36.0D+00
             COEFF(3) = 84.0D+00
             COEFF(4) = 126.0D+00
             COEFF(5) = 126.0D+00
             COEFF(6) = 84.0D+00
             COEFF(7) = 36.0D+00
          ELSEIF (N.EQ.10) THEN
             COEFF(2) = 45.0D+00
             COEFF(3) = 120.0D+00
             COEFF(4) = 210.0D+00
             COEFF(5) = 252.0D+00
             COEFF(6) = 210.0D+00
             COEFF(7) = 120.0D+00
             COEFF(8) = 45.0D+00
          ENDIF
          DO I = 0, N
             PROB(I) = COEFF(I)*PVAL**I*QVAL**(N - I)
          ENDDO
          IF (K.LT.N) THEN
             DO I = 0, K
                PLEK = PLEK + PROB(I)
             ENDDO
             DO I = K + 1, N
                PGTK = PGTK + PROB(I)
             ENDDO
          ELSE
             PLEK = ONE
             PGTK = ZERO
          ENDIF
          PEQK = PROB(K)
       ELSE
          IF (K.LT.N) THEN
             XX = PVAL
             AA = DBLE(K) + ONE
             BB = DBLE(N) + ONE - AA
             TOL = TOLVAL
             I = 1
             CALL G01EEF$(XX, AA, BB, TOL, PP, QQ, PDF, I)
             PGTK = PP
             PLEK = ONE - PGTK
          ELSE
             PGTK = ZERO
             PLEK = ONE
          ENDIF
          IF (K.EQ.0) THEN
             PEQK = PLEK
          ELSE
             XX = PVAL
             AA = DBLE(K)
             BB = DBLE(N) + ONE - AA
             TOL = TOLVAL
             I = 1
             CALL G01EEF$(XX, AA, BB, TOL, PP, QQ, PDF, I)
             PEQK = PP - PGTK
          ENDIF
       ENDIF
       END
C
C
