C
C
      SUBROUTINE G01BKF$(RLAMDA, K, PLEK, PGTK, PEQK, IFAIL)
C
C ACTION : Poisson distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 16/3/97
C
C          IFAIL is not tested on entry and the methods are not
C          as accurate as the NAG ones for extreme values.
C          The exact method is used for small N which is probably
C          more accurate than the NAG method
C          ........................................................
C          The Knusel method should be implemented for this routine
C          as soon as I get time.
C          Leo Knusel Siam J Sci Stat Comput 1986, 1022-1036
C          ........................................................
C
      IMPLICIT NONE
      INTEGER   IFAIL, K
      DOUBLE PRECISION RLAMDA, PEQK, PGTK, PLEK
C
C Local variables
C
      INTEGER    I, J, NMAX
      PARAMETER (NMAX = 50)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION EXPMAX, EXPMIN
      PARAMETER (EXPMAX = 700.0D+00, EXPMIN = - 700.0D+00)
      DOUBLE PRECISION A, B, FACTOR, PROB(0:NMAX), RK, RKP1, SUM1, TEMP,
     +                 TERM
      DOUBLE PRECISION S14ABF$
      LOGICAL   MODEST
      EXTERNAL  S14ABF$
      INTRINSIC DBLE, EXP, LOG
C
C Initialise
C
      IFAIL = 0
      PLEK = ZERO
      PEQK = ZERO
      PGTK = ZERO
      IF (RLAMDA.LE.ZERO) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (K.LT.0) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (RLAMDA.GT.1.0D6) THEN
         IFAIL = 3
         RETURN
      ENDIF
C
C Are modest values supplied ?
C
      IF (K.LE.NMAX .AND. RLAMDA.GT.1.0D-3 .AND. RLAMDA .LT.1.0D2) THEN
         MODEST = .TRUE.
      ELSE
         MODEST = .FALSE.
      ENDIF
      IF (K.EQ.0) THEN
C
C The special case K = 0
C
         PLEK = EXP(- RLAMDA)
         PEQK = PLEK
         PGTK = ONE - PLEK
      ELSEIF (MODEST) THEN
C
C The special cases K = 1 to K = NMAX
C
         PROB(0) = ONE
         PLEK = PROB(0)
         DO I = 1, K
            PROB(I) = PROB(I - 1)*RLAMDA/DBLE(I)
            PLEK = PLEK + PROB(I)
         ENDDO
         FACTOR = EXP( - RLAMDA)
         PEQK = FACTOR*PROB(K)
         PLEK = FACTOR*PLEK
         PGTK = ONE - PLEK
      ELSE
C
C The general case ... Probably not very accurate
C
         A = - RLAMDA
         B = LOG(RLAMDA)
         SUM1 = ZERO
         RK = ZERO
         RKP1 = ONE
         DO I = 0, K
            J = 1
            TEMP = A + RK*B - S14ABF$(RKP1, J)
            IF (TEMP.LE.EXPMIN) THEN
               TEMP = EXPMIN
            ELSEIF (TEMP.GE.EXPMAX) THEN
               TEMP = EXPMAX
            ENDIF
            TERM = EXP(TEMP)
            SUM1 = SUM1 + TERM
            RK = RK + ONE
            RKP1 = RKP1 + ONE
         ENDDO
         PLEK = SUM1
         PEQK = TERM
         PGTK = ONE - PLEK
      ENDIF
C
C Final check on values
C
      IF (PLEK.LT.ZERO) PLEK = ZERO
      IF (PEQK.LT.ZERO) PEQK = ZERO
      IF (PGTK.LT.ZERO) PGTK = ZERO
      IF (PLEK.GT.ONE) PLEK = ONE
      IF (PEQK.GT.ONE) PEQK = ONE
      IF (PGTK.GT.ONE) PGTK = ONE
      END
C
C
