C
C
      SUBROUTINE G01DBF$(N, PP, IFAIL)
C
C ACTION : Normal scores using NSCOR2 (The Royston method)
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 18/3/97
C
C          IFAIL is not tested on entry so it is equivalent to IFAIL = 1
C
      IMPLICIT   NONE
      INTEGER    IFAIL, N
      DOUBLE PRECISION PP(N)
C
C Local variables
C
      INTEGER    I, J, K
      DOUBLE PRECISION ZERO, B1
      PARAMETER (ZERO = 0.0D+00, B1 = 0.5641896D+00)
      INTEGER    N2
      EXTERNAL   NSCOR2$
      IF (N.LT.1) THEN
         IFAIL = 1
         RETURN
      ELSEIF (N.EQ.1) THEN
C
C The special case N = 1
C
         IFAIL = 0
         PP(1) = ZERO
         RETURN
      ELSEIF (N.EQ.2) THEN
C
C The special case N = 2
C
         IFAIL = 0
         PP(1) = - B1
         PP(2) = B1
         RETURN
      ELSE
C
C N > 2
C
         N2 = N/2
         CALL NSCOR2$(PP, N, N2, IFAIL)
C
C Now adjust to agree with the NAG scheme (increasing order)
C
         J = 0
         K = N + 1
         DO I = 1, N2
            J = J + 1
            K = K - 1
            PP(K) = PP(J)
            PP(J) = - PP(J)
         ENDDO
         IF (N.GT.2*N2) PP(N2 + 1) = ZERO
      ENDIF
      END
C
C****************************************************
C The next code must be available for G01DBF$ to work
C****************************************************
C
      SUBROUTINE NSCOR2$(S, N, N2, IFAIL)
C
C The algorithm by Royston:-
C
C ALGORITHM AS 177.3 (1982), VOL. 31, NO. 2
C
C Approximation for rankits
C
      IMPLICIT   NONE
      INTEGER    IFAIL, N, N2
      DOUBLE PRECISION S(N2)
C
C Local variables
C
      INTEGER    I, J, K
      DOUBLE PRECISION AI, AL1, AN, B1, BB, D, E1, E2, TEMP
      DOUBLE PRECISION ALAM(4), DL1(4), DL2(4), EPS(4), GAM(4)
      DOUBLE PRECISION G01CEF$, CORREC$
      EXTERNAL   G01CEF$, CORREC$
      DATA EPS(1), EPS(2), EPS(3), EPS(4) /
     +     0.419885D0, 0.450536D0, 0.456936D0, 0.468488D0 /,
     +     DL1(1), DL1(2), DL1(3), DL1(4) /
     +     0.112063D0, 0.121770D0, 0.239299D0, 0.215159D0 /,
     +     DL2(1), DL2(2), DL2(3), DL2(4) /
     +     0.080122D0, 0.111348D0, -0.211867D0, -0.115049D0 /,
     +     GAM(1), GAM(2), GAM(3), GAM(4) /
     +     0.474798D0, 0.469051D0, 0.208597D0, 0.259784D0 /,
     +     ALAM(1), ALAM(2), ALAM(3), ALAM(4) /
     +     0.282765D0, 0.304856D0, 0.407708D0, 0.414093D0 /,
     +     BB / - 0.283833D0 /,
     +     D  / - 0.106136D0 /,
     +     B1 /   0.5641896D0 /
      IFAIL = 0
      IF (N2.NE.N/2) THEN
         IFAIL = 3
         RETURN
      ENDIF
      IF (N.LE.1) THEN
         IFAIL = 1
         RETURN
      ENDIF
C
C
      S(1) = B1
      IF (N.EQ.2) RETURN
C
C Calculate normal areas for 3 largest rankits
C
      AN = N
      K = 3
      IF (N2.LT.K) K = N2
      DO I = 1, K
         AI = I
         E1 = (AI - EPS(I))/(AN + GAM(I))
         E2 = E1**ALAM(I)
         S(I) = E1 + E2*(DL1(I) + E2*DL2(I))/AN - CORREC$(I, N)
      ENDDO
      IF (N2.EQ.K) GOTO 20
C
C Calculate normal areas for remaining rankits
C
      DO I = 4, N2
         AI = I
         AL1 = ALAM(4) + BB/(AI + D)
         E1 = (AI - EPS(4))/(AN + GAM(4))
         E2 = E1**AL1
         S(I) = E1 + E2*(DL1(4) + E2*DL2(4))/AN - CORREC$(I, N)
      ENDDO
C
C Convert normal tail areas to normal deviates
C
   20 CONTINUE
      DO I = 1, N2
         J = 1
         TEMP = S(I)
         S(I) = - G01CEF$(TEMP, J)
      ENDDO
      END
C
C****************************************************
C The next code must be available for G01DBF$ to work
C****************************************************
C
      DOUBLE PRECISION FUNCTION CORREC$(I, N)
C
C The Royston algorithm:-
C ALGORITHM 177.4 (1982), VOL. 31, NO. 2
C
C CALCULATES CORRECTION FOR TAIL AREA OF NORMAL DISTRIBUTION
C CORRESPONDING TO ITH LARGEST RANKIT IN SAMPLE SIZE N.
C
C
      IMPLICIT   NONE
      INTEGER    I, N
C
C Local variables
C
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION AMIC, AN, C14
      DOUBLE PRECISION C1(7), C2(7), C3(7)
      DATA  C1(1), C1(2), C1(3), C1(4), C1(5), C1(6), C1(7) /
     +      9.5D0, 28.7D0, 1.9D0, 0.0D0, -7.0D0, -6.2D0, -1.6D0 /,
     +      C2(1), C2(2), C2(3), C2(4), C2(5), C2(6), C2(7) /
     +      -6.195D3, -9.569D3, -6.728D3, -17.614D3, -8.278D3,
     +      -3.570D3, 1.075D3 /,
     +      C3(1), C3(2), C3(3), C3(4), C3(5), C3(6), C3(7) /
     +      9.338D4, 1.7516D5, 4.1040D5, 2.157D6, 2.376D6, 2.065D6,
     +      2.065D6 /,
     +      AMIC / 1.0D-6 /,
     +      C14  / 1.9D-5 /
      CORREC$ = C14
      IF (I*N.EQ.4) RETURN
      CORREC$ = ZERO
      IF (I.LT.1 .OR. I.GT.7) RETURN
      IF (I.NE.4 .AND. N.GT.20) RETURN
      IF (I.EQ.4 .AND. N.GT.40) RETURN
      AN = N
      AN = ONE/(AN*AN)
      CORREC$ = (C1(I) + AN*(C2(I) + AN*C3(I)))*AMIC
      END
C
C

C
C
