C
C
      DOUBLE PRECISION FUNCTION G01EAF$(TAIL, X, IFAIL)
C
C ACTION : Tails of the normal distribution
C AUTHOR : W.G.Bardsley, University of Manchester, 3/3/97
C          Just calls S15ABF$
C ADVICE : This version does not check IFAIL on entry so it
C          is equivalent to soft fail, IFAIL = 1
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION S15ABF$, XTEMP
      CHARACTER  C*1
      EXTERNAL   S15ABF$
      INTRINSIC  ABS
C
C Is it safe ?
C
      IFAIL = 0
      I = 1
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
C
C Lower tail
C
         XTEMP = X
         G01EAF$ = S15ABF$(XTEMP, I)
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
C
C Upper tail
C
         XTEMP = X
         G01EAF$ = ONE - S15ABF$(XTEMP, I)
      ELSEIF (C.EQ.'S' .OR. C.EQ.'s') THEN
C
C Two tail sig. level
C
         XTEMP =  ABS(X)
         G01EAF$ = TWO*(ONE - S15ABF$(XTEMP, I))
      ELSEIF (C.EQ.'C' .or. C.eq.'c') THEN
C
C Confidence interval
C
         XTEMP = ABS(X)
         G01EAF$ = TWO*S15ABF$(XTEMP, I) - ONE
      ELSE
C
C Faulty argument
C
         G01EAF$ = ZERO
         IFAIL = 1
         RETURN
      ENDIF
C
C Make sure the value is in range (0,1)
C
      IF (G01EAF$.LT.ZERO) THEN
         G01EAF$ = ZERO
      ELSEIF (G01EAF$.GT.ONE) THEN
         G01EAF$ = ONE
      ENDIF
      END
C
C
