C
C
      DOUBLE PRECISION FUNCTION G01EBF$(TAIL, T, DF, IFAIL)
C
C ACTION : The t distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/3/97
C
C          After:- ACM 395 Hill Comm ACM vol 13 no. 10 p 617-619
C          The code always sets AREA to the lower tail area then
C          corrects as required by TAIL
C
C          Note that The entry value of IFAIL is not tested so it is
C          equivalent to soft fail with IFAIL = 1
C
C          02/10/2000 revised for large/small t
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION T, DF
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, TWENTY
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, TWENTY = 20.0D+00)
      DOUBLE PRECISION EPSI, TOL
      PARAMETER (EPSI = 1.0D-32, TOL = 1.0D-06)
      DOUBLE PRECISION TMAX, TMIN
      PARAMETER (TMAX = 1.0D+10, TMIN = - TMAX)
      DOUBLE PRECISION AREA, BETA, PDFVAL, PVAL, QVAL, R, S, TOLVAL,
     +                 TVAL
      DOUBLE PRECISION A, B, BOT, CHI, TOP, Z
      DOUBLE PRECISION G01EAF$
      CHARACTER  C*1
      EXTERNAL   G01EAF$, G01EEF$
      INTRINSIC  ABS, SQRT, LOG
C
C Initialise and check
C
      IFAIL = 0
      G01EBF$ = ZERO
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
         TVAL = T
         C = 'L'
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
         TVAL = T
         C = 'U'
      ELSEIF (C.EQ.'S' .OR. C.EQ.'s') THEN
         IF (T.GT.ZERO) THEN
            TVAL = - T
         ELSE
            TVAL = T
         ENDIF
         C = 'S'
      ELSEIF (C.EQ.'C' .OR. C.EQ.'c') THEN
         IF (T.GT.ZERO) THEN
            TVAL = - T
         ELSE
            TVAL = T
         ENDIF
         C = 'C'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (DF.LE.ZERO) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (T.LT.TMIN) THEN
C
C T very small
C
         AREA = ZERO
      ELSEIF (T.GT.TMAX) THEN
C
C T very large
C
         AREA = ONE
      ELSEIF (ABS(T).LE.EPSI) THEN
C
C The special case T = 0
C
         AREA = HALF
      ELSEIF (DF.LT.TWENTY) THEN
C
C Use a Beta distribution for n < 20
C
         BETA = DF/(DF + T**2)
         R = DF/TWO
         S = HALF
         TOLVAL = TOL
         I = 1
         CALL G01EEF$(BETA, R, S, TOLVAL, PVAL, QVAL, PDFVAL, I)
         IF (TVAL.LE.ZERO) THEN
            AREA = HALF*PVAL
         ELSE
            AREA = HALF + HALF*QVAL
         ENDIF
      ELSE
C
C Use a Cornish-Fisher expansion for n > 20
C
         A = DF - HALF
         B = 48.0D+00*A**2
         Z = SQRT(A*LOG(ONE + TVAL**2/DF))
         CHI = Z
         CHI = CHI + Z*(Z**2 + 3.0D+00)/B
         TOP = Z*(4.0D+00*Z**6 + 33.0D+00*Z**4 + 240.0D+00*Z**2 +
     +            855.0D+00)
         BOT = 10.0D+00*B*(B + 0.8D+00*Z**4 + 100.0D+00)
         CHI = CHI - TOP/BOT
         IF (C.EQ.'L' .OR. C.EQ.'U') THEN
            IF (T.LT.ZERO .AND. CHI.GT.ZERO) CHI = - CHI
         ELSEIF (C.EQ.'C' .OR. C.EQ.'S') THEN
            IF (CHI.GT.ZERO) CHI = - CHI
         ENDIF
         I = 1
         AREA = G01EAF$('L', CHI, I)
      ENDIF
      IF (C.EQ.'L') THEN
         G01EBF$ = AREA
      ELSEIF (C.EQ.'U') THEN
         G01EBF$ = ONE - AREA
      ELSEIF (C.EQ.'C') THEN
         G01EBF$ = ONE - TWO*AREA
      ELSE
         G01EBF$ = TWO*AREA
      ENDIF
      IF (G01EBF$.LT.ZERO) THEN
         G01EBF$ = ZERO
      ELSEIF (G01EBF$.GT.ONE) THEN
         G01EBF$ = ONE
      ENDIF
      END
C
C
