C
C
      DOUBLE PRECISION FUNCTION G01ECF$(TAIL, X, DF, IFAIL)
C
C ACTION : Tails of the chi-square distribution
C AUTHOR : W.G.Bardsley, University of Manchester, 3/3/97
C          Just calls S14BAF$
C          11/12/2000 corrected for noninteger degrees of freedom
C ADVICE : This version does not check IFAIL on entry so it
C          is equivalent to soft fail, IFAIL = 1
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X, DF
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION A, P, Q, TOL, TOL1, XTEMP
      PARAMETER (TOL1 = 1.0D-06)
      CHARACTER  C*1
      EXTERNAL   S14BAF$
C
C Is it safe ?
C
      IFAIL = 0
      G01ECF$ = ZERO
      IF (X.LT.ZERO) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (DF.LT.ONE) THEN
         IFAIL = 3
         RETURN
      ENDIF
      TOL = TOL1
      A = DF/TWO
      XTEMP = X/TWO
      C = TAIL(1:1)
      I = 1
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
C
C Lower tail
C
         CALL S14BAF$(A, XTEMP, TOL, P, Q, I)
         G01ECF$ = P
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
C
C Upper tail
C
         CALL S14BAF$(A, XTEMP, TOL, P, Q, I)
         G01ECF$ = Q
      ELSE
C
C Failure
C
         IFAIL = 1
         RETURN
      ENDIF
C
C Make sure the value is in range (0,1)
C
      IF (G01ECF$.LT.ZERO) THEN
         G01ECF$ = ZERO
      ELSEIF (G01ECF$.GT.ONE) THEN
         G01ECF$ = ONE
      ENDIF
      END
C
C
