C
C
      DOUBLE PRECISION FUNCTION G01EDF$(TAIL, F, DF1, DF2, IFAIL)
C
C ACTION : F Distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/3/97
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION DF1, DF2, F
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER   I
      DOUBLE PRECISION ZERO, ONE, TWO, FOUR
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           FOUR = 4.0D+00)
      DOUBLE PRECISION AVAL, BVAL, TOLVAL, PVAL, QVAL, PDFVAL, XVAL
      DOUBLE PRECISION BOT, TOP
      DOUBLE PRECISION G01EAF$, G01ECF$
      CHARACTER C*1
      LOGICAL   SWAP
      EXTERNAL  G01EAF$, G01ECF$, G01EEF$
      INTRINSIC SQRT
      IFAIL = 0
      G01EDF$ = ZERO
C
C Is it safe ?
C
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
         SWAP = .FALSE.
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
         SWAP = .TRUE.
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (F.LT.ZERO) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (DF1.LE.ZERO .OR. DF2.LE.ZERO) THEN
         IFAIL = 3
         RETURN
      ENDIF
      IF (DF1.GT.1.0D5 .AND. DF2.GT.1.0D5) THEN
C
C Both DF1 and DF2 very large ... use normal approximation
C
         TOP = F*(DF2 - TWO)/DF2 - ONE
         BOT = SQRT(TWO*(DF1 + DF2 - TWO)/(DF1*(DF2 - FOUR)))
         XVAL = TOP/BOT
         I = 1
         QVAL = G01EAF$('U', XVAL, I)
         IF (I.NE.0) IFAIL = 4
         IF (SWAP) THEN
            G01EDF$ = QVAL
         ELSE
            G01EDF$ = ONE - QVAL
         ENDIF
      ELSEIF (DF1.GT.1.0D5) THEN
C
C Only DF1 is large
C
         XVAL = DF2/F
         I = 1
         QVAL = G01ECF$('L', XVAL, DF2, I)
         IF (I.NE.0) IFAIL = 4
         IF (SWAP) THEN
            G01EDF$ = QVAL
         ELSE
            G01EDF$ = ONE - QVAL
         ENDIF
      ELSEIF (DF2.GT.1.0D5) THEN
C
C Only DF2 is large
C
         XVAL = DF1*F
         I = 1
         QVAL = G01ECF$('U', XVAL, DF1, I)
         IF (I.NE.0) IFAIL = 4
         IF (SWAP) THEN
            G01EDF$ = QVAL
         ELSE
            G01EDF$ = ONE - QVAL
         ENDIF
      ELSE
C
C All values reasonable ... use beta distribution
C
         XVAL = DF1*F/(DF1*F + DF2)
         AVAL = DF1/TWO
         BVAL = DF2/TWO
         TOLVAL = 1.0D-6
         I = 1
         CALL G01EEF$(XVAL, AVAL, BVAL, TOLVAL, PVAL, QVAL, PDFVAL, I)
         IF (I.NE.0) IFAIL = 4
         IF (SWAP) THEN
            G01EDF$ = QVAL
         ELSE
            G01EDF$ = PVAL
         ENDIF
      ENDIF
      END
C
C
