C
C
      SUBROUTINE G01EEF$(XVAL, AVAL, BVAL, TOLVAL, PVAL, QVAL, PDFVAL,
     +                   IFAIL)
C
C ACTION : beta distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/3/97
C          AS 63 Majumder and Bhattacharjee, 409-411, 1973
C
C          This version uses log(beta) to avoid underflow problems
C
C          Note: there is no test for IFAIL on entry so it is
C                equivalent to soft fail, i.e. IFAIL = 1
C
      IMPLICIT NONE
      INTEGER   IFAIL
      DOUBLE PRECISION AVAL, BVAL, PVAL, PDFVAL, QVAL, TOLVAL, XVAL
C
C Local variables
C
      INTEGER   I, NS
      DOUBLE PRECISION ZERO, EPSI, ONE
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-10, ONE = 1.0D+00)
      DOUBLE PRECISION ABLIM, XMAX, XMIN, XMIN4
      PARAMETER (ABLIM = 1.0D+06, XMIN = 1.0D-16, XMAX = ONE - XMIN,
     +           XMIN4 = XMIN**4)
      DOUBLE PRECISION ACU, AI, BETA, BETAIN, CX, P, PP, PSQ, Q, QQ,
     +                 RX, TEMP, TERM, X, XX, X1, X2, X3
      DOUBLE PRECISION S14ABF$
      LOGICAL INDEX1
      EXTERNAL S14ABF$
      INTRINSIC ABS, EXP, INT, LOG
C
C Initialise
C
      IFAIL = 0
      PDFVAL = ZERO
      PVAL = ZERO
      QVAL = ZERO
C
C Is it safe ?
C
      IF (XVAL.LT.ZERO .OR. XVAL.GT.ONE) THEN
         IFAIL = 1
         RETURN
      ELSE
         X = XVAL
         IF (X.LE.XMIN4) THEN
            X = XMIN4
         ELSEIF (X.GT.XMAX) THEN
            X = XMAX
         ENDIF
      ENDIF
      IF (AVAL.LE.ZERO .OR. AVAL.GT.ABLIM .OR.
     +    BVAL.LE.ZERO .OR. BVAL.GT.ABLIM) THEN
         IFAIL = 2
         RETURN
      ELSE
         P = AVAL
         Q = BVAL
      ENDIF
      ACU = TOLVAL
      IF (ACU.LT.EPSI) ACU = EPSI
C
C Calculate the normalising factor BETA
C
       I = 1
       X1 = S14ABF$(P, I)
       I = 1
       X2 = S14ABF$(Q, I)
       I = 1
       TEMP = P + Q
       X3 = S14ABF$(TEMP, I)
       TEMP = X1 + X2 - X3
C********************************************
C******BETA = EXP(TEMP)....(original version)
C Use log(beta) instead of beta itself
C********************************************
       BETA = TEMP
C
C Swap tails if recommended
C
       PSQ = P + Q
       CX = ONE - X
       IF (P .LT. PSQ*X) THEN
          INDEX1 = .TRUE.
          XX = CX
          CX = X
          PP = Q
          QQ = P
       ELSE
          INDEX1 = .FALSE.
          XX = X
          PP = P
          QQ = Q
       ENDIF
C
C Set up the iteration
C
       TERM = ONE
       AI = ONE
       BETAIN = ONE
       NS = INT(QQ + CX*PSQ)
       RX = XX/CX
C
C Use Soper's reduction formula
C
   20 CONTINUE
      TEMP = QQ - AI
      IF (NS.EQ.0) RX = XX
   40 CONTINUE
      TERM = TERM*TEMP*RX/(PP + AI)
      BETAIN = BETAIN + TERM
      TEMP = ABS(TERM)
      IF (TEMP.LE.ACU .AND. TEMP.LE.ACU*BETAIN) GOTO 60
      AI = AI + ONE
      NS = NS - 1
      IF (NS.GE.0) GOTO 20
      TEMP = PSQ
      PSQ = PSQ + ONE
      GOTO 40
   60 CONTINUE
C
C Final calculation
C
C******************************************************************
C Use log(beta) rather than beta itself
C ....original version
C     BETAIN = BETAIN*EXP(PP*LOG(XX) + (QQ - ONE)*LOG(CX))/(PP*BETA)
C*******************************************************************
      BETAIN = BETAIN*EXP(PP*LOG(XX) + (QQ - ONE)*LOG(CX) - BETA)/PP
      IF (BETAIN.LT.ZERO) THEN
         BETAIN = ZERO
      ELSEIF (BETAIN.GT.ONE) THEN
         BETAIN = ONE
      ENDIF
      IF (INDEX1) BETAIN = ONE - BETAIN
      PVAL = BETAIN
      QVAL = ONE - PVAL
C*****************************************************
C Use log(beta) instead of beta as in original version
C     PDFVAL = X**(P - ONE)*(ONE - X)**(Q - ONE)/BETA
C*****************************************************
      PDFVAL = EXP((P - ONE)*LOG(X) + (Q - ONE)*LOG(ONE - X) - BETA)
      END
C
C
