C
C
      DOUBLE PRECISION FUNCTION G01EFF$(TAIL, G, A, B, IFAIL)
C
C ACTION : Gamma distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 5/5/97
C
      IMPLICIT   NONE
C
C The argument list
C
      INTEGER    IFAIL
      DOUBLE PRECISION A, B, G
      CHARACTER TAIL*(*)
C
C Local variables
C
      INTEGER    N0, N1, N2, N3
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      DOUBLE PRECISION ZERO, FACTOR
      PARAMETER (ZERO = 0.0D+00, FACTOR = 1.0D+09)
      DOUBLE PRECISION P, Q, TOL, X02AJF$, Z
      CHARACTER  C1*1
      EXTERNAL   S14BAF$, X02AJF$
C
C Is it safe ?
C
      G01EFF$ = ZERO
      IFAIL = N0
      C1 = TAIL(N1:N1)
      IF (C1.EQ.'U' .OR. C1.EQ.'u') THEN
         C1 = 'U'
      ELSEIF (C1.EQ.'L' .OR. C1.EQ.'l') THEN
         C1 = 'L'
      ELSE
         IFAIL = N1
         RETURN
      ENDIF
      IF (G.LT.ZERO) THEN
         IFAIL = N2
         RETURN
      ENDIF
      IF (A.LE.ZERO .OR. B.LE.ZERO) THEN
         IFAIL = N3
         RETURN
      ENDIF
      Z = G/B
      TOL = FACTOR*X02AJF$()
      CALL S14BAF$(A, Z, TOL, P, Q, IFAIL)
      IF (C1.EQ.'L') THEN
         G01EFF$ = P
      ELSE
         G01EFF$ = Q
      ENDIF
      END
C
C
