C
C
      DOUBLE PRECISION FUNCTION G01FAF$(TAIL, P, IFAIL)
C
C ACTION : % points of the normal distribution
C AUTHOR : W.G.Bardsley, University of Manchester, 3/3/97
C          AS 111 J.D.Beasley and S.G.Springer App Stat 26 118-120, 1977
C ADVICE : This version does not check IFAIL on entry so it
C          is equivalent to soft fail, IFAIL = 1
C          It agrees with the NAG routine to 6 or 7 decimal places but
C          the NAG routine is more accurate in the further figures.
C          28/02/2002 edited
C          19/12/2014 corrected error as there was no check for C = 's'
C
      IMPLICIT  NONE
      INTEGER   IFAIL
      DOUBLE PRECISION P
      CHARACTER TAIL*(*)
C
C Local variables
C
      DOUBLE PRECISION ZERO, HALF, ONE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00)
      DOUBLE PRECISION SPLIT
      PARAMETER (SPLIT = 0.42D+00)
      DOUBLE PRECISION A0, A1, A2, A3, B1, B2, B3, B4, C0, C1, C2,
     +                 C3, D1, D2
      PARAMETER (A0 =   2.50662823884D+00,
     +           A1 = -18.61500062529D+00,
     +           A2 =  41.39119773534D+00,
     +           A3 = -25.44106049637D+00,
     +           B1 =  -8.47351093090D+00,
     +           B2 =  23.08336743743D+00,
     +           B3 = -21.06224101826D+00,
     +           B4 =   3.13082909833D+00,
     +           C0 =  -2.78718931138D+00,
     +           C1 =  -2.29796479134D+00,
     +           C2 =   4.85014127135D+00,
     +           C3 =   2.32121276858D+00,
     +           D1 =   3.54388924762D+00,
     +           D2 =   1.63706781897D+00)
      DOUBLE PRECISION PMAX, PMIN
      PARAMETER (PMIN = 1.0D-300, PMAX = 0.9999999999999999D+00)
      DOUBLE PRECISION BOT, PNEW, PPND, Q, R, TOP
      CHARACTER C*1
      INTRINSIC ABS, SQRT, LOG
C
C Is it safe ?
C
      G01FAF$ = ZERO
      IF (P.LT.ZERO .OR. P.GT.ONE) THEN
         IFAIL = 2
         RETURN
      ENDIF
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
         PNEW = P
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
         PNEW = ONE - P
      ELSEIF (C.EQ.'C' .OR. C.EQ.'c') THEN
         PNEW = P + HALF*(ONE - P)
      ELSEIF (C.EQ.'S' .or. C.eq.'s') THEN
         PNEW = ONE - HALF*P
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C Limit the range
C
      IFAIL = 0
      IF (PNEW.LT.PMIN) THEN
         PNEW = PMIN
      ELSEIF (PNEW.GT.PMAX) THEN
         PNEW = PMAX
      ENDIF
      Q = PNEW - HALF
      IF (ABS(Q).LE.SPLIT) THEN
         R = Q*Q
         TOP = Q*(((A3*R + A2)*R + A1)*R + A0)
         BOT = (((B4*R + B3)*R + B2)*R + B1)*R + ONE
         PPND = TOP/BOT
      ELSE
         IF (Q.GT.ZERO) THEN
            R = ONE - PNEW
         ELSE
            R = PNEW
         ENDIF
         IF (R.GT.ZERO) THEN
            R = SQRT(-LOG(R))
            TOP = ((C3*R + C2)*R + C1)*R + C0
            BOT = (D2*R + D1)*R + ONE
            PPND = TOP/BOT
            IF (Q.LT.ZERO) PPND = -PPND
         ELSE
            PPND = ZERO
         ENDIF
      ENDIF
      G01FAF$ = PPND
      IFAIL = 0
      END
C
C
