C
C
      DOUBLE PRECISION FUNCTION G01FBF$(TAIL, P, DF, IFAIL)
C
C ACTION : Inverse of the t distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/3/97
C
C          ACM 396 Hill, G.W. Comm ACM vol 13 no. 10 p 619-620, 1970
C
C          Note that The entry value of IFAIL is not tested so it is
C          equivalent to soft fail with IFAIL = 1
C
C          Special cases are n=1, n=2, n<3, p=1/2 (lower/upper tails)
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION P, DF
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, THREE, FOUR, FIVE, SIX
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, THREE = 3.0D+00, FOUR = 4.0D+00,
     +           FIVE = 5.0D+00, SIX = 6.0D+00)
      DOUBLE PRECISION EPSI, PMAX, PMIN, TOL
      PARAMETER (EPSI = 1.0D-32, TOL = 1.0D-06, PMIN = 1.0D-16,
     +           PMAX = ONE - PMIN)
      DOUBLE PRECISION PNEW, PVAL, R, S, TOLVAL, TVAL
      DOUBLE PRECISION PIBY2
      PARAMETER (PIBY2 = 1.5707963268D+00)
      DOUBLE PRECISION A, B, D, E, X, Y
      DOUBLE PRECISION ROOT, TEMP
      DOUBLE PRECISION G01FAF$, G01FEF$
      CHARACTER  C*1
      EXTERNAL   G01FAF$, G01FEF$
      INTRINSIC  ABS, SQRT, COS, SIN, EXP
C
C Initialise and check
C
      IFAIL = 0
      G01FBF$ = ZERO
      IF (DF.LT.ONE) THEN
         IFAIL = 3
         RETURN
      ENDIF
      IF (P.LE.ZERO .OR. P.GE.ONE) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (P.LE.PMIN) THEN
         PNEW = PMIN
      ELSEIF (P.GE.PMAX) THEN
         PNEW = PMAX
      ELSE
         PNEW = P
      ENDIF
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
         PVAL = TWO*(ONE - PNEW)
         C = 'L'
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
         PVAL = TWO*PNEW
         C = 'U'
      ELSEIF (C.EQ.'S' .OR. C.EQ.'s') THEN
         PVAL = PNEW
         C = 'S'
      ELSEIF (C.EQ.'C' .OR. C.EQ.'c') THEN
         PVAL = ONE - PNEW
         C = 'C'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (C.EQ.'L' .AND. ABS(PNEW - HALF).LE.EPSI .OR.
     +    C.EQ.'U' .AND. ABS(PNEW - HALF).LE.EPSI) THEN
C
C The special case C = 'L', C = 'U' and P = 1/2
C
         TVAL = ZERO
      ELSEIF (ABS(DF - ONE).LE.EPSI) THEN
C
C The special case n = 1
C
         A = PVAL*PIBY2
         TVAL =  COS(A)/SIN(A)
      ELSEIF (ABS(DF - TWO).LE.EPSI) THEN
C
C The special case n = 2
C
         A = TWO/(PVAL*(TWO - PVAL)) - TWO
         TVAL = SQRT(A)
      ELSEIF (DF.LT.THREE) THEN
C
C Use a Beta distribution for n < 3
C
         R = HALF*DF
         S = HALF
         TOLVAL = TOL
         I = 1
         IF (C.EQ.'L') THEN
            IF (PNEW.LT.HALF) THEN
               PVAL = TWO*PNEW
               ROOT = G01FEF$(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - PNEW)
               ROOT = G01FEF$(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ELSEIF (C.EQ.'U') THEN
            TEMP = ONE - PNEW
            IF (TEMP.LT.HALF) THEN
               PVAL = TWO*TEMP
               ROOT = G01FEF$(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - TEMP)
               ROOT = G01FEF$(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ELSEIF (C.EQ.'S') THEN
            TEMP = ONE - HALF*PNEW
            IF (TEMP.LT.HALF) THEN
               PVAL = TWO*TEMP
               ROOT = G01FEF$(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - TEMP)
               ROOT = G01FEF$(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ELSEIF (C.EQ.'C') THEN
            TEMP = HALF*(ONE - PNEW)
            IF (TEMP.LT.HALF) THEN
               PVAL = TWO*TEMP
               ROOT = G01FEF$(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - TEMP)
               ROOT = G01FEF$(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ENDIF
      ELSE
C
C Use a Cornish-Fisher expansion for n > 3
C
         A = ONE/(DF - HALF)
         B = 48.0D+00/A**2
         E = ((20700.0D+00*A/B - 98.0D+00)*A - FOUR**2)*A + 96.36D+00
         D = ((94.5D+00/(B + E) - THREE)/B + ONE)*SQRT(A*PIBY2)*DF
         X = D*PVAL
         Y = X**(TWO/DF)
         IF (Y .GT. 0.05D+00 + A) THEN
            I = 1
            TEMP = HALF*PVAL
            X = G01FAF$('L', TEMP, I)
            Y = X**2
            IF (DF .LT. FIVE) E = E +
     +                        0.3D+00*(DF - 4.5D+00)*(X + 0.6D+00)
            E = (((0.05D+00*D*X - FIVE)*X - 7.0D+00)*X - TWO)*X + B + E
            Y = (((((0.4D+00*Y + 6.3D+00)*Y + 36.0D+00)*Y + 94.5D+00)/E
     +            - Y - THREE)/B + ONE)*X
            Y = A*Y**2
            IF (Y .GT. 0.002D+00) THEN
               Y = EXP(Y) - ONE
            ELSE
               Y = HALF*Y**2 + Y
            ENDIF
         ELSE
            Y = ((ONE/(((DF + SIX)/(DF*Y) - 0.089D+00*D - 0.822D+00)*
     +          (DF + TWO)*THREE) + HALF/(DF + FOUR))*Y - ONE)*
     +          (DF + ONE)/(DF + TWO) + ONE/Y
         ENDIF
         TVAL = SQRT(DF*Y)
      ENDIF
      IF (C.EQ.'L') THEN
         IF (P.GT.HALF) THEN
            G01FBF$ = ABS(TVAL)
         ELSE
            G01FBF$ = - ABS(TVAL)
         ENDIF
      ELSEIF (C.EQ.'U') THEN
         IF (P.GT.HALF) THEN
            G01FBF$ = - ABS(TVAL)
         ELSE
            G01FBF$ = ABS(TVAL)
         ENDIF
      ELSEIF (C.EQ.'C') THEN
         G01FBF$ = ABS(TVAL)
      ELSE
         G01FBF$ = ABS(TVAL)
      ENDIF
      END
C
C
