C
C
      DOUBLE PRECISION FUNCTION G01FCF$(PVAL, DF, IFAIL)
C
C ACTION : percentage points of the chi-square distribution
C AUTHOR : W.G.Bardsley, University of Manchester, 3/3/97
C
C          Ref: Best and Roberts AS 91 24, 385-388, 1975
C
C ADVICE : This version does not check IFAIL on entry so it
C          is equivalent to soft fail, IFAIL = 1
C          It agrees with the NAG routine up to about six places
C          28/02/2002 edited
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION PVAL, DF
C
C Local variables
C
      INTEGER    I, IF1
      INTEGER    ICOUNT, NMAX
      PARAMETER (NMAX = 50)
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION TOL
      PARAMETER (TOL = 1.0D-06)
      DOUBLE PRECISION AA, E
      PARAMETER (AA = 0.6931471805D+00, E = 5.0D-07)
      DOUBLE PRECISION G01FAF$, S14ABF$
      DOUBLE PRECISION A, B, C, CH, G, P, PP, P1, P2, Q, QQ, T,
     +                 V, X, XX, Y
      DOUBLE PRECISION S1, S2, S3, S4, S5, S6
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      EXTERNAL   G01FAF$, S14ABF$, S14BAF$
      INTRINSIC  ABS, SQRT, LOG, EXP
C
C Is it safe ?
C
      IFAIL = 0
      G01FCF$ = ZERO
      IF (PVAL.LT.ZERO .OR. PVAL.GT.ONE) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (DF.LT.ONE) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Define parameters
C
      IF (PVAL.LE.0.000002D+00) THEN
         P = 0.000002D+00
      ELSEIF (PVAL.GE.0.999998D+00) THEN
         P = 0.999998D+00
      ELSE
         P = PVAL
      ENDIF
      IF (DF.GE.1.0D+05) THEN
C
C Wilson Hilferty approximation for large DF
C
         V = DF
         IF1 = 1
         X = G01FAF$(TAIL, P, IF1)
         P1 = 0.222222D+00/V
         CH = V*(X*SQRT(P1) + ONE - P1)**3
         IF (CH.LE.ZERO) CH = ZERO
         G01FCF$ = CH
         RETURN
      ENDIF
      V = DF
      XX = V/TWO
      I = 1
      G = S14ABF$(XX, I)
      XX = V/TWO
      C = XX - ONE
C
C Starting estimates ... The method depends on V and P
C
      IF (V .LT. -1.24D+00*LOG(P)) THEN
         CH = (P*XX*EXP(G + XX*AA))**(ONE/XX)
         IF (CH.LT.E) THEN
            G01FCF$ = CH
            RETURN
         ENDIF
      ELSE
         IF (V .LT. 0.32D+00) THEN
C
C Newton Raphson
C
            CH = 0.4D+00
            A = LOG(ONE - P)
            ICOUNT = 0
   20       CONTINUE
            ICOUNT = ICOUNT + 1
            Q = CH
            P1 = ONE + CH*(4.67D+00 + CH)
            P2 = CH*(6.73D+00 + CH*(6.66D+00 + CH))
            T = - HALF + (4.67D+00 + TWO*CH)/P1
     +          - (6.73D+00 + CH*(13.32D+00 + 3.0D+00*CH))/P2
            CH = CH - (ONE - EXP(A + G + HALF*CH + C*AA)*P2/P1)/T
            IF (ABS(Q/CH - ONE) - 0.01D+00 .GT. ZERO .AND.
     +         ICOUNT.LT.NMAX) GOTO 20
         ELSE
C
C Wilson Hilferty approximation
C
            IF1 = 1
            X = G01FAF$(TAIL, P, IF1)
            P1 = 0.222222D+00/V
            CH = V*(X*SQRT(P1) + ONE - P1)**3
C
C The special case P -> 1
C
            IF (CH .GT. 2.2D+00*V + 6.0D+00) CH = - TWO*(LOG(ONE - P)
     +                                    - C*LOG(HALF*CH) + G)
         ENDIF
      ENDIF
C
C The evaluation process
C
      ICOUNT = 0
   40 CONTINUE
      ICOUNT = ICOUNT + 1
      Q = CH
      P1 = HALF*CH
      IF1 = 1
      CALL S14BAF$(XX, P1, TOL, PP, QQ, IF1)
      IF (IF1.NE.0) RETURN
      Y = PP
      P2 = P - Y
      T = P2*EXP(XX*AA + G + P1 - C*LOG(CH))
      B = T/CH
      A = HALF*T - B*C
      S1 = (210.0D+00 + A*(140.0D+00 + A*(105.0D+00 +
     +      A*(84.0D+00 + A*(70.0D+00 + 60.0D+00*A)))))/420.0D+00
      S2 = (420.0D+00 + A*(735.0D+00 + A*(966.0D+00 +
     +      A*(1141.0D+00 + 1278.0D+00*A))))/2520.0D+00
      S3 = (210.0D+00 + A*(462.0D+00 +
     +      A*(707.0D+00 + 932.0D+00*A)))/2520.0D+00
      S4 = (252.0D+00 + A*(672.0D+00 + 1182.0D+00*A) +
     +      C*(294.0D+00 + A*(889.0D+00 + 1740.0D+00*A)))/5040.0D+00
      S5 = (84.0D+00 + 264.0D+00*A +
     +      C*(175.0D+00 + 606.0D+00*A))/2520.0D+00
      S6 = (120.0D+00 + C*(346.0D+00 + 127.0D+00*C))/5040.0D+00
      CH = CH + T*(ONE + HALF*T*S1 - B*C*(S1 - B*(S2 - B*(S3
     +                             - B*(S4 - B*(S5 - B*S6))))))
      IF (ABS(Q/CH - ONE) .GT. E .AND. ICOUNT.LT.NMAX) GOTO 40
      IF (CH.LT.ZERO) CH = ZERO
      G01FCF$ = CH
      END
C
C
