C
C
      DOUBLE PRECISION FUNCTION G01FDF$(P, DF1, DF2, IFAIL)
C
C ACTION : Inverse F distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/3/97
C          16/10/2003 revised for increased accuracy
C
C          Uses transformation except for extreme cases when normal
C          or chi-square approximations are used instead of the inverse
C          beta distribution. See Ab and Steg p947
C
      IMPLICIT NONE
      INTEGER   IFAIL
      DOUBLE PRECISION P, DF1, DF2
C
C Local variables
C
      INTEGER   I
      DOUBLE PRECISION ZERO, EPSI, ONE, TWO, FOUR
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0E-06, ONE = 1.0D+00,
     +           TWO = 2.0D+00, FOUR = 4.0D+00)
      DOUBLE PRECISION BMAX, BMIN
      PARAMETER (BMIN = 1.0D-16, BMAX = ONE - BMIN)
      DOUBLE PRECISION BETA, BOT, CHISQD, PVAL, R, S, TOL, TOP, XNORM
      DOUBLE PRECISION G01FAF$, G01FEF$, G01FCF$
      EXTERNAL G01FAF$, G01FEF$, G01FCF$
      INTRINSIC SQRT
C
C Is it safe ?
C
      IFAIL = 0
      G01FDF$ = ZERO
      IF (P.LT.ZERO .OR. P.GE.ONE) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (DF1.LE.ZERO .OR. DF2.LE.ZERO) THEN
         IFAIL = 2
         RETURN
      ENDIF
      PVAL = P
      I = 1
      IF (PVAL.GT.0.999D+00 .AND. DF1.GT.1.0D+04 .OR.
     +    PVAL.GT.0.999D+00 .AND. DF2.GT.1.0D+04) THEN
C
C Treat as special case if at upper tail > .999 (found empirically)
C
         XNORM = G01FAF$('L', PVAL, I)
         TOP = TWO*(DF1 + DF2  - TWO)
         BOT = DF1*(DF2 - FOUR)
         G01FDF$ = DF2*(ONE + XNORM*SQRT(TOP/BOT))/(DF2 - TWO)
      ELSEIF (DF1.GT.1.0D+05 .AND. DF2.GT.1.0D+05) THEN
C
C DF1 and DF2 both large
C
         XNORM = G01FAF$('L', PVAL, I)
         TOP = TWO*(DF1 + DF2  - TWO)
         BOT = DF1*(DF2 - FOUR)
         G01FDF$ = DF2*(ONE + XNORM*SQRT(TOP/BOT))/(DF2 - TWO)
      ELSEIF (DF1.GT.1.0D+05) THEN
C
C DF1 large
C
         CHISQD = G01FCF$(PVAL, DF2, I)
         IF (CHISQD.LE.1.0D-300) CHISQD = 1.0D-300
         G01FDF$ = DF2/CHISQD
      ELSEIF (DF2.GT.1.0D+05) THEN
C
C DF2 large
C
         CHISQD = G01FCF$(PVAL, DF1, I)
         G01FDF$ = CHISQD/DF1
      ELSE
C
C Transform to beta
C
         R = DF1/TWO
         S = DF2/TWO
         TOL = EPSI
         BETA = G01FEF$(PVAL, R, S, TOL, I)
         IF (BETA.LE.BMIN) THEN
            BETA = BMIN
         ELSEIF (BETA.GE.BMAX) THEN
            BETA = BMAX
         ENDIF
         TOP = DF2*BETA
         BOT = DF1*(ONE - BETA)
         G01FDF$ = TOP/BOT
      ENDIF
C
C Final check that F >= 0
C
      IF (G01FDF$.LT.ZERO) G01FDF$ = ZERO
      END
C
C
