C
C
      DOUBLE PRECISION FUNCTION G01FEF$(PVAL, AVAL, BVAL, TOLVAL, IFAIL)
C
C ACTION : inverse beta distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/3/97
C
C          Developed from:-
C          AS 64 Majumder and Bhattacharjee, 411-414, 1973
C
C          This sometimes fails to converge so I implemented
C          AS 109 Correction to the previous by Cran, Martin and Thomas
C          to prevent Newton Raphson diverging. BETA is now log(beta)
C          and ACU = TOLVAL**2 (Appl Statist 26,111-114)
C
C          Subsequently I came across R83 by Berry, Mielke, Grant
C          p 309-310 (1990 ?) replacing ACU and introducing IEX and
C          FPU so TOLVAL is not now used.
C
C          This version accepts the starting estimate if the root has
C          not been located by Newton Raphson. Also it is protected
C          from overflow, e.g. with 0.001, 2345, 5678
C
C          Note: there is no test for IFAIL on entry so it is
C                equivalent to soft fail, i.e. IFAIL = 1
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION AVAL, BVAL, PVAL, TOLVAL
C
C Local variables
C
      INTEGER    I, ICOUNT, IEX, JCOUNT, NMAX
      PARAMETER (NMAX = 40)
      DOUBLE PRECISION ZERO, EPSI, HALF, ONE, TWO, THREE, FOUR, FIVE,
     +                 SIX, NINE, TEN
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-16, HALF = 0.5D+00,
     +           ONE = 1.0D+00, TWO = 2.0D+00, THREE = 3.0D+00,
     +           FOUR = 4.0D+00, FIVE = 5.0D+00,
     +           SIX = 6.0D+00, NINE = 9.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION ABLIM, AMAX, AMIN, XMAX, XMIN
      PARAMETER (ABLIM = 1.0D+06, AMIN = 1.0D-16, AMAX = ONE - AMIN,
     +           XMIN = 1.0D-300, XMAX = ONE - AMIN)
      DOUBLE PRECISION EXPBOT, EXPTOP, XTINY
      PARAMETER (EXPTOP = 100.0D+00, EXPBOT = - EXPTOP, XTINY = XMIN)
      DOUBLE PRECISION SAE, FPU
      PARAMETER (SAE = - 300.0D+00)
      DOUBLE PRECISION ACU, BETA, P, PP, Q, QQ, TEMP, X1, X2, X3
      DOUBLE PRECISION A, ALPHA, R, T, TOL, XINBTA, XTEMP, Y
      DOUBLE PRECISION ADJ, G, H, PREV, YPREV, S, SQ, TX, W
      DOUBLE PRECISION F1, F2, XSAV
      DOUBLE PRECISION S14ABF$
      LOGICAL    INDEX1
      EXTERNAL   G01EEF$, S14ABF$
      INTRINSIC  ABS, EXP, LOG, SQRT, MAX
C
C Initialise
C
      IFAIL = 0
      G01FEF$ = ZERO
C
C Is it safe ?
C
      IF (PVAL.LT.ZERO .OR. PVAL.GT.ONE) THEN
         IFAIL = 1
         RETURN
      ELSE
         ALPHA = PVAL
         IF (ALPHA.LE.AMIN) THEN
            ALPHA = AMIN
         ELSEIF (ALPHA.GE.AMAX) THEN
            ALPHA = AMAX
         ENDIF
      ENDIF
      IF (AVAL.LE.ZERO .OR. AVAL.GT.ABLIM .OR.
     +    BVAL.LE.ZERO .OR. BVAL.GT.ABLIM) THEN
         IFAIL = 2
         RETURN
      ELSE
         P = AVAL
         Q = BVAL
      ENDIF
C
C In this version the next definition of ACU is overwritten by IEX
C
      ACU = TOLVAL*TOLVAL
      IF (ACU.LT.EPSI) ACU = EPSI
C
C Calculate the normalising factor BETA, i.e. log(beta)
C
       I = 1
       X1 = S14ABF$(P, I)
       I = 1
       X2 = S14ABF$(Q, I)
       I = 1
       TEMP = P + Q
       X3 = S14ABF$(TEMP, I)
       BETA = X1 + X2 - X3
C
C Swap tails if recommended
C
       IF (ALPHA.GT.HALF) THEN
          INDEX1 = .TRUE.
          A = ONE - ALPHA
          PP = Q
          QQ = P
       ELSE
          INDEX1 = .FALSE.
          A = ALPHA
          PP = P
          QQ = Q
       ENDIF
C
C Set up the initial approximation
C
      TEMP =  A*A
      IF (TEMP.LE.XTINY) TEMP = XTINY
C
C Calculate Hasting's approximation to y-alpha
C
      R = SQRT( - LOG(TEMP))
      Y = R - (2.30753D+00 + 0.27061D+00*R)/
     +   (ONE + (0.99229D+00 + 0.04481D+00*R)*R)
      IF (PP.GT.ONE .AND. QQ.GT.ONE) THEN
C
C The new case treated by Cran, Martin and Thomas
C
         R = (Y*Y - THREE)/SIX
         S = ONE/(TWO*PP - ONE)
         T = ONE/(TWO*QQ - ONE)
         H = TWO/(S + T)
         W = Y*SQRT(H + R)/H - (T - S)*(R + FIVE/SIX - TWO/(THREE*H))
         XINBTA = PP/(PP + QQ*EXP(TWO*W))
      ELSE
C
C Calculate Wilson and Hilferty's approximation to chi-square
C
         R = TWO*QQ
         T = ONE/(NINE*QQ)
         T = R*(ONE - T + Y*SQRT(T))**3
         IF (T.LE.ZERO) THEN
C
C Deal with negative chi-square
C
            TEMP = (ONE - A)*QQ
            IF (TEMP.LE.XTINY) TEMP = XTINY
            TEMP = (LOG(TEMP) + BETA)/QQ
            IF (TEMP.LE.EXPBOT) THEN
               TEMP = EXPBOT
            ELSEIF (TEMP.GE.EXPTOP) THEN
                TEMP = EXPTOP
            ENDIF
            XINBTA = ONE - EXP(TEMP)
         ELSE
C
C Calculate the RHS of Sheffe and Tukey's equation
C
            T = (FOUR*PP + R - TWO)/T
            IF (T.GT.ONE) THEN
C
C Solve the equation for RHS > 1
C
               XINBTA = ONE - TWO/(T + ONE)
            ELSE
C
C The alternative solution
C
               TEMP = A*PP
               IF (TEMP.LE.XTINY) TEMP = XTINY
               TEMP = (LOG(TEMP) + BETA)/PP
               IF (TEMP.LE.EXPBOT) THEN
                  TEMP = EXPBOT
               ELSEIF (TEMP.GE.EXPTOP) THEN
                  TEMP = EXPTOP
               ENDIF
               XINBTA = EXP(TEMP)
            ENDIF
         ENDIF
      ENDIF
C
C Reflect back extreme values then save the estimate
C
      IF (XINBTA.LE.0.0001D+00) THEN
         XINBTA = 0.0001D+00
      ELSEIF (XINBTA.GE.0.9999D+00) THEN
         XINBTA = 0.9999D+00
      ENDIF
      XSAV = XINBTA
C
C The starting estimate XINBTA has now been calculated
C
C......................................................................
C
C Prepare for Newton Raphson
C
      R = ONE - PP
      T = ONE - QQ
      YPREV = ZERO
      SQ = ONE
      PREV = ONE
      ICOUNT = 0
C
C The new code suggested by Berry, Mielke and Grant
C
      FPU = TEN**SAE
      IEX = MAX(-FIVE/PP**2 - ONE/A**0.2D+00 - 13.0D+00, SAE)
      ACU = TEN**IEX
C
C Main cycling point for the iteration
C
   20 CONTINUE
      ICOUNT = ICOUNT + 1
C
C Function evaluation: X1 = lower tail area
C
      I = 1
      TOL = TOLVAL
      XTEMP = XINBTA
      CALL G01EEF$(XTEMP, PP, QQ, TOL, X1, X2, X3, I)
      IF (I.EQ.0) THEN
         Y = X1
         TEMP = BETA + R*LOG(XINBTA) + T*LOG(ONE - XINBTA)
         IF (TEMP.LE.EXPBOT) THEN
            TEMP = EXPBOT
         ELSEIF (TEMP.GE.EXPTOP) THEN
            TEMP = EXPTOP
         ENDIF
         Y = (Y - A)*EXP(TEMP)
         IF (Y*YPREV.LE.ZERO) PREV = MAX(SQ, FPU)
         G = ONE
C
C Adjust if required
C
         JCOUNT = 0
   40    CONTINUE
         JCOUNT = JCOUNT + 1
         ADJ = G*Y
         SQ = ADJ*ADJ
         IF (SQ.GE.PREV) THEN
            IF (JCOUNT.LE.NMAX) THEN
               G = G/THREE
               GOTO 40
            ENDIF
         ENDIF
         TX = XINBTA - ADJ
         IF (TX.LT.ZERO .OR. TX.GT.ONE) THEN
            IF (JCOUNT.LE.NMAX) THEN
               G = G/THREE
               GOTO 40
            ENDIF
         ENDIF
C
C Check to see if it has converged or used up iterations
C
         IF (ICOUNT.EQ.NMAX .OR. PREV.LE.ACU .OR. Y*Y.LE.ACU .OR.
     +       ABS(TX - XINBTA).LE.EPSI) GOTO 60
         IF (TX.LE.XMIN .OR. TX.GE.XMAX) THEN
            IF (JCOUNT.LE.NMAX) THEN
               G = G/THREE
               GOTO 40
            ENDIF
         ENDIF
         XINBTA = TX
C
C Reflect back extreme values
C
         IF (XINBTA.LE.AMIN) THEN
            XINBTA = AMIN
         ELSEIF (XINBTA.GE.AMAX) THEN
            XINBTA = AMAX
         ENDIF
         YPREV = Y
         GOTO 20
      ENDIF
C
C Final calculation
C
   60 CONTINUE
C
C First check if the iteration has improved the solution
C
      I = 1
      TOL = TOLVAL
      XTEMP = XSAV
      CALL G01EEF$(XTEMP, PP, QQ, TOL, X1, X2, X3, I)
      F1 = X1 - A
      I = 1
      TOL = TOLVAL
      XTEMP = XINBTA
      CALL G01EEF$(XTEMP, PP, QQ, TOL, X1, X2, X3, I)
      F2 = X1 - A
C
C If not swap XSAV for XINBTA
C
      IF (ABS(F1).LT.ABS(F2)) XINBTA = XSAV
C
C Reverse tails if necessary
C
      IF (INDEX1) XINBTA = ONE - XINBTA
      G01FEF$ = XINBTA
      IF (G01FEF$.LT.ZERO) THEN
         G01FEF$ = ZERO
      ELSEIF (G01FEF$.GT.ONE) THEN
         G01FEF$ = ONE
      ENDIF
      END
C
C
