C
C
      DOUBLE PRECISION FUNCTION G01FFF$(P, A, B, TOL, IFAIL)
C
C ACTION: gamma deviates
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 11/10/2000
C         This version just calls G01FCF$ and does not use TOL
C
      IMPLICIT NONE
      INTEGER  IFAIL
      DOUBLE PRECISION A, B, P, TOL
      DOUBLE PRECISION CHI, DOF
      DOUBLE PRECISION ZERO, ONE, TWO, AMAX
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           AMAX = 1.0D+06)
      DOUBLE PRECISION G01FCF$
      EXTERNAL G01FCF$
      G01FFF$ = ZERO
      IFAIL = 0
      IF (P.LT.ZERO .OR. P.GE.ONE) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (A.LE.ZERO .OR. A.GT.AMAX .OR. B.LE.ZERO) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (TOL.LE.ZERO) THEN
         IFAIL = 6
         RETURN
      ENDIF
      DOF = TWO*A
      CHI = G01FCF$(P, DOF, IFAIL)
      IF (IFAIL.NE.0) RETURN
      G01FFF$ = B*CHI/TWO
      END
C
C
