C
C
C The AS190 code PRTRNG, QTRNG, QTRNG0 is in G01EMF$
C
C
      DOUBLE PRECISION FUNCTION G01FMF$(P, V, IR, IFAIL)
C
C ACTION: Substitute for G01FMF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 09/12/99
C         This version just uses the AS190 method for 0.5 < p < 0.99
C         and does not use the NAG C05AZF refinement. For p < 0.9
C         it simply returns zero.
C
      IMPLICIT NONE
      INTEGER  IFAIL, IR
      INTEGER  IFAULT
      DOUBLE PRECISION P, V
      DOUBLE PRECISION QTRNG, R
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION PNT9, PNT99
      PARAMETER (PNT9 = 0.90D+00, PNT99 = 0.99D+00)
      EXTERNAL QTRNG
      INTRINSIC DBLE
      IFAIL = 0
      G01FMF$ = ZERO
C
C Is it safe ?
C
      IF (P.LE.ZERO .OR. P.GE.ONE .OR. V.LT.ONE .OR. IR.LT.2) THEN
         IFAIL = 1
         RETURN
      ENDIF
      R = DBLE(IR)
      IF (P.GE.PNT9 .AND. P.LE.PNT99) G01FMF$ = QTRNG (P, V, R, IFAULT)
      END
C
C
